/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.functions;

import com.sap.sse.datamining.annotations.Connector;
import com.sap.sse.datamining.annotations.Dimension;
import com.sap.sse.datamining.annotations.Statistic;
import com.sap.sse.datamining.functions.ParameterProvider;
import com.sap.sse.datamining.impl.functions.AbstractFunction;
import com.sap.sse.datamining.impl.functions.AdditionalMethodWrappingFunctionData;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;

public class MethodWrappingFunction<ReturnType>
extends AbstractFunction<ReturnType> {
    private final Method method;
    private final Class<ReturnType> returnType;
    private final AdditionalMethodWrappingFunctionData additionalData;
    private final String simpleName;

    public MethodWrappingFunction(Method method, Class<ReturnType> returnType) throws IllegalArgumentException {
        super(MethodWrappingFunction.isMethodADimension(method));
        this.checkThatReturnTypesMatch(method, returnType);
        this.method = method;
        this.returnType = returnType;
        this.additionalData = this.initializeAdditionalData();
        String parametersAsString = this.parametersAsString();
        StringBuilder simpleNameBuilder = new StringBuilder(method.getName().length() + parametersAsString.length() + 2);
        simpleNameBuilder.append(method.getName()).append('(').append(parametersAsString).append(')');
        this.simpleName = simpleNameBuilder.toString();
    }

    private static boolean isMethodADimension(Method method) {
        return method.getAnnotation(Dimension.class) != null;
    }

    private void checkThatReturnTypesMatch(Method method, Class<ReturnType> returnType) {
        if (!method.getReturnType().equals(returnType)) {
            throw new IllegalArgumentException("The method return type " + method.getReturnType().getName() + " and expected return type " + returnType.getName() + " don't match");
        }
    }

    private AdditionalMethodWrappingFunctionData initializeAdditionalData() {
        AdditionalMethodWrappingFunctionData result;
        if (this.method.getAnnotation(Connector.class) != null) {
            Connector connectorData = this.method.getAnnotation(Connector.class);
            result = new AdditionalMethodWrappingFunctionData(connectorData.messageKey(), 0, connectorData.ordinal());
        } else if (this.method.getAnnotation(Statistic.class) != null) {
            Statistic statisticData = this.method.getAnnotation(Statistic.class);
            result = new AdditionalMethodWrappingFunctionData(statisticData.messageKey(), statisticData.resultDecimals(), statisticData.ordinal());
        } else if (this.method.getAnnotation(Dimension.class) != null) {
            Dimension dimensionData = this.method.getAnnotation(Dimension.class);
            result = new AdditionalMethodWrappingFunctionData(dimensionData.messageKey(), 0, dimensionData.ordinal());
        } else {
            result = new AdditionalMethodWrappingFunctionData("", 0, Integer.MAX_VALUE);
        }
        return result;
    }

    @Override
    public Class<?> getDeclaringType() {
        return this.method.getDeclaringClass();
    }

    @Override
    public Iterable<Class<?>> getParameters() {
        return Arrays.asList(this.method.getParameterTypes());
    }

    @Override
    public Class<ReturnType> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean needsLocalizationParameters() {
        Iterator<Class<?>> parameterTypesIterator = this.getParameters().iterator();
        int parameterCount = 0;
        while (parameterTypesIterator.hasNext()) {
            ++parameterCount;
            parameterTypesIterator.next();
        }
        if (parameterCount != 2) {
            return false;
        }
        parameterTypesIterator = this.getParameters().iterator();
        Class<Locale> firstParameter = parameterTypesIterator.next();
        Class<ResourceBundleStringMessages> secondParameter = parameterTypesIterator.next();
        return firstParameter.isAssignableFrom(Locale.class) && secondParameter.isAssignableFrom(ResourceBundleStringMessages.class);
    }

    @Override
    public ReturnType tryToInvoke(Object instance) {
        return this.tryToInvoke(instance, new Object[0]);
    }

    @Override
    public ReturnType tryToInvoke(Object instance, ParameterProvider parameterProvider) {
        if (this.method.getParameterCount() == 0) {
            return this.tryToInvoke(instance);
        }
        Object[] paramValues = new Object[this.method.getParameterCount()];
        System.arraycopy(parameterProvider.getParameters(), 0, paramValues, 0, paramValues.length);
        return this.tryToInvoke(instance, paramValues);
    }

    private ReturnType tryToInvoke(Object instance, Object ... parameters) {
        if (instance != null) {
            try {
                return (ReturnType)this.method.invoke(instance, parameters);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.getLogger().log(Level.FINER, "Error invoking the Function " + this.method.getName(), e);
            }
        }
        return null;
    }

    @Override
    public int getResultDecimals() {
        return this.additionalData.getResultDecimals();
    }

    @Override
    public int getOrdinal() {
        return this.additionalData.getOrdinal();
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    private String parametersAsString() {
        StringBuilder parameterBuilder = new StringBuilder();
        boolean first = true;
        for (Class<?> parameterType : this.getParameters()) {
            if (!first) {
                parameterBuilder.append(", ");
            }
            parameterBuilder.append(parameterType.getName());
            first = false;
        }
        return parameterBuilder.toString();
    }

    @Override
    public String getLocalizedName(Locale locale, ResourceBundleStringMessages stringMessages) {
        if (!this.isLocalizable()) {
            return this.getSimpleName();
        }
        return stringMessages.get(locale, this.additionalData.getMessageKey());
    }

    @Override
    public boolean isLocalizable() {
        return this.additionalData != null && !this.additionalData.getMessageKey().isEmpty();
    }

    public String toString() {
        return String.valueOf(this.getDeclaringType().getSimpleName()) + "." + this.method.getName() + "(" + this.parametersAsSimpleString() + ") : " + this.method.getReturnType().getSimpleName();
    }

    private String parametersAsSimpleString() {
        StringBuilder parameterBuilder = new StringBuilder();
        boolean first = true;
        for (Class<?> parameterType : this.getParameters()) {
            if (!first) {
                parameterBuilder.append(", ");
            }
            parameterBuilder.append(parameterType.getSimpleName());
            first = false;
        }
        return parameterBuilder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodWrappingFunction other = (MethodWrappingFunction)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }
}

