/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.data;

import com.sap.sse.datamining.data.ClusterBoundary;
import com.sap.sse.datamining.impl.data.ComparisonStrategy;
import java.io.Serializable;

public abstract class AbstractClusterBoundary<ElementType extends Serializable>
implements ClusterBoundary<ElementType> {
    private static final long serialVersionUID = 513488430319010656L;
    private final ElementType boundaryValue;
    private final ComparisonStrategy strategy;

    public AbstractClusterBoundary(ElementType boundaryValue, ComparisonStrategy strategy) {
        this.boundaryValue = boundaryValue;
        this.strategy = strategy;
    }

    @Override
    public boolean contains(ElementType value) {
        return this.strategy.validateComparisonResult(this.compare(value));
    }

    protected abstract int compare(ElementType var1);

    @Override
    public ElementType getBoundaryValue() {
        return this.boundaryValue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.strategy == ComparisonStrategy.GREATER_EQUALS_THAN || this.strategy == ComparisonStrategy.GREATER_THAN) {
            builder.append(this.strategy.getSignifier());
        }
        builder.append(this.boundaryValue);
        if (this.strategy == ComparisonStrategy.LOWER_EQUALS_THAN || this.strategy == ComparisonStrategy.LOWER_THAN) {
            builder.append(this.strategy.getSignifier());
        }
        return builder.toString();
    }

    @Override
    public ComparisonStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public Class<ElementType> getClusterElementsType() {
        return this.boundaryValue.getClass();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundaryValue == null ? 0 : this.boundaryValue.hashCode());
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractClusterBoundary other = (AbstractClusterBoundary)obj;
        if (this.boundaryValue == null ? other.boundaryValue != null : !this.boundaryValue.equals(other.boundaryValue)) {
            return false;
        }
        return this.strategy == other.strategy;
    }
}

