/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.datamining.components.management.MemoryMonitorAction;

public abstract class AbstractMemoryMonitorAction
implements MemoryMonitorAction {
    private final double thresholdFreeMemoryRatio;
    private final long minFreeMemoryInBytes;

    public AbstractMemoryMonitorAction(double freeMemoryRatioThreshold, long minFreeMemoryInBytes) {
        this.thresholdFreeMemoryRatio = freeMemoryRatioThreshold;
        this.minFreeMemoryInBytes = minFreeMemoryInBytes;
    }

    @Override
    public double getThreshold() {
        return this.thresholdFreeMemoryRatio;
    }

    @Override
    public boolean checkMemoryAndPerformAction(double freeMemoryRatio, long freeMemoryInBytes) {
        if (freeMemoryRatio < this.thresholdFreeMemoryRatio && freeMemoryInBytes < this.minFreeMemoryInBytes) {
            this.performAction();
            return true;
        }
        return false;
    }

    public abstract void performAction();

    @Override
    public int compareTo(MemoryMonitorAction other) {
        return Double.compare(this.getThreshold(), other.getThreshold());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[threshold: " + this.getThreshold() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.thresholdFreeMemoryRatio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMemoryMonitorAction other = (AbstractMemoryMonitorAction)obj;
        return Double.doubleToLongBits(this.thresholdFreeMemoryRatio) == Double.doubleToLongBits(other.thresholdFreeMemoryRatio);
    }
}

