/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ParallelGroupedNumberDataSumAggregationProcessor
extends AbstractParallelGroupedDataAggregationProcessor<Number, Number> {
    private static final AggregationProcessorDefinition<Number, Number> DEFINITION = new SimpleAggregationProcessorDefinition<Number, Number>(Number.class, Number.class, "Sum", ParallelGroupedNumberDataSumAggregationProcessor.class);
    private Map<GroupKey, Number> result = new HashMap<GroupKey, Number>();

    public static AggregationProcessorDefinition<Number, Number> getDefinition() {
        return DEFINITION;
    }

    public ParallelGroupedNumberDataSumAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, Number>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Sum");
    }

    @Override
    protected void handleElement(GroupedDataEntry<Number> element) {
        GroupKey key = element.getKey();
        if (!this.result.containsKey(key)) {
            this.result.put(key, element.getDataEntry());
        } else {
            this.result.put(key, this.result.get(key).doubleValue() + element.getDataEntry().doubleValue());
        }
    }

    @Override
    protected Map<GroupKey, Number> getResult() {
        return this.result;
    }
}

