/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.data.AverageWithStats;
import com.sap.sse.datamining.shared.impl.AverageWithStatsImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class ParallelGroupedNumberDataAverageAggregationProcessor
extends AbstractParallelGroupedDataStoringAggregationProcessor<Number, AverageWithStats<Number>> {
    private static final Class<?> _c = AverageWithStats.class;
    private static final Class<AverageWithStats<Number>> _cc = _c;
    private static final AggregationProcessorDefinition<Number, AverageWithStats<Number>> DEFINITION = new SimpleAggregationProcessorDefinition<Number, AverageWithStats<Number>>(Number.class, _cc, "Average", ParallelGroupedNumberDataAverageAggregationProcessor.class);
    private final Map<GroupKey, double[]> sumPerKey;
    private final Map<GroupKey, Double> minPerKey;
    private final Map<GroupKey, Double> maxPerKey;
    private final Map<GroupKey, AtomicLong> elementAmountPerKey = new HashMap<GroupKey, AtomicLong>();

    public static AggregationProcessorDefinition<Number, AverageWithStats<Number>> getDefinition() {
        return DEFINITION;
    }

    public ParallelGroupedNumberDataAverageAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, AverageWithStats<Number>>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Average");
        this.sumPerKey = new HashMap<GroupKey, double[]>();
        this.minPerKey = new HashMap<GroupKey, Double>();
        this.maxPerKey = new HashMap<GroupKey, Double>();
    }

    @Override
    protected void storeElement(GroupedDataEntry<Number> element) {
        if (element.getDataEntry() != null) {
            this.incrementElementAmount(element);
            double[] aggregate = this.sumPerKey.get(element.getKey());
            double doubleValue = element.getDataEntry().doubleValue();
            if (aggregate == null) {
                aggregate = new double[]{doubleValue};
                this.sumPerKey.put(element.getKey(), aggregate);
            } else {
                aggregate[0] = aggregate[0] + doubleValue;
            }
            if (!this.minPerKey.containsKey(element.getKey()) || doubleValue < this.minPerKey.get(element.getKey())) {
                this.minPerKey.put(element.getKey(), doubleValue);
            }
            if (!this.maxPerKey.containsKey(element.getKey()) || doubleValue > this.maxPerKey.get(element.getKey())) {
                this.maxPerKey.put(element.getKey(), doubleValue);
            }
        }
    }

    private void incrementElementAmount(GroupedDataEntry<Number> element) {
        GroupKey key = element.getKey();
        AtomicLong currentAmount = this.elementAmountPerKey.get(key);
        if (currentAmount == null) {
            this.elementAmountPerKey.put(key, new AtomicLong(1L));
        } else {
            currentAmount.incrementAndGet();
        }
    }

    @Override
    protected Map<GroupKey, AverageWithStats<Number>> aggregateResult() {
        HashMap<GroupKey, AverageWithStats<Number>> result = new HashMap<GroupKey, AverageWithStats<Number>>();
        for (Map.Entry<GroupKey, double[]> sumAggregationEntry : this.sumPerKey.entrySet()) {
            if (this.isAborted()) break;
            GroupKey key = sumAggregationEntry.getKey();
            result.put(key, (AverageWithStats<Number>)new AverageWithStatsImpl((Object)(sumAggregationEntry.getValue()[0] / (double)this.elementAmountPerKey.get(key).get()), (Object)this.minPerKey.get(key), (Object)this.maxPerKey.get(key), null, null, this.elementAmountPerKey.get(key).get(), Number.class.getName()));
        }
        return result;
    }
}

