/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ParallelGroupedDataCountAggregationProcessor
extends AbstractParallelGroupedDataAggregationProcessor<Object, Number> {
    private static final AggregationProcessorDefinition<Object, Number> DEFINITION = new SimpleAggregationProcessorDefinition<Object, Number>(Object.class, Number.class, "Count", ParallelGroupedDataCountAggregationProcessor.class);
    private Map<GroupKey, Number> countMap = new HashMap<GroupKey, Number>();

    public static AggregationProcessorDefinition<Object, Number> getDefinition() {
        return DEFINITION;
    }

    public ParallelGroupedDataCountAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, Number>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Count");
    }

    @Override
    protected void handleElement(GroupedDataEntry<Object> element) {
        GroupKey key = element.getKey();
        if (!this.countMap.containsKey(key)) {
            this.countMap.put(key, 0.0);
        }
        Double currentAmount = this.countMap.get(key).doubleValue();
        this.countMap.put(key, currentAmount + 1.0);
    }

    @Override
    protected Map<GroupKey, Number> getResult() {
        return this.countMap;
    }

    @Override
    protected void setAdditionalData(AdditionalResultDataBuilder additionalDataBuilder) {
        super.setAdditionalData(additionalDataBuilder);
        additionalDataBuilder.setResultDecimals(0);
    }
}

