/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.components.DataRetrieverChainBuilder;
import com.sap.sse.datamining.components.FilterCriterion;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import com.sap.sse.datamining.impl.components.ParallelFilteringProcessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class SimpleDataRetrieverChainBuilder<DataSourceType>
implements DataRetrieverChainBuilder<DataSourceType> {
    private final ExecutorService executor;
    private final List<DataRetrieverLevel<?, ?>> retrieverLevels;
    private final Map<Integer, FilterCriterion<?>> filters;
    private final Map<Integer, Collection<Processor<?, ?>>> receivers;
    private final Map<Integer, SerializableSettings> settings;
    private int currentRetrieverLevelIndex;

    SimpleDataRetrieverChainBuilder(ExecutorService executor, List<DataRetrieverLevel<?, ?>> dataRetrieverTypesWithInformation) {
        this.executor = executor;
        this.retrieverLevels = new ArrayList(dataRetrieverTypesWithInformation);
        this.filters = new HashMap();
        this.receivers = new HashMap();
        this.settings = new HashMap<Integer, SerializableSettings>();
        this.currentRetrieverLevelIndex = -1;
    }

    @Override
    public boolean canStepFurther() {
        return this.currentRetrieverLevelIndex + 1 < this.retrieverLevels.size();
    }

    @Override
    public DataRetrieverChainBuilder<DataSourceType> stepFurther() {
        if (!this.canStepFurther()) {
            throw new IllegalStateException("The builder can't step any further");
        }
        ++this.currentRetrieverLevelIndex;
        return this;
    }

    @Override
    public DataRetrieverChainBuilder<DataSourceType> setFilter(FilterCriterion<?> filter) {
        if (!this.hasBeenInitialized()) {
            throw new IllegalStateException("The builder hasn't been initialized");
        }
        if (!filter.getElementType().isAssignableFrom(this.getCurrentRetrievedDataType())) {
            throw new IllegalArgumentException("The given filter (with element type '" + filter.getElementType().getSimpleName() + "') isn't able to match the current retrieved data type '" + this.getCurrentRetrievedDataType().getSimpleName() + "'");
        }
        this.filters.put(this.currentRetrieverLevelIndex, filter);
        return this;
    }

    @Override
    public <SettingsType extends SerializableSettings> DataRetrieverChainBuilder<DataSourceType> setSettings(SettingsType settings) {
        if (!this.hasBeenInitialized()) {
            throw new IllegalStateException("The builder hasn't been initialized");
        }
        if (this.getCurrentRetrieverLevel().getSettingsType() == null) {
            throw new IllegalStateException("The current retrieval level " + this.getCurrentRetrieverLevel() + " has no settings.");
        }
        if (!this.getCurrentRetrieverLevel().getSettingsType().isAssignableFrom(settings.getClass())) {
            throw new IllegalArgumentException("The given settings (with type '" + settings.getClass().getSimpleName() + "') isn't applicable for the settings type of the current retriever Level '" + this.getCurrentRetrieverLevel().getSettingsType().getSimpleName() + "'");
        }
        this.settings.put(this.currentRetrieverLevelIndex, settings);
        return this;
    }

    @Override
    public DataRetrieverChainBuilder<DataSourceType> addResultReceiver(Processor<?, ?> resultReceiver) {
        if (!this.hasBeenInitialized()) {
            throw new IllegalStateException("The builder hasn't been initialized");
        }
        if (!resultReceiver.getInputType().isAssignableFrom(this.getCurrentRetrievedDataType())) {
            throw new IllegalArgumentException("The given result receiver (with input type '" + resultReceiver.getInputType().getSimpleName() + "') isn't able to process the current retrieved data type '" + this.getCurrentRetrievedDataType().getSimpleName() + "'");
        }
        if (!this.receivers.containsKey(this.currentRetrieverLevelIndex)) {
            this.receivers.put(this.currentRetrieverLevelIndex, new HashSet());
        }
        this.receivers.get(this.currentRetrieverLevelIndex).add(resultReceiver);
        return this;
    }

    @Override
    public Class<?> getCurrentRetrievedDataType() {
        if (!this.hasBeenInitialized()) {
            throw new IllegalStateException("The builder hasn't been initialized");
        }
        return this.retrieverLevels.get(this.currentRetrieverLevelIndex).getRetrievedDataType();
    }

    @Override
    public DataRetrieverLevel<?, ?> getCurrentRetrieverLevel() {
        return this.hasBeenInitialized() ? this.retrieverLevels.get(this.currentRetrieverLevelIndex) : null;
    }

    @Override
    public Processor<DataSourceType, ?> build() {
        if (!this.hasBeenInitialized()) {
            throw new IllegalStateException("The builder hasn't been initialized");
        }
        Processor firstRetriever = null;
        int retrieverLevelIndex = this.currentRetrieverLevelIndex;
        while (retrieverLevelIndex >= 0) {
            DataRetrieverLevel<?, ?> retrieverLevel = this.retrieverLevels.get(retrieverLevelIndex);
            firstRetriever = this.createRetriever(retrieverLevel, firstRetriever, retrieverLevelIndex);
            --retrieverLevelIndex;
        }
        return firstRetriever;
    }

    @Override
    public boolean hasBeenInitialized() {
        return this.currentRetrieverLevelIndex >= 0;
    }

    private <ResultType> Processor<?, ResultType> createRetriever(DataRetrieverLevel<?, ?> retrieverLevel, Processor<?, ?> previousRetriever, int retrieverLevelIndex) {
        ArrayList resultReceivers;
        Class<?> retrievedDataType = retrieverLevel.getRetrievedDataType();
        Collection<Processor<?, ?>> storedResultReceivers = this.receivers.get(retrieverLevelIndex);
        ArrayList<Processor<Object, Object>> arrayList = resultReceivers = storedResultReceivers != null ? new ArrayList(storedResultReceivers) : new ArrayList();
        if (previousRetriever != null) {
            resultReceivers.add(previousRetriever);
        }
        FilterCriterion<?> filter = this.filters.get(retrieverLevelIndex);
        Class<Processor<?, ResultType>> retrieverType = retrieverLevel.getRetrieverType();
        Class<?> settingsType = retrieverLevel.getSettingsType();
        String retrievedDataTypeMessageKey = retrieverLevel.getRetrievedDataTypeMessageKey();
        return this.createRetriever(retrieverType, retrievedDataType, resultReceivers, filter, settingsType, retrieverLevelIndex, retrievedDataTypeMessageKey);
    }

    private <ResultType> Processor<?, ResultType> createRetriever(Class<Processor<?, ResultType>> retrieverType, Class<ResultType> retrievedDataType, Collection<Processor<ResultType, ?>> resultReceivers, FilterCriterion<ResultType> filter, Class<?> settingsType, int retrieverLevelIndex, String retrievedDataTypeMessageKey) {
        Constructor<Processor<?, ResultType>> retrieverConstructor = null;
        try {
            retrieverConstructor = settingsType == null ? retrieverType.getConstructor(ExecutorService.class, Collection.class, Integer.TYPE, String.class) : retrieverType.getConstructor(ExecutorService.class, Collection.class, settingsType, Integer.TYPE, String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Couldn't get an usable constructor from the given retrieverType '" + retrieverType.getSimpleName() + "'", e);
        }
        SerializableSettings settings = null;
        if (settingsType != null) {
            SerializableSettings storedSettings = this.settings.get(retrieverLevelIndex);
            settings = storedSettings != null ? storedSettings : this.retrieverLevels.get(retrieverLevelIndex).getDefaultSettings();
        }
        return this.constructRetriever(retrieverConstructor, retrievedDataType, resultReceivers, filter, settings, settingsType, retrieverLevelIndex, retrievedDataTypeMessageKey);
    }

    private <ResultType> Processor<?, ResultType> constructRetriever(Constructor<Processor<?, ResultType>> retrieverConstructor, Class<ResultType> retrievedDataType, Collection<Processor<ResultType, ?>> resultReceivers, FilterCriterion<ResultType> filter, SerializableSettings settings, Class<?> settingsType, int retrieverLevelIndex, String retrievedDataTypeMessageKey) {
        try {
            Collection retrievalResultReceivers = resultReceivers;
            if (filter != null) {
                ParallelFilteringProcessor<ResultType> filteringProcessor = new ParallelFilteringProcessor<ResultType>(retrievedDataType, this.executor, resultReceivers, filter);
                retrievalResultReceivers = new ArrayList();
                retrievalResultReceivers.add(filteringProcessor);
            }
            if (Modifier.isPublic(retrieverConstructor.getModifiers())) {
                retrieverConstructor.setAccessible(true);
            }
            if (settingsType == null) {
                return retrieverConstructor.newInstance(this.executor, retrievalResultReceivers, retrieverLevelIndex, retrievedDataTypeMessageKey);
            }
            return retrieverConstructor.newInstance(this.executor, retrievalResultReceivers, settings, retrieverLevelIndex, retrievedDataTypeMessageKey);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Couldn't create a data retriever instance with the constructor " + retrieverConstructor.toString(), e);
        }
    }
}

