/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class SimpleAggregationProcessorDefinition<ExtractedType, AggregatedType>
implements AggregationProcessorDefinition<ExtractedType, AggregatedType> {
    private final Class<ExtractedType> extractedType;
    private final Class<AggregatedType> aggregatedType;
    private final String aggregationNameMessageKey;
    private final Class<? extends AbstractParallelGroupedDataAggregationProcessor<ExtractedType, AggregatedType>> aggregationProcessor;
    private final Constructor<? extends AbstractParallelGroupedDataAggregationProcessor<ExtractedType, AggregatedType>> constructor;

    public SimpleAggregationProcessorDefinition(Class<ExtractedType> extractedType, Class<AggregatedType> aggregatedType, String aggregationNameMessageKey, Class<? extends AbstractParallelGroupedDataAggregationProcessor<ExtractedType, AggregatedType>> aggregationProcessor) {
        this.extractedType = extractedType;
        this.aggregatedType = aggregatedType;
        this.aggregationNameMessageKey = aggregationNameMessageKey;
        this.aggregationProcessor = aggregationProcessor;
        this.constructor = this.ensureValidConstructor(aggregationProcessor);
    }

    private Constructor<? extends AbstractParallelGroupedDataAggregationProcessor<ExtractedType, AggregatedType>> ensureValidConstructor(Class<? extends AbstractParallelGroupedDataAggregationProcessor<ExtractedType, AggregatedType>> aggregationProcessor) {
        try {
            Constructor<AbstractParallelGroupedDataAggregationProcessor<ExtractedType, AggregatedType>> constructor = aggregationProcessor.getConstructor(ExecutorService.class, Collection.class);
            if (Modifier.isPublic(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Couldn't get an usable constructor from the given aggregatorProcessor '" + aggregationProcessor.getSimpleName() + "'", e);
        }
    }

    @Override
    public Class<ExtractedType> getExtractedType() {
        return this.extractedType;
    }

    @Override
    public Class<AggregatedType> getAggregatedType() {
        return this.aggregatedType;
    }

    @Override
    public String getAggregationNameMessageKey() {
        return this.aggregationNameMessageKey;
    }

    @Override
    public Class<? extends AbstractParallelGroupedDataAggregationProcessor<ExtractedType, AggregatedType>> getAggregationProcessor() {
        return this.aggregationProcessor;
    }

    @Override
    public Processor<GroupedDataEntry<ExtractedType>, Map<GroupKey, AggregatedType>> construct(ExecutorService executor, Collection<Processor<Map<GroupKey, AggregatedType>, ?>> resultReceivers) {
        try {
            return this.constructor.newInstance(executor, resultReceivers);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Couldn't create an aggregator instance with the constructor " + this.constructor.toString(), e);
        }
    }

    public String toString() {
        return String.valueOf(this.aggregationProcessor.getSimpleName()) + "[messageKey: " + this.aggregationNameMessageKey + ", extractedType: " + this.extractedType.getSimpleName() + ", aggregatedType: " + this.aggregatedType.getSimpleName() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregatedType == null ? 0 : this.aggregatedType.hashCode());
        result = 31 * result + (this.aggregationNameMessageKey == null ? 0 : this.aggregationNameMessageKey.hashCode());
        result = 31 * result + (this.aggregationProcessor == null ? 0 : this.aggregationProcessor.hashCode());
        result = 31 * result + (this.extractedType == null ? 0 : this.extractedType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleAggregationProcessorDefinition other = (SimpleAggregationProcessorDefinition)obj;
        if (this.aggregatedType == null ? other.aggregatedType != null : !this.aggregatedType.equals(other.aggregatedType)) {
            return false;
        }
        if (this.aggregationNameMessageKey == null ? other.aggregationNameMessageKey != null : !this.aggregationNameMessageKey.equals(other.aggregationNameMessageKey)) {
            return false;
        }
        if (this.aggregationProcessor == null ? other.aggregationProcessor != null : !this.aggregationProcessor.equals(other.aggregationProcessor)) {
            return false;
        }
        return !(this.extractedType == null ? other.extractedType != null : !this.extractedType.equals(other.extractedType));
    }
}

