/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.functions.IdentityFunction;
import com.sap.sse.datamining.shared.AdditionalResultData;
import com.sap.sse.datamining.shared.impl.AdditionalResultDataImpl;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.util.Locale;

public class OverwritingResultDataBuilder
implements AdditionalResultDataBuilder {
    private static final Function<?> IdentityFunction = new IdentityFunction();
    private int retrievedDataAmount = 0;
    private String dataTypeMessageKey;
    private Function<?> extractionFunction;
    private String aggregationNameMessageKey;
    private int resultDecimals = 0;

    @Override
    public AdditionalResultData build(long calculationTimeInNanos, ResourceBundleStringMessages stringMessages, Locale locale) {
        String resultSignifier = this.buildResultSignifier(stringMessages, locale);
        return new AdditionalResultDataImpl(this.retrievedDataAmount, resultSignifier, this.resultDecimals, calculationTimeInNanos);
    }

    private String buildResultSignifier(ResourceBundleStringMessages stringMessages, Locale locale) {
        if (this.extractionFunction == null || this.aggregationNameMessageKey == null) {
            return "";
        }
        String extractedStatisticName = this.extractionFunction.equals(IdentityFunction) ? stringMessages.get(locale, this.dataTypeMessageKey) : this.extractionFunction.getLocalizedName(locale, stringMessages);
        String aggregationName = stringMessages.get(locale, this.aggregationNameMessageKey);
        return stringMessages.get(locale, "ResultSignifier", new String[]{extractedStatisticName, aggregationName});
    }

    @Override
    public void setRetrievedDataAmount(int retrievedDataAmount) {
        this.retrievedDataAmount = retrievedDataAmount;
    }

    @Override
    public int getRetrievedDataAmount() {
        return this.retrievedDataAmount;
    }

    @Override
    public void setDataTypeMessageKey(String dataTypeMessageKey) {
        this.dataTypeMessageKey = dataTypeMessageKey;
    }

    public String getDataTypeMessageKey() {
        return this.dataTypeMessageKey;
    }

    @Override
    public void setExtractionFunction(Function<?> extractionFunction) {
        this.extractionFunction = extractionFunction;
        this.setResultDecimals(extractionFunction.getResultDecimals());
    }

    @Override
    public void setResultDecimals(int resultDecimals) {
        this.resultDecimals = resultDecimals;
    }

    @Override
    public void setAggregationNameMessageKey(String aggregationNameMessageKey) {
        this.aggregationNameMessageKey = aggregationNameMessageKey;
    }
}

