/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.components.ProcessorInstruction;
import com.sap.sse.datamining.components.ProcessorInstructionHandler;
import com.sap.sse.datamining.impl.components.AbstractProcessor;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.subject.Subject;

public abstract class AbstractParallelProcessor<InputType, ResultType>
extends AbstractProcessor<InputType, ResultType>
implements ProcessorInstructionHandler<ResultType> {
    private static final Logger LOGGER = Logger.getLogger(AbstractParallelProcessor.class.getName());
    private static final int SLEEP_TIME_DURING_FINISHING = 100;
    private final Processor<ResultType, ?>[] resultReceivers;
    private final ExecutorService executor;
    private final AtomicInteger unfinishedInstructionsCounter;
    private boolean isFinished = false;
    private boolean isAborted = false;

    public AbstractParallelProcessor(Class<InputType> inputType, Class<ResultType> resultType, ExecutorService executor, Collection<Processor<ResultType, ?>> resultReceivers) {
        super(inputType, resultType);
        this.executor = executor;
        Processor[] resultReceiversAsArray = new Processor[resultReceivers.size()];
        this.resultReceivers = resultReceivers.toArray(resultReceiversAsArray);
        this.unfinishedInstructionsCounter = new AtomicInteger();
    }

    @Override
    public boolean canProcessElements() {
        return !this.isFinished() && !this.isAborted();
    }

    @Override
    public void processElement(InputType element) {
        ProcessorInstruction<ResultType> instruction;
        if (this.canProcessElements() && this.isInstructionValid(instruction = this.createInstruction(element))) {
            this.unfinishedInstructionsCounter.getAndIncrement();
            try {
                ProcessorInstruction<ResultType> instructionToRun;
                try {
                    Subject subject = SecurityUtils.getSubject();
                    instructionToRun = subject == null ? instruction : subject.associateWith(instruction);
                }
                catch (UnavailableSecurityManagerException e) {
                    instructionToRun = instruction;
                }
                this.executor.execute(instructionToRun);
            }
            catch (RejectedExecutionException exc) {
                LOGGER.log(Level.FINEST, "A " + RejectedExecutionException.class.getSimpleName() + " appeared during the processing.");
                instruction.run();
            }
        }
    }

    private boolean isInstructionValid(ProcessorInstruction<ResultType> instruction) {
        return instruction != null;
    }

    @Override
    public void instructionSucceeded(ResultType result) {
        this.forwardResultToReceivers(result);
    }

    @Override
    public void instructionFailed(Exception e) {
        if (!this.isAborted() || !(e instanceof InterruptedException)) {
            this.onFailure(e);
        }
    }

    @Override
    public void afterInstructionFinished(ProcessorInstruction<ResultType> instruction) {
        this.unfinishedInstructionsCounter.getAndDecrement();
    }

    protected Processor<ResultType, ?>[] getResultReceivers() {
        return this.resultReceivers;
    }

    protected void forwardResultToReceivers(ResultType result) {
        if (this.isResultValid(result) && !this.isAborted()) {
            Processor<ResultType, ?>[] processorArray = this.resultReceivers;
            int n = this.resultReceivers.length;
            int n2 = 0;
            while (n2 < n) {
                Processor<ResultType, ?> resultReceiver = processorArray[n2];
                resultReceiver.processElement(result);
                ++n2;
            }
        }
    }

    private boolean isResultValid(ResultType result) {
        return result != null;
    }

    protected ResultType createInvalidResult() {
        return null;
    }

    protected abstract ProcessorInstruction<ResultType> createInstruction(InputType var1);

    @Override
    public void onFailure(Throwable failure) {
        Processor<ResultType, ?>[] processorArray = this.resultReceivers;
        int n = this.resultReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            Processor<ResultType, ?> resultReceiver = processorArray[n2];
            resultReceiver.onFailure(failure);
            ++n2;
        }
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void finish() throws InterruptedException {
        this.sleepUntilAllInstructionsFinished();
        if (!this.isAborted) {
            this.isFinished = true;
            this.tellResultReceiversToFinish();
        }
    }

    protected void sleepUntilAllInstructionsFinished() throws InterruptedException {
        while (this.areUnfinishedInstructionsLeft() && !this.isAborted) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (this.isAborted) continue;
                this.onFailure(e);
            }
        }
    }

    private boolean areUnfinishedInstructionsLeft() {
        return this.unfinishedInstructionsCounter.get() > 0;
    }

    protected void tellResultReceiversToFinish() {
        Processor<ResultType, ?>[] processorArray = this.resultReceivers;
        int n = this.resultReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            Processor<ResultType, ?> resultReceiver = processorArray[n2];
            try {
                resultReceiver.finish();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, String.valueOf(resultReceiver.toString()) + " was interrupted", e);
            }
            ++n2;
        }
    }

    @Override
    public boolean isAborted() {
        return this.isAborted;
    }

    @Override
    public void abort() {
        this.isAborted = true;
        this.tellResultReceiversToAbort();
        LOGGER.log(Level.INFO, "The processing got aborted.");
    }

    private void tellResultReceiversToAbort() {
        Processor<ResultType, ?>[] processorArray = this.resultReceivers;
        int n = this.resultReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            Processor<ResultType, ?> resultReceiver = processorArray[n2];
            resultReceiver.abort();
            ++n2;
        }
    }

    @Override
    public AdditionalResultDataBuilder getAdditionalResultData(AdditionalResultDataBuilder additionalDataBuilder) {
        this.setAdditionalData(additionalDataBuilder);
        Processor<ResultType, ?>[] processorArray = this.resultReceivers;
        int n = this.resultReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            Processor<ResultType, ?> resultReceiver = processorArray[n2];
            additionalDataBuilder = resultReceiver.getAdditionalResultData(additionalDataBuilder);
            ++n2;
        }
        return additionalDataBuilder;
    }

    protected abstract void setAdditionalData(AdditionalResultDataBuilder var1);
}

