/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl;

import com.sap.sse.common.Base64Utils;
import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.DataSourceProvider;
import com.sap.sse.datamining.ModifiableDataMiningServer;
import com.sap.sse.datamining.Query;
import com.sap.sse.datamining.StatisticQueryDefinition;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.components.management.AggregationProcessorDefinitionProvider;
import com.sap.sse.datamining.components.management.AggregationProcessorDefinitionRegistry;
import com.sap.sse.datamining.components.management.DataRetrieverChainDefinitionProvider;
import com.sap.sse.datamining.components.management.DataRetrieverChainDefinitionRegistry;
import com.sap.sse.datamining.components.management.DataSourceProviderRegistry;
import com.sap.sse.datamining.components.management.FunctionProvider;
import com.sap.sse.datamining.components.management.FunctionRegistry;
import com.sap.sse.datamining.components.management.MemoryMonitor;
import com.sap.sse.datamining.components.management.MemoryMonitorAction;
import com.sap.sse.datamining.components.management.QueryDefinitionDTOProvider;
import com.sap.sse.datamining.components.management.QueryDefinitionDTORegistry;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.factories.QueryFactory;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.ModifiableStatisticQueryDefinition;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import com.sap.sse.datamining.impl.components.management.AbstractMemoryMonitorAction;
import com.sap.sse.datamining.impl.components.management.QueryManagerMemoryMonitor;
import com.sap.sse.datamining.impl.components.management.RuntimeMemoryInfoProvider;
import com.sap.sse.datamining.impl.components.management.StrategyPerQueryTypeManager;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.PredefinedQueryIdentifier;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.i18n.impl.CompoundResourceBundleStringMessages;
import com.sap.sse.shared.classloading.JoinedClassLoader;
import com.sap.sse.util.ObjectInputStreamResolvingAgainstCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataMiningServerImpl
implements ModifiableDataMiningServer {
    private static final Logger logger = Logger.getLogger(DataMiningServerImpl.class.getName());
    private static final long MEMORY_CHECK_PERIOD = 5L;
    private static final TimeUnit MEMORY_CHECK_PERIOD_UNIT = TimeUnit.SECONDS;
    private final Set<ClassLoader> dataMiningClassLoaders = new HashSet<ClassLoader>();
    private final CompoundResourceBundleStringMessages stringMessages;
    private final ExecutorService executorService;
    private Date componentsChangedTimepoint;
    private final QueryFactory queryFactory;
    private final StrategyPerQueryTypeManager dataMiningQueryManager;
    private final MemoryMonitor memoryMonitor;
    private final FunctionRegistry functionRegistry;
    private final DataSourceProviderRegistry dataSourceProviderRegistry;
    private final DataRetrieverChainDefinitionRegistry dataRetrieverChainDefinitionRegistry;
    private final AggregationProcessorDefinitionRegistry aggregationProcessorDefinitionRegistry;
    private final QueryDefinitionDTORegistry queryDefinitionRegistry;

    public DataMiningServerImpl(ExecutorService executorService, FunctionRegistry functionRegistry, DataSourceProviderRegistry dataSourceProviderRegistry, DataRetrieverChainDefinitionRegistry dataRetrieverChainDefinitionRegistry, AggregationProcessorDefinitionRegistry aggregationProcessorDefinitionRegistry, QueryDefinitionDTORegistry queryDefinitionRegistry) {
        this.dataMiningClassLoaders.add(this.getClass().getClassLoader());
        this.stringMessages = new CompoundResourceBundleStringMessages();
        this.executorService = executorService;
        this.componentsChangedTimepoint = new Date();
        this.queryFactory = new QueryFactory();
        this.dataMiningQueryManager = new StrategyPerQueryTypeManager();
        this.memoryMonitor = new QueryManagerMemoryMonitor(new RuntimeMemoryInfoProvider(Runtime.getRuntime()), this.dataMiningQueryManager, this.createMemoryMonitorActions(), 5L, MEMORY_CHECK_PERIOD_UNIT);
        this.functionRegistry = functionRegistry;
        this.dataSourceProviderRegistry = dataSourceProviderRegistry;
        this.dataRetrieverChainDefinitionRegistry = dataRetrieverChainDefinitionRegistry;
        this.aggregationProcessorDefinitionRegistry = aggregationProcessorDefinitionRegistry;
        this.queryDefinitionRegistry = queryDefinitionRegistry;
    }

    private Iterable<MemoryMonitorAction> createMemoryMonitorActions() {
        ArrayList<MemoryMonitorAction> actions = new ArrayList<MemoryMonitorAction>();
        actions.add(new AbstractMemoryMonitorAction(0.1, 0x280000000L){

            @Override
            public void performAction() {
                DataMiningServerImpl.this.memoryMonitor.logWarning("Yellow Alert free memory is below " + 100.0 * this.getThreshold() + "%!");
                int numberOfRunningQueries = DataMiningServerImpl.this.dataMiningQueryManager.getNumberOfRunningQueries();
                if (numberOfRunningQueries > 0) {
                    DataMiningServerImpl.this.memoryMonitor.logWarning("Aborting random query.");
                    DataMiningServerImpl.this.dataMiningQueryManager.abortRandomQuery();
                } else {
                    DataMiningServerImpl.this.memoryMonitor.logWarning("Can't abort random query, because none are running.");
                }
            }
        });
        actions.add(new AbstractMemoryMonitorAction(0.05, 0x140000000L){

            @Override
            public void performAction() {
                DataMiningServerImpl.this.memoryMonitor.logSevere("Red Alert free memory is below " + 100.0 * this.getThreshold() + "%!");
                if (DataMiningServerImpl.this.dataMiningQueryManager.getNumberOfRunningQueries() > 0) {
                    DataMiningServerImpl.this.memoryMonitor.logSevere("Aborting all queries.");
                    DataMiningServerImpl.this.dataMiningQueryManager.abortAllQueries();
                } else {
                    DataMiningServerImpl.this.memoryMonitor.logSevere("Can't abort all queries, because none are running.");
                }
            }
        });
        return actions;
    }

    @Override
    public Date getComponentsChangedTimepoint() {
        return this.componentsChangedTimepoint;
    }

    private void updateComponentsChangedTimepoint() {
        this.componentsChangedTimepoint = new Date();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public JoinedClassLoader getJoinedClassLoader() {
        return new JoinedClassLoader(this.dataMiningClassLoaders);
    }

    /*
     * Loose catch block
     */
    @Override
    public StatisticQueryDefinitionDTO fromBase64String(String string) {
        block20: {
            byte[] bytes;
            try {
                bytes = Base64Utils.fromBase64((String)string);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            ClassLoader oldThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)this.getJoinedClassLoader());
            try {
                ObjectInputStreamResolvingAgainstCache<Object> in;
                Throwable throwable;
                block18: {
                    StatisticQueryDefinitionDTO statisticQueryDefinitionDTO;
                    block19: {
                        throwable = null;
                        Object var5_8 = null;
                        in = new ObjectInputStreamResolvingAgainstCache<Object>((InputStream)new ByteArrayInputStream(bytes), new Object(), null, new HashMap()){};
                        Object o = in.readObject();
                        if (!(o instanceof StatisticQueryDefinitionDTO)) break block18;
                        statisticQueryDefinitionDTO = (StatisticQueryDefinitionDTO)o;
                        if (in == null) break block19;
                        in.close();
                    }
                    return statisticQueryDefinitionDTO;
                }
                try {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block20;
                        {
                            catch (Throwable throwable2) {
                                if (in != null) {
                                    in.close();
                                }
                                throw throwable2;
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    logger.log(Level.SEVERE, "Could not load query", e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldThreadContextClassLoader);
            }
        }
        return null;
    }

    @Override
    public void addDataMiningBundleClassLoader(ClassLoader classLoader) {
        logger.info("Adding data mining bundle class loader " + classLoader);
        this.dataMiningClassLoaders.add(classLoader);
    }

    @Override
    public void removeDataMiningBundleClassLoader(ClassLoader classLoader) {
        logger.info("Removing data mining bundle class loader " + classLoader);
        this.dataMiningClassLoaders.remove(classLoader);
    }

    @Override
    public ResourceBundleStringMessages getStringMessages() {
        return this.stringMessages;
    }

    @Override
    public void addStringMessages(ResourceBundleStringMessages stringMessages) {
        boolean componentsChanged = this.stringMessages.addStringMessages(stringMessages);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public void removeStringMessages(ResourceBundleStringMessages stringMessages) {
        boolean componentsChanged = this.stringMessages.removeStringMessages(stringMessages);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    @Override
    public void registerAllClasses(Iterable<Class<?>> classesToScan) {
        boolean componentsChanged = this.functionRegistry.registerAllClasses(classesToScan);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public void registerAllWithExternalFunctionPolicy(Iterable<Class<?>> externalClassesToScan) {
        boolean componentsChanged = this.functionRegistry.registerAllWithExternalFunctionPolicy(externalClassesToScan);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public void unregisterAllFunctionsOf(Iterable<Class<?>> classesToUnregister) {
        boolean componentsChanged = this.functionRegistry.unregisterAllFunctionsOf(classesToUnregister);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public FunctionProvider getFunctionProvider() {
        return this.functionRegistry;
    }

    @Override
    public Function<?> getFunctionForDTO(FunctionDTO functionDTO) {
        return this.functionRegistry.getFunctionForDTO(functionDTO, (ClassLoader)this.getJoinedClassLoader());
    }

    @Override
    public void registerDataSourceProvider(DataSourceProvider<?> dataSourceProvider) {
        boolean componentsChanged = this.dataSourceProviderRegistry.register(dataSourceProvider);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public void unregisterDataSourceProvider(DataSourceProvider<?> dataSourceProvider) {
        boolean componentsChanged = this.dataSourceProviderRegistry.unregister(dataSourceProvider);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public DataRetrieverChainDefinitionProvider getDataRetrieverChainDefinitionProvider() {
        return this.dataRetrieverChainDefinitionRegistry;
    }

    @Override
    public DataRetrieverChainDefinitionRegistry getDataRetrieverChainDefinitionRegistry() {
        return this.dataRetrieverChainDefinitionRegistry;
    }

    @Override
    public void registerDataRetrieverChainDefinition(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        boolean componentsChanged = this.dataRetrieverChainDefinitionRegistry.register(dataRetrieverChainDefinition);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public void unregisterDataRetrieverChainDefinition(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        boolean componentsChanged = this.dataRetrieverChainDefinitionRegistry.unregister(dataRetrieverChainDefinition);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public <DataSourceType, DataType> DataRetrieverChainDefinition<DataSourceType, DataType> getDataRetrieverChainDefinitionForDTO(DataRetrieverChainDefinitionDTO retrieverChainDTO) {
        return this.dataRetrieverChainDefinitionRegistry.getForDTO(retrieverChainDTO, (ClassLoader)this.getJoinedClassLoader());
    }

    @Override
    public AggregationProcessorDefinitionProvider getAggregationProcessorProvider() {
        return this.aggregationProcessorDefinitionRegistry;
    }

    @Override
    public <ExtractedType, ResultType> AggregationProcessorDefinition<ExtractedType, ResultType> getAggregationProcessorDefinitionForDTO(AggregationProcessorDefinitionDTO aggregatorDefinitionDTO) {
        return this.aggregationProcessorDefinitionRegistry.getForDTO(aggregatorDefinitionDTO, (ClassLoader)this.getJoinedClassLoader());
    }

    @Override
    public void registerAggregationProcessor(AggregationProcessorDefinition<?, ?> aggregationProcessorDefinition) {
        boolean componentsChanged = this.aggregationProcessorDefinitionRegistry.register(aggregationProcessorDefinition);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public void unregisterAggregationProcessor(AggregationProcessorDefinition<?, ?> aggregationProcessorDefinition) {
        boolean componentsChanged = this.aggregationProcessorDefinitionRegistry.unregister(aggregationProcessorDefinition);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public QueryDefinitionDTOProvider getQueryDefinitionDTOProvider() {
        return this.queryDefinitionRegistry;
    }

    @Override
    public QueryDefinitionDTORegistry getQueryDefinitionDTORegistry() {
        return this.queryDefinitionRegistry;
    }

    @Override
    public void registerPredefinedQueryDefinition(PredefinedQueryIdentifier identifier, StatisticQueryDefinitionDTO queryDefinition) {
        boolean componentsChanged = this.queryDefinitionRegistry.register(identifier, queryDefinition);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public void unregisterPredefinedQueryDefinition(PredefinedQueryIdentifier identifier, StatisticQueryDefinitionDTO queryDefinition) {
        boolean componentsChanged = this.queryDefinitionRegistry.unregister(identifier, queryDefinition);
        if (componentsChanged) {
            this.updateComponentsChangedTimepoint();
        }
    }

    @Override
    public <DataSourceType, DataType, ExtractedType, ResultType> StatisticQueryDefinition<DataSourceType, DataType, ExtractedType, ResultType> getQueryDefinitionForDTO(StatisticQueryDefinitionDTO queryDefinitionDTO) {
        ModifiableStatisticQueryDefinition queryDefinition = null;
        Locale locale = ResourceBundleStringMessages.Util.getLocaleFor((String)queryDefinitionDTO.getLocaleInfoName());
        DataRetrieverChainDefinition<DataSourceType, DataType> retrieverChain = this.getDataRetrieverChainDefinitionForDTO(queryDefinitionDTO.getDataRetrieverChainDefinition());
        Function<?> statisticToCalculate = this.getFunctionForDTO(queryDefinitionDTO.getStatisticToCalculate());
        if (locale != null && retrieverChain != null && statisticToCalculate != null) {
            AggregationProcessorDefinition<ExtractedType, ResultType> aggregatorDefinition = this.getAggregationProcessorDefinitionForDTO(queryDefinitionDTO.getAggregatorDefinition());
            queryDefinition = new ModifiableStatisticQueryDefinition(locale, retrieverChain, statisticToCalculate, aggregatorDefinition);
            HashMap retrieverSettings = queryDefinitionDTO.getRetrieverSettings();
            HashMap filterSelection = queryDefinitionDTO.getFilterSelection();
            for (DataRetrieverLevelDTO retrieverLevelDTO : queryDefinitionDTO.getDataRetrieverChainDefinition().getRetrieverLevels()) {
                if (retrieverSettings.containsKey(retrieverLevelDTO)) {
                    queryDefinition.setRetrieverSettings(retrieverChain.getDataRetrieverLevel(retrieverLevelDTO.getLevel()), (SerializableSettings)retrieverSettings.get(retrieverLevelDTO));
                }
                if (!filterSelection.containsKey(retrieverLevelDTO)) continue;
                for (Map.Entry levelSpecificFilterSelectionEntry : ((HashMap)filterSelection.get(retrieverLevelDTO)).entrySet()) {
                    Function<?> dimensionToFilterBy = this.getFunctionForDTO((FunctionDTO)levelSpecificFilterSelectionEntry.getKey());
                    if (dimensionToFilterBy == null) continue;
                    queryDefinition.setFilterSelection(retrieverChain.getDataRetrieverLevel(retrieverLevelDTO.getLevel()), dimensionToFilterBy, (Collection)levelSpecificFilterSelectionEntry.getValue());
                }
            }
            for (FunctionDTO dimensionToGroupByDTO : queryDefinitionDTO.getDimensionsToGroupBy()) {
                Function<?> dimensionToGroupBy = this.getFunctionForDTO(dimensionToGroupByDTO);
                if (dimensionToGroupBy == null) continue;
                queryDefinition.addDimensionToGroupBy(dimensionToGroupBy);
            }
        }
        return queryDefinition;
    }

    @Override
    public <DataSourceType, ResultType> Query<ResultType> createQuery(StatisticQueryDefinition<DataSourceType, ?, ?, ResultType> queryDefinition) {
        DataSourceProvider<DataSourceType> dataSourceProvider = this.getDataSourceProviderFor(queryDefinition.getDataRetrieverChainDefinition().getDataSourceType());
        return this.queryFactory.createQuery(dataSourceProvider.getDataSource(), queryDefinition, this.getStringMessages(), this.getExecutorService());
    }

    @Override
    public <DataSourceType> Query<HashSet<Object>> createDimensionValuesQuery(DataRetrieverChainDefinition<DataSourceType, ?> dataRetrieverChainDefinition, DataRetrieverLevel<?, ?> retrieverLevel, Iterable<Function<?>> dimensions, Map<DataRetrieverLevel<?, ?>, SerializableSettings> settings, Map<DataRetrieverLevel<?, ?>, Map<Function<?>, Collection<?>>> filterSelection, Locale locale) {
        DataSourceProvider<DataSourceType> dataSourceProvider = this.getDataSourceProviderFor(dataRetrieverChainDefinition.getDataSourceType());
        return this.queryFactory.createDimensionValuesQuery(dataSourceProvider.getDataSource(), dataRetrieverChainDefinition, retrieverLevel, dimensions, settings, filterSelection, locale, this.getStringMessages(), this.getExecutorService());
    }

    private <DataSourceType> DataSourceProvider<DataSourceType> getDataSourceProviderFor(Class<DataSourceType> dataSourceType) {
        DataSourceProvider<DataSourceType> dataSourceProvider = this.dataSourceProviderRegistry.get(dataSourceType);
        if (dataSourceProvider == null) {
            throw new NullPointerException("No DataSourceProvider found for '" + dataSourceType + "'");
        }
        return dataSourceProvider;
    }

    @Override
    public <ResultType> QueryResult<ResultType> runNewQueryAndAbortPreviousQueries(DataMiningSession session, Query<ResultType> query) {
        return this.dataMiningQueryManager.runNewAndAbortPrevious(session, query);
    }

    @Override
    public int getNumberOfRunningQueries() {
        return this.dataMiningQueryManager.getNumberOfRunningQueries();
    }
}

