/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.factories;

import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.functions.ParameterProvider;
import com.sap.sse.datamining.functions.ParameterizedFunction;
import com.sap.sse.datamining.impl.ProcessorQuery;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.ParallelByDimensionGroupingProcessor;
import com.sap.sse.datamining.impl.components.ParallelGroupedElementsValueExtractionProcessor;
import com.sap.sse.datamining.impl.components.ParallelMultiDimensionsValueNestingGroupingProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedDataCollectingAsSetProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ProcessorFactory {
    private final ExecutorService executor;

    public ProcessorFactory(ExecutorService executor) {
        this.executor = executor;
    }

    public <ExtractedType, AggregatedType> Processor<GroupedDataEntry<ExtractedType>, Map<GroupKey, AggregatedType>> createAggregationProcessor(ProcessorQuery<AggregatedType, ?> query, AggregationProcessorDefinition<ExtractedType, AggregatedType> aggregatorDefinition) {
        ArrayList resultReceivers = new ArrayList();
        resultReceivers.add(query.getResultReceiver());
        return aggregatorDefinition.construct(this.executor, resultReceivers);
    }

    public Processor<GroupedDataEntry<Object>, Map<GroupKey, HashSet<Object>>> createGroupedDataCollectingAsSetProcessor(ProcessorQuery<HashSet<Object>, ?> query) {
        ArrayList resultReceivers = new ArrayList();
        resultReceivers.add(query.getResultReceiver());
        return new ParallelGroupedDataCollectingAsSetProcessor<Object>(this.executor, resultReceivers);
    }

    public <ElementType, ExtractedType> Processor<GroupedDataEntry<ElementType>, GroupedDataEntry<ExtractedType>> createExtractionProcessor(Processor<GroupedDataEntry<ExtractedType>, ?> aggregationProcessor, Function<ExtractedType> extractionFunction, ParameterProvider parameterProvider) {
        ArrayList resultReceivers = new ArrayList();
        resultReceivers.add(aggregationProcessor);
        return this.createExtractionProcessor(resultReceivers, extractionFunction, parameterProvider);
    }

    public <ElementType, ExtractedType> Processor<GroupedDataEntry<ElementType>, GroupedDataEntry<ExtractedType>> createExtractionProcessor(Collection<Processor<GroupedDataEntry<ExtractedType>, ?>> resultReceivers, Function<ExtractedType> extractionFunction, ParameterProvider parameterProvider) {
        return new ParallelGroupedElementsValueExtractionProcessor(this.executor, resultReceivers, extractionFunction, parameterProvider);
    }

    public <DataType> Processor<DataType, GroupedDataEntry<DataType>> createGroupingProcessor(Class<DataType> dataType, Processor<GroupedDataEntry<DataType>, ?> extractionProcessor, Iterable<ParameterizedFunction<?>> parameterizedDimensions) {
        ArrayList resultReceivers = new ArrayList();
        resultReceivers.add(extractionProcessor);
        return this.createGroupingProcessor(dataType, resultReceivers, parameterizedDimensions);
    }

    public <DataType> Processor<DataType, GroupedDataEntry<DataType>> createGroupingProcessor(Class<DataType> dataType, Collection<Processor<GroupedDataEntry<DataType>, ?>> resultReceivers, Iterable<ParameterizedFunction<?>> parameterizedDimensions) {
        return new ParallelMultiDimensionsValueNestingGroupingProcessor<DataType>(dataType, this.executor, resultReceivers, parameterizedDimensions);
    }

    public <DataType> Processor<DataType, GroupedDataEntry<DataType>> createGroupingProcessorWithParameter(Class<DataType> dataType, Collection<Processor<GroupedDataEntry<DataType>, ?>> resultReceivers, List<ParameterizedFunction<?>> parameterizedDimensions) {
        return new ParallelMultiDimensionsValueNestingGroupingProcessor<DataType>(dataType, this.executor, resultReceivers, parameterizedDimensions);
    }

    public <DataType> Collection<Processor<DataType, GroupedDataEntry<DataType>>> createGroupingExtractorsForDimensions(Class<DataType> dataType, Processor<GroupedDataEntry<Object>, ?> valueCollector, Iterable<ParameterizedFunction<?>> parameterizedDimensions, ResourceBundleStringMessages stringMessages, Locale locale) {
        ArrayList extractionResultReceivers = new ArrayList();
        extractionResultReceivers.add(valueCollector);
        ArrayList<Processor<DataType, GroupedDataEntry<DataType>>> groupingExtractors = new ArrayList<Processor<DataType, GroupedDataEntry<DataType>>>();
        for (ParameterizedFunction<?> parameterizedDimension : parameterizedDimensions) {
            Processor dimensionValueExtractor = this.createExtractionProcessor(extractionResultReceivers, parameterizedDimension.getFunction(), parameterizedDimension.getParameterProvider());
            ArrayList groupingResultReceivers = new ArrayList();
            groupingResultReceivers.add(dimensionValueExtractor);
            ParallelByDimensionGroupingProcessor<DataType> byDimensionGrouper = new ParallelByDimensionGroupingProcessor<DataType>(dataType, this.executor, groupingResultReceivers, parameterizedDimension, stringMessages, locale);
            groupingExtractors.add(byDimensionGrouper);
        }
        return groupingExtractors;
    }
}

