/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.factories;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.impl.CompoundGroupKey;
import com.sap.sse.datamining.shared.impl.GenericGroupKey;
import java.util.ArrayList;

public class GroupKeyFactory {
    public static <DataType> GroupKey createNestingCompoundKeyFor(DataType input, Iterable<Function<?>> dimensions) {
        if (Util.size(dimensions) == 1) {
            Function Dimension = (Function)Util.get(dimensions, (int)0);
            return GroupKeyFactory.createDimensionValueGroupKeyFor(input, Dimension);
        }
        ArrayList<GroupKey> keys = new ArrayList<GroupKey>();
        for (Function<?> Dimension : dimensions) {
            keys.add(GroupKeyFactory.createDimensionValueGroupKeyFor(input, Dimension));
        }
        return new CompoundGroupKey(keys);
    }

    public static <DataType> GroupKey createDimensionValueGroupKeyFor(DataType input, Function<?> mainDimension) {
        Object keyValue = mainDimension.tryToInvoke(input);
        return new GenericGroupKey(keyValue);
    }
}

