/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.factories;

import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.StatisticQueryDefinition;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.LocalizedTypeDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataMiningDTOFactory {
    public StatisticQueryDefinitionDTO createQueryDefinitionDTO(StatisticQueryDefinition<?, ?, ?, ?> queryDefinition, ResourceBundleStringMessages stringMessages, Locale locale, String localeInfoName) {
        FunctionDTO statisticToCalculate = this.createFunctionDTO(queryDefinition.getStatisticToCalculate(), stringMessages, locale);
        AggregationProcessorDefinitionDTO aggregatorDefinition = this.createAggregationProcessorDefinitionDTO(queryDefinition.getAggregatorDefinition(), stringMessages, locale);
        DataRetrieverChainDefinitionDTO dataRetrieverChainDefinition = this.createDataRetrieverChainDefinitionDTO(queryDefinition.getDataRetrieverChainDefinition(), stringMessages, locale);
        ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO = new ModifiableStatisticQueryDefinitionDTO(localeInfoName, statisticToCalculate, aggregatorDefinition, dataRetrieverChainDefinition);
        Map<DataRetrieverLevel<?, ?>, SerializableSettings> retrieverSettings = queryDefinition.getRetrieverSettings();
        Map<DataRetrieverLevel<?, ?>, Map<Function<?>, Collection<?>>> filterSelection = queryDefinition.getFilterSelection();
        DataRetrieverChainDefinition<?, ?> retrieverChain = queryDefinition.getDataRetrieverChainDefinition();
        List<DataRetrieverLevel<?, ?>> retrieverLevels = retrieverChain.getDataRetrieverLevels();
        int level = 0;
        while (level < retrieverLevels.size()) {
            DataRetrieverLevel<?, ?> retrieverLevel = retrieverLevels.get(level);
            DataRetrieverLevelDTO retrieverLevelDTO = dataRetrieverChainDefinition.getRetrieverLevel(level);
            SerializableSettings levelSettings = retrieverSettings.get(retrieverLevel);
            if (levelSettings != null) {
                queryDefinitionDTO.setRetrieverSettings(retrieverLevelDTO, levelSettings);
            }
            HashMap levelFilterSelection = new HashMap();
            if (filterSelection.containsKey(retrieverLevel)) {
                for (Map.Entry<Function<?>, Collection<?>> dimensionFilterSelection : filterSelection.get(retrieverLevel).entrySet()) {
                    HashSet filterValues = new HashSet(dimensionFilterSelection.getValue());
                    levelFilterSelection.put(this.createFunctionDTO(dimensionFilterSelection.getKey(), stringMessages, locale), filterValues);
                }
            }
            queryDefinitionDTO.setFilterSelectionFor(retrieverLevelDTO, levelFilterSelection);
            ++level;
        }
        for (Function<?> dimensionToGroupBy : queryDefinition.getDimensionsToGroupBy()) {
            queryDefinitionDTO.appendDimensionToGroupBy(this.createFunctionDTO(dimensionToGroupBy, stringMessages, locale));
        }
        return queryDefinitionDTO;
    }

    public FunctionDTO createFunctionDTO(Function<?> function) {
        return this.createFunctionDTO(function, () -> function.getSimpleName());
    }

    public FunctionDTO createFunctionDTO(Function<?> function, ResourceBundleStringMessages stringMessages, Locale locale) {
        return this.createFunctionDTO(function, () -> function.getLocalizedName(locale, stringMessages));
    }

    private FunctionDTO createFunctionDTO(Function<?> function, FunctionDTO.DisplayNameProvider displayNameProvider) {
        String functionName = function.getSimpleName();
        String sourceTypeName = function.getDeclaringType().getName();
        String returnTypeName = function.getReturnType().getName();
        List<String> parameterTypeNames = this.getParameterTypeNames(function);
        return new FunctionDTO(function.isDimension(), functionName, sourceTypeName, returnTypeName, parameterTypeNames, displayNameProvider, function.getOrdinal());
    }

    private List<String> getParameterTypeNames(Function<?> function) {
        ArrayList<String> parameterTypeNames = new ArrayList<String>();
        for (Class<?> parameterType : function.getParameters()) {
            parameterTypeNames.add(parameterType.getName());
        }
        return parameterTypeNames;
    }

    public AggregationProcessorDefinitionDTO createAggregationProcessorDefinitionDTO(AggregationProcessorDefinition<?, ?> aggregatorDefinition) {
        return this.createAggregationProcessorDefinitionDTO(aggregatorDefinition, ResourceBundleStringMessages.NULL, null);
    }

    public AggregationProcessorDefinitionDTO createAggregationProcessorDefinitionDTO(AggregationProcessorDefinition<?, ?> aggregatorDefinition, ResourceBundleStringMessages stringMessages, Locale locale) {
        return new AggregationProcessorDefinitionDTO(aggregatorDefinition.getAggregationNameMessageKey(), aggregatorDefinition.getExtractedType().getName(), aggregatorDefinition.getAggregatedType().getName(), stringMessages.get(locale, aggregatorDefinition.getAggregationNameMessageKey()));
    }

    public DataRetrieverChainDefinitionDTO createDataRetrieverChainDefinitionDTO(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        return this.createDataRetrieverChainDefinitionDTO(dataRetrieverChainDefinition, ResourceBundleStringMessages.NULL, null);
    }

    public DataRetrieverChainDefinitionDTO createDataRetrieverChainDefinitionDTO(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition, ResourceBundleStringMessages stringMessages, Locale locale) {
        ArrayList<DataRetrieverLevelDTO> retrieverLevels = new ArrayList<DataRetrieverLevelDTO>();
        for (DataRetrieverLevel<?, ?> retrieverLevel : dataRetrieverChainDefinition.getDataRetrieverLevels()) {
            retrieverLevels.add(this.createDataRetrieverLevelDTO(retrieverLevel, stringMessages, locale));
        }
        return new DataRetrieverChainDefinitionDTO(dataRetrieverChainDefinition.getLocalizedName(locale, stringMessages), dataRetrieverChainDefinition.getDataSourceType().getName(), retrieverLevels);
    }

    public DataRetrieverLevelDTO createDataRetrieverLevelDTO(DataRetrieverLevel<?, ?> retrieverLevel, ResourceBundleStringMessages stringMessages, Locale locale) {
        String typeName = retrieverLevel.getRetrievedDataType().getName();
        String displayName = retrieverLevel.getRetrievedDataTypeMessageKey() != null && !retrieverLevel.getRetrievedDataTypeMessageKey().isEmpty() ? stringMessages.get(locale, retrieverLevel.getRetrievedDataTypeMessageKey()) : typeName;
        LocalizedTypeDTO localizedRetrievedDataType = new LocalizedTypeDTO(typeName, displayName);
        return new DataRetrieverLevelDTO(retrieverLevel.getLevel(), retrieverLevel.getRetrieverType().getName(), localizedRetrievedDataType, retrieverLevel.getDefaultSettings());
    }

    public <ResultType extends Serializable> QueryResultDTO<ResultType> createResultDTO(QueryResult<ResultType> result) {
        return new QueryResultDTO(result.getState(), result.getResultType(), result.getResults(), result.getAdditionalData());
    }
}

