/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.nmeaconnector.impl;

import com.sap.sailing.domain.base.impl.KilometersPerHourSpeedWithBearingImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.nmeaconnector.NmeaUtil;
import com.sap.sailing.nmeaconnector.impl.AAMParser;
import com.sap.sailing.nmeaconnector.impl.BATParser;
import com.sap.sailing.nmeaconnector.impl.BWCParser;
import com.sap.sailing.nmeaconnector.impl.BWRParser;
import com.sap.sailing.nmeaconnector.impl.GLCParser;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.HashMap;
import java.util.Map;
import net.sf.marineapi.nmea.parser.SentenceFactory;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.MWVSentence;
import net.sf.marineapi.nmea.util.Units;

public class NmeaUtilImpl
implements NmeaUtil {
    private static Map<String, Class<? extends SentenceParser>> proprietaryParsers = new HashMap<String, Class<? extends SentenceParser>>();

    static {
        proprietaryParsers.put("BAT", BATParser.class);
        proprietaryParsers.put("AAM", AAMParser.class);
        proprietaryParsers.put("GLC", GLCParser.class);
        proprietaryParsers.put("BWC", BWCParser.class);
        proprietaryParsers.put("BWR", BWRParser.class);
    }

    @Override
    public void registerAdditionalParsers() {
        SentenceFactory sentenceFactory = SentenceFactory.getInstance();
        for (Map.Entry<String, Class<? extends SentenceParser>> e : proprietaryParsers.entrySet()) {
            if (sentenceFactory.hasParser(e.getKey())) continue;
            sentenceFactory.registerParser(e.getKey(), e.getValue());
        }
    }

    @Override
    public void unregisterAdditionalParsers() {
        SentenceFactory sentenceFactory = SentenceFactory.getInstance();
        for (Map.Entry<String, Class<? extends SentenceParser>> e : proprietaryParsers.entrySet()) {
            if (sentenceFactory.hasParser(e.getKey())) continue;
            sentenceFactory.unregisterParser(e.getValue());
        }
    }

    @Override
    public Wind getWind(TimePoint timePoint, Position position, MWVSentence mwvSentence) {
        return new WindImpl(position, timePoint, (SpeedWithBearing)new KnotSpeedWithBearingImpl(mwvSentence.getSpeed(), (Bearing)new DegreeBearingImpl(mwvSentence.getAngle())));
    }

    @Override
    public Speed getSpeed(double magnitude, Units unit) {
        switch (unit) {
            case KMH: {
                return new KilometersPerHourSpeedImpl(magnitude);
            }
            case KNOT: {
                return new KnotSpeedImpl(magnitude);
            }
            case METER: {
                return new KilometersPerHourSpeedImpl(magnitude * 3.6);
            }
        }
        throw new IllegalArgumentException("Unit " + unit + " not understood for a speed");
    }

    @Override
    public SpeedWithBearing getSpeedWithBearing(double speedMagnitude, Units speedUnit, double bearingInDegrees) {
        DegreeBearingImpl bearing = new DegreeBearingImpl(bearingInDegrees);
        switch (speedUnit) {
            case KMH: {
                return new KilometersPerHourSpeedWithBearingImpl(speedMagnitude, (Bearing)bearing);
            }
            case KNOT: {
                return new KnotSpeedWithBearingImpl(speedMagnitude, (Bearing)bearing);
            }
            case METER: {
                return new KilometersPerHourSpeedWithBearingImpl(speedMagnitude * 3.6, (Bearing)bearing);
            }
        }
        throw new IllegalArgumentException("Unit " + speedUnit + " not understood for a speed");
    }

    @Override
    public String replace(String nmeaSentence, String regexToFind, String replaceWith) {
        while (nmeaSentence.matches(".*" + regexToFind + ".*")) {
            String resultWithOldChecksum = nmeaSentence.replaceFirst(regexToFind, replaceWith);
            if (resultWithOldChecksum.matches(".*\\*[0-9a-fA-F][0-9a-fA-F]$")) {
                int checksum = Integer.valueOf(resultWithOldChecksum.substring(resultWithOldChecksum.length() - 2), 16);
                char[] cArray = regexToFind.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char oldChar = cArray[n2];
                    checksum ^= (byte)oldChar;
                    ++n2;
                }
                cArray = replaceWith.toCharArray();
                n = cArray.length;
                n2 = 0;
                while (n2 < n) {
                    char newChar = cArray[n2];
                    checksum ^= (byte)newChar;
                    ++n2;
                }
                String newHexChecksum = Integer.toHexString(checksum).toUpperCase();
                if (newHexChecksum.length() == 1) {
                    newHexChecksum = "0" + newHexChecksum;
                }
                nmeaSentence = String.valueOf(resultWithOldChecksum.substring(0, resultWithOldChecksum.length() - 2)) + newHexChecksum;
                continue;
            }
            nmeaSentence = resultWithOldChecksum;
        }
        return nmeaSentence;
    }
}

