/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.persistence.impl;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sse.replication.ReplicaDescriptor;
import com.sap.sse.replication.persistence.MongoObjectFactory;
import com.sap.sse.replication.persistence.impl.CollectionNames;
import com.sap.sse.replication.persistence.impl.FieldNames;
import java.util.Arrays;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private final MongoDatabase db;

    public MongoObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
    }

    private MongoCollection<Document> getReplicaDescriptorCollection() {
        MongoCollection result = this.db.getCollection(CollectionNames.REPLICA_DESCRIPTORS.name());
        result.createIndex((Bson)new Document(FieldNames.REPLICA_ID_AS_STRING.name(), (Object)1));
        return result;
    }

    @Override
    public void storeReplicaDescriptor(ReplicaDescriptor replicaDescriptor) {
        Document replicaDescriptorDoc = new Document();
        replicaDescriptorDoc.put(FieldNames.REPLICA_ID_AS_STRING.name(), (Object)replicaDescriptor.getUuid().toString());
        replicaDescriptorDoc.put(FieldNames.REPLICA_IP_ADDRESS.name(), (Object)replicaDescriptor.getIpAddress().getHostAddress());
        replicaDescriptorDoc.put(FieldNames.REPLICA_REGISTRATION_TIME_MILLIS.name(), (Object)replicaDescriptor.getRegistrationTime().asMillis());
        replicaDescriptorDoc.put(FieldNames.REPLICA_ADDITIONAL_INFORMATION.name(), (Object)replicaDescriptor.getAdditionalInformation());
        replicaDescriptorDoc.put(FieldNames.REPLICA_REPLICABLE_IDS_AS_STRINGS.name(), Arrays.asList(replicaDescriptor.getReplicableIdsAsStrings()));
        replicaDescriptorDoc.put(FieldNames.REPLICA_PORT.name(), (Object)replicaDescriptor.getPort());
        this.getReplicaDescriptorCollection().withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)replicaDescriptorDoc, (Object)replicaDescriptorDoc, new ReplaceOptions().upsert(true));
    }

    @Override
    public void removeReplicaDescriptor(ReplicaDescriptor replicaDescriptor) {
        if (replicaDescriptor != null) {
            Document replicaDescriptorDoc = new Document(FieldNames.REPLICA_ID_AS_STRING.name(), (Object)replicaDescriptor.getUuid().toString());
            this.getReplicaDescriptorCollection().withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)replicaDescriptorDoc);
        }
    }
}

