/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.common.Util;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.UserDataProvider;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.orchestration.StartHost;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import software.amazon.awssdk.services.ec2.model.InstanceType;

public abstract class StartAwsHost<ShardingKey, HostT extends AwsInstance<ShardingKey>>
extends StartHost<ShardingKey, HostT> {
    public static final String NAME_TAG_NAME = "Name";
    private final List<String> userData = new ArrayList<String>();
    private final InstanceType instanceType;
    private final AwsAvailabilityZone availabilityZone;
    private final String keyName;
    private final Iterable<SecurityGroup> securityGroups;
    private final Optional<Tags> tags;
    private final HostSupplier<ShardingKey, HostT> hostSupplier;
    private final byte[] privateKeyEncryptionPassphrase;
    private HostT host;

    protected StartAwsHost(BuilderImpl<?, ? extends StartAwsHost<ShardingKey, HostT>, ShardingKey, HostT> builder) {
        super(builder);
        for (String ud : builder.getUserData()) {
            this.userData.add(ud);
        }
        this.instanceType = builder.getInstanceType();
        this.securityGroups = builder.getSecurityGroups();
        this.availabilityZone = builder.getAvailabilityZone();
        this.keyName = builder.getKeyName();
        this.tags = Optional.of(builder.getTags().orElse(Tags.empty()).and(NAME_TAG_NAME, builder.getInstanceName()));
        this.hostSupplier = builder.getHostSupplier();
        this.privateKeyEncryptionPassphrase = builder.getPrivateKeyEncryptionPassphrase();
    }

    protected static <ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>> AmazonMachineImage<ShardingKey> getLatestImageOfType(String imageType, AwsLandscape<ShardingKey> landscape, Region region) {
        return landscape.getLatestImageWithType(region, imageType);
    }

    protected static <ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>> AwsAvailabilityZone getRandomAvailabilityZone(AwsRegion region, AwsLandscape<ShardingKey> awsLandscape, Optional<String> vpcId) {
        Iterable<AwsAvailabilityZone> azs = awsLandscape.getAvailabilityZones(region, vpcId);
        return (AwsAvailabilityZone)Util.get(azs, (int)new Random().nextInt(Util.size(azs)));
    }

    protected static <ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>> Set<SecurityGroup> getDefaultSecurityGroupForApplicationHosts(Landscape<ShardingKey> landscape, Region region) {
        return Collections.singleton(landscape.getDefaultSecurityGroupForApplicationHosts(region));
    }

    public AwsLandscape<ShardingKey> getLandscape() {
        return (AwsLandscape)super.getLandscape();
    }

    public void run() throws Exception {
        this.host = this.getLandscape().launchHost(this.hostSupplier, this.getMachineImage(), this.getInstanceType(), this.getAvailabilityZone(), this.getKeyName(), this.getSecurityGroups(), this.getTags(), (String[])Util.toArray(this.getUserData(), (Object[])new String[0]));
    }

    public HostT getHost() {
        return this.host;
    }

    private Optional<Tags> getTags() {
        return this.tags;
    }

    private Iterable<SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    protected String getKeyName() {
        return this.keyName;
    }

    private AwsAvailabilityZone getAvailabilityZone() {
        return this.availabilityZone;
    }

    private InstanceType getInstanceType() {
        return this.instanceType;
    }

    protected Iterable<String> getUserData() throws URISyntaxException {
        return this.userData;
    }

    protected void addUserData(Iterable<String> moreUserData) {
        Util.addAll(moreUserData, this.userData);
    }

    protected void addUserData(ProcessConfigurationVariable userDataVariable, String value) {
        this.userData.add(UserDataProvider.getAsEnvironmentVariableAssignment((ProcessConfigurationVariable)userDataVariable, (String)value));
    }

    protected void addUserData(UserDataProvider userDataProvider) {
        if (userDataProvider != null) {
            for (Map.Entry userDataEntry : userDataProvider.getUserData().entrySet()) {
                this.addUserData((ProcessConfigurationVariable)userDataEntry.getKey(), (String)userDataEntry.getValue());
            }
        }
    }

    protected byte[] getPrivateKeyEncryptionPassphrase() {
        return this.privateKeyEncryptionPassphrase;
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey, HostT>, T extends StartAwsHost<ShardingKey, HostT>, ShardingKey, HostT extends AwsInstance<ShardingKey>>
    extends StartHost.Builder<BuilderT, T, ShardingKey, HostT> {
        public BuilderT setInstanceType(InstanceType var1);

        public BuilderT setAvailabilityZone(AwsAvailabilityZone var1);

        public BuilderT setKeyName(String var1);

        public BuilderT setPrivateKeyEncryptionPassphrase(byte[] var1);

        public BuilderT setSecurityGroups(Iterable<SecurityGroup> var1);

        public BuilderT setTags(Tags var1);

        public BuilderT setUserData(String[] var1);

        public BuilderT setRegion(AwsRegion var1);

        public BuilderT setInstanceName(String var1);

        public BuilderT setHostSupplier(HostSupplier<ShardingKey, HostT> var1);

        public AmazonMachineImage<ShardingKey> getMachineImage();
    }

    protected static abstract class BuilderImpl<BuilderT extends Builder<BuilderT, T, ShardingKey, HostT>, T extends StartAwsHost<ShardingKey, HostT>, ShardingKey, HostT extends AwsInstance<ShardingKey>>
    extends StartHost.BuilderImpl<BuilderT, T, ShardingKey, HostT>
    implements Builder<BuilderT, T, ShardingKey, HostT> {
        private InstanceType instanceType;
        private AwsAvailabilityZone availabilityZone;
        private String keyName;
        private Iterable<SecurityGroup> securityGroups;
        private Optional<Tags> tags = Optional.empty();
        private List<String> userData = new ArrayList<String>();
        private AwsRegion region;
        private String instanceName;
        private HostSupplier<ShardingKey, HostT> hostSupplier;
        private byte[] privateKeyEncryptionPassphrase;

        protected BuilderImpl() {
        }

        protected AwsLandscape<ShardingKey> getLandscape() {
            return (AwsLandscape)super.getLandscape();
        }

        protected InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public BuilderT setInstanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return (BuilderT)((Builder)this.self());
        }

        protected AwsAvailabilityZone getAvailabilityZone() {
            return this.availabilityZone == null ? StartAwsHost.getRandomAvailabilityZone(this.getRegion(), this.getLandscape(), Util.stream(this.getSecurityGroups()).findFirst().map(sg -> sg.getVpcId())) : this.availabilityZone;
        }

        @Override
        public BuilderT setAvailabilityZone(AwsAvailabilityZone availabilityZone) {
            this.availabilityZone = availabilityZone;
            return (BuilderT)((Builder)this.self());
        }

        protected String getKeyName() {
            return this.keyName;
        }

        @Override
        public BuilderT setKeyName(String keyName) {
            this.keyName = keyName;
            return (BuilderT)((Builder)this.self());
        }

        protected Iterable<SecurityGroup> getSecurityGroups() {
            return this.securityGroups == null ? Collections.singleton(this.getLandscape().getDefaultSecurityGroupForApplicationHosts((Region)this.getRegion())) : this.securityGroups;
        }

        protected boolean isSecurityGroupsSet() {
            return this.securityGroups != null;
        }

        @Override
        public BuilderT setSecurityGroups(Iterable<SecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return (BuilderT)((Builder)this.self());
        }

        protected Optional<Tags> getTags() {
            return this.tags;
        }

        @Override
        public BuilderT setTags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return (BuilderT)((Builder)this.self());
        }

        protected Iterable<String> getUserData() {
            return Collections.unmodifiableList(this.userData);
        }

        @Override
        public BuilderT setUserData(String[] userData) {
            this.userData.clear();
            String[] stringArray = userData;
            int n = userData.length;
            int n2 = 0;
            while (n2 < n) {
                String userDataElement = stringArray[n2];
                this.userData.add(userDataElement);
                ++n2;
            }
            return (BuilderT)((Builder)this.self());
        }

        protected AwsRegion getRegion() {
            return this.region == null ? (this.availabilityZone == null ? this.getLandscape().getDefaultRegion() : this.getAvailabilityZone().getRegion()) : this.region;
        }

        @Override
        public BuilderT setRegion(AwsRegion region) {
            this.region = region;
            return (BuilderT)((Builder)this.self());
        }

        protected String getInstanceName() {
            return this.instanceName;
        }

        protected boolean isInstanceNameSet() {
            return this.instanceName != null;
        }

        @Override
        public BuilderT setInstanceName(String instanceName) {
            this.instanceName = instanceName;
            return (BuilderT)((Builder)this.self());
        }

        protected HostSupplier<ShardingKey, HostT> getHostSupplier() {
            return this.hostSupplier;
        }

        @Override
        public BuilderT setHostSupplier(HostSupplier<ShardingKey, HostT> hostSupplier) {
            this.hostSupplier = hostSupplier;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setPrivateKeyEncryptionPassphrase(byte[] privateKeyEncryptionPassphrase) {
            this.privateKeyEncryptionPassphrase = privateKeyEncryptionPassphrase;
            return (BuilderT)((Builder)this.self());
        }

        protected byte[] getPrivateKeyEncryptionPassphrase() {
            return this.privateKeyEncryptionPassphrase;
        }

        @Override
        public AmazonMachineImage<ShardingKey> getMachineImage() {
            AmazonMachineImage result = (AmazonMachineImage)super.getMachineImage();
            return result;
        }
    }
}

