/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.common.Duration;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.aws.orchestration.AwsApplicationConfiguration;
import com.sap.sse.landscape.aws.orchestration.StartAwsHost;
import java.util.Optional;

public class StartAwsApplicationHost<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends AwsInstance<ShardingKey>>
extends StartAwsHost<ShardingKey, HostT> {
    private final AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> applicationConfiguration;
    private final Optional<Duration> optionalTimeout;

    protected StartAwsApplicationHost(BuilderImpl<?, ? extends StartAwsHost<ShardingKey, HostT>, ShardingKey, MetricsT, ProcessT, HostT> builder) throws Exception {
        super(builder);
        this.optionalTimeout = builder.getOptionalTimeout();
        this.applicationConfiguration = (AwsApplicationConfiguration)builder.getApplicationConfigurationBuilder().build();
        this.addUserData(this.applicationConfiguration::getUserData);
    }

    protected AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    protected Optional<Duration> getOptionalTimeout() {
        return this.optionalTimeout;
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT, HostT>, T extends StartAwsHost<ShardingKey, HostT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends AwsInstance<ShardingKey>>
    extends StartAwsHost.Builder<BuilderT, T, ShardingKey, HostT> {
    }

    protected static abstract class BuilderImpl<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT, HostT>, T extends StartAwsHost<ShardingKey, HostT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends AwsInstance<ShardingKey>>
    extends StartAwsHost.BuilderImpl<BuilderT, T, ShardingKey, HostT>
    implements Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT, HostT> {
        private final AwsApplicationConfiguration.Builder<?, ?, ShardingKey, MetricsT, ProcessT> applicationConfigurationBuilder;

        protected BuilderImpl(AwsApplicationConfiguration.Builder<?, ?, ShardingKey, MetricsT, ProcessT> applicationConfigurationBuilder) {
            this.applicationConfigurationBuilder = applicationConfigurationBuilder;
        }

        protected AwsApplicationConfiguration.Builder<?, ?, ShardingKey, MetricsT, ProcessT> getApplicationConfigurationBuilder() {
            return this.applicationConfigurationBuilder;
        }

        @Override
        public BuilderT setRegion(AwsRegion region) {
            this.getApplicationConfigurationBuilder().setRegion(region);
            return (BuilderT)((Builder)super.setRegion(region));
        }

        public BuilderT setLandscape(Landscape<ShardingKey> landscape) {
            this.getApplicationConfigurationBuilder().setLandscape((AwsLandscape)landscape);
            return (BuilderT)((Builder)super.setLandscape(landscape));
        }

        protected Optional<Duration> getOptionalTimeout() {
            return super.getOptionalTimeout();
        }
    }
}

