/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.common.shared.PlainRedirectDTO;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;

public interface ProcedureCreatingLoadBalancerMapping<ShardingKey> {
    public static final int NUMBER_OF_RULES_PER_REPLICA_SET = 5;
    public static final /* synthetic */ boolean $assertionsDisabled;

    default public Rule[] createRules(ApplicationLoadBalancer<ShardingKey> alb, String hostName, TargetGroup<ShardingKey> masterTargetGroup, TargetGroup<ShardingKey> publicTargetGroup) {
        Rule[] rules = new Rule[5];
        int ruleCount = 0;
        rules[ruleCount++] = alb.getDefaultRedirectRule(hostName, new PlainRedirectDTO());
        rules[ruleCount++] = (Rule)Rule.builder().conditions(new RuleCondition[]{(RuleCondition)RuleCondition.builder().field("http-header").httpHeaderConfig(hhcb -> {
            HttpHeaderConditionConfig.Builder builder = hhcb.httpHeaderName("X-SAPSSE-Forward-Request-To").values(new String[]{(String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER.getB()});
        }).build(), alb.createHostHeaderRuleCondition(hostName)}).actions(new Action[]{this.createForwardToTargetGroupAction(masterTargetGroup)}).build();
        rules[ruleCount++] = (Rule)Rule.builder().conditions(new RuleCondition[]{(RuleCondition)RuleCondition.builder().field("http-header").httpHeaderConfig(hhcb -> {
            HttpHeaderConditionConfig.Builder builder = hhcb.httpHeaderName("X-SAPSSE-Forward-Request-To").values(new String[]{(String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getB()});
        }).build(), alb.createHostHeaderRuleCondition(hostName)}).actions(new Action[]{this.createForwardToTargetGroupAction(publicTargetGroup)}).build();
        rules[ruleCount++] = (Rule)Rule.builder().conditions(new RuleCondition[]{(RuleCondition)RuleCondition.builder().field("http-request-method").httpRequestMethodConfig(hrmcb -> {
            HttpRequestMethodConditionConfig.Builder builder = hrmcb.values(new String[]{"GET"});
        }).build(), alb.createHostHeaderRuleCondition(hostName)}).actions(new Action[]{this.createForwardToTargetGroupAction(publicTargetGroup)}).build();
        rules[ruleCount++] = (Rule)Rule.builder().conditions(new RuleCondition[]{alb.createHostHeaderRuleCondition(hostName)}).actions(new Action[]{this.createForwardToTargetGroupAction(masterTargetGroup)}).build();
        assert (ruleCount == 5);
        return rules;
    }

    default public Action createForwardToTargetGroupAction(TargetGroup<ShardingKey> targetGroup) {
        return (Action)Action.builder().type(ActionTypeEnum.FORWARD).forwardConfig(fc -> {
            ForwardActionConfig.Builder builder = fc.targetGroups(new TargetGroupTuple[]{(TargetGroupTuple)TargetGroupTuple.builder().targetGroupArn(targetGroup.getTargetGroupArn()).build()});
        }).build();
    }
}

