/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.common.Util;
import com.sap.sse.common.util.MappingIterator;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AwsShard;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.orchestration.ShardProcedure;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;

public class AddShardingKeyToShard<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends ShardProcedure<ShardingKey, MetricsT, ProcessT> {
    private static final Logger logger = Logger.getLogger(AddShardingKeyToShard.class.getName());

    public AddShardingKeyToShard(BuilderImpl<?, ShardingKey, MetricsT, ProcessT> builder) throws Exception {
        super(builder);
    }

    /*
     * Unable to fully structure code
     */
    public void run() throws Exception {
        shard = null;
        for (Map.Entry<AwsShard<ShardingKey>, Iterable<ShardingKey>> entry : this.replicaSet.getShards().entrySet()) {
            if (!entry.getKey().getName().equals(this.shardName)) continue;
            shard = entry.getKey();
            break;
        }
        if (shard == null) {
            throw new Exception("Shard " + this.shardName + " not found in replica set " + this.replicaSet.getName());
        }
        AddShardingKeyToShard.logger.info("Appending " + Util.joinStrings((String)", ", (Iterable)this.shardingKeys) + " to " + this.shardName);
        mutableShardingKeys = new LinkedList<E>();
        mutableShardingKeys.addAll(this.shardingKeys);
        targetgroup = shard.getTargetGroup();
        loadBalancer = shard.getLoadBalancer();
        t = new ArrayList<TargetGroup<ShardingKey>>();
        t.add(targetgroup);
        for (Rule r : shard.getRules()) {
            updateRule = false;
            shardingKeys = new ArrayList<E>();
            for (RuleCondition con : r.conditions()) {
                if (con.pathPatternConfig() == null) continue;
                Util.addAll((Iterable)Util.filter((Iterable)Util.map((Iterable)con.values(), (MappingIterator.MapFunction)(MappingIterator.MapFunction)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getShardingKeyFromPathCondition(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((AddShardingKeyToShard)this)), (Util.UtilPredicate)(Util.UtilPredicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$1(java.lang.Object ), (Ljava/lang/Object;)Z)((AddShardingKeyToShard)this)), shardingKeys);
            }
            if (!shardingKeys.isEmpty()) ** GOTO lbl33
            loadBalancer.deleteRules(new Rule[]{r});
            continue;
lbl-1000:
            // 1 sources

            {
                shardingKeys.add(mutableShardingKeys.get(0));
                mutableShardingKeys.remove(0);
                updateRule = true;
lbl33:
                // 2 sources

                ** while (shardingKeys.size() < 3 && !mutableShardingKeys.isEmpty())
            }
lbl34:
            // 1 sources

            ruleConditions = this.getShardingRuleConditions(loadBalancer, shardingKeys);
            proxyRuleWithNewConditions = (Rule)Rule.builder().ruleArn(r.ruleArn()).conditions(ruleConditions).build();
            if (!updateRule) continue;
            this.getLandscape().modifyRuleConditions(this.region, proxyRuleWithNewConditions);
        }
        if (!mutableShardingKeys.isEmpty()) {
            keysCopy = new HashSet<E>();
            keysCopy.addAll(this.shardingKeys);
            alb = Util.size(loadBalancer.getRules()) + this.numberOfRequiredRules(Util.size((Iterable)this.shardingKeys)) < 100 ? loadBalancer : this.getFreeLoadBalancerAndMoveReplicaSet();
            this.addShardingRules(alb, keysCopy, targetgroup);
        }
    }

    public static <MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, BuilderT extends ShardProcedure.Builder<BuilderT, AddShardingKeyToShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey> ShardProcedure.Builder<BuilderT, AddShardingKeyToShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> builder() {
        return new BuilderImpl();
    }

    private /* synthetic */ boolean lambda$1(Object shardingKey) {
        return !shardingKey.equals(this.SHARDING_KEY_UNUSED_BY_ANY_APPLICATION);
    }

    static class BuilderImpl<BuilderT extends ShardProcedure.Builder<BuilderT, AddShardingKeyToShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends ShardProcedure.BuilderImpl<BuilderT, AddShardingKeyToShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> {
        BuilderImpl() {
        }

        public AddShardingKeyToShard<ShardingKey, MetricsT, ProcessT> build() throws Exception {
            assert (this.shardingKeys != null);
            assert (this.replicaSet != null);
            assert (this.region != null);
            return new AddShardingKeyToShard(this);
        }
    }
}

