/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.Named;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.MappingIterator;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair;

public class LoadBalancerRuleInserter<ShardingKey, RA extends RuleAdapter<RA>> {
    private final LoadBalancerAdapter<RA> loadBalancerAdapter;
    private final int maxPriority;
    private final int maxRulesPerLoadBalancer;

    public LoadBalancerRuleInserter(LoadBalancerAdapter<RA> loadBalancerAdapter, int maxPriority, int maxRulesPerLoadBalancer) {
        this.loadBalancerAdapter = loadBalancerAdapter;
        this.maxPriority = maxPriority;
        this.maxRulesPerLoadBalancer = maxRulesPerLoadBalancer;
    }

    public static <ShardingKey> LoadBalancerRuleInserter<ShardingKey, ALBRuleAdapter> create(ApplicationLoadBalancer<ShardingKey> alb, int maxPriority, int maxRulesPerLoadBalancer) {
        return new LoadBalancerRuleInserter<ShardingKey, ALBRuleAdapter>(LoadBalancerRuleInserter.createLoadBalancerAdapter(alb), maxPriority, maxRulesPerLoadBalancer);
    }

    public static ALBRuleAdapter createRuleAdapter(Rule rule) {
        return new ALBRuleAdapter(rule);
    }

    static <ShardingKey> ALBAdapter<ShardingKey> createLoadBalancerAdapter(ApplicationLoadBalancer<ShardingKey> alb) {
        return new ALBAdapter(alb);
    }

    /*
     * Unable to fully structure code
     */
    public List<RA> addRulesAssigningUnusedPriorities(boolean forceContiguous, Optional<RA> insertBefore, Iterable<RA> rules) {
        existingRules = this.loadBalancerAdapter.getRules();
        if (insertBefore.isPresent() && !Util.contains((Iterable)Util.map(existingRules, (MappingIterator.MapFunction)(MappingIterator.MapFunction)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, ruleArn(), (Lcom/sap/sse/landscape/aws/impl/LoadBalancerRuleInserter$RuleAdapter;)Ljava/lang/String;)()), (Object)((RuleAdapter)insertBefore.get()).ruleArn())) {
            throw new IllegalArgumentException("Didn't find rule to insert before: " + insertBefore.get());
        }
        remainingNumberOfRulesToAdd = rulesSize = Util.size(rules);
        if (Util.size(existingRules) - 1 + rulesSize > this.maxPriority) {
            throw new IllegalArgumentException("The " + rulesSize + " new rules won't find enough unused priority numbers because there are already " + (Util.size(existingRules) - 1) + " of them and together they would exceed the maximum of " + this.maxPriority + " by " + (Util.size(existingRules) - 1 + rulesSize - this.maxPriority));
        }
        if (Util.size(existingRules) + rulesSize > this.maxRulesPerLoadBalancer) {
            throw new IllegalArgumentException("The " + rulesSize + " new rules would make the ALB " + this.loadBalancerAdapter.getName() + " exceed its maximum number of rules (" + this.maxPriority + ") by " + (Util.size(existingRules) + rulesSize - this.maxRulesPerLoadBalancer));
        }
        result = new ArrayList<RA>(rulesSize);
        sortedExistingNonDefaultRules = new ArrayList<E>(Util.size(existingRules) - 1);
        Util.addAll((Iterable)Util.filter(existingRules, (Util.UtilPredicate)(Util.UtilPredicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$1(com.sap.sse.landscape.aws.impl.LoadBalancerRuleInserter$RuleAdapter ), (Lcom/sap/sse/landscape/aws/impl/LoadBalancerRuleInserter$RuleAdapter;)Z)()), sortedExistingNonDefaultRules);
        Collections.sort(sortedExistingNonDefaultRules, (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$2(com.sap.sse.landscape.aws.impl.LoadBalancerRuleInserter$RuleAdapter com.sap.sse.landscape.aws.impl.LoadBalancerRuleInserter$RuleAdapter ), (Lcom/sap/sse/landscape/aws/impl/LoadBalancerRuleInserter$RuleAdapter;Lcom/sap/sse/landscape/aws/impl/LoadBalancerRuleInserter$RuleAdapter;)I)());
        stepwidth = forceContiguous != false ? rulesSize : 1;
        rulesIterator = rules.iterator();
        previousPriority = 0;
        existingRulesIter = sortedExistingNonDefaultRules.iterator();
        foundRuleToInsertBefore = false;
        while (rulesIterator.hasNext()) {
            block8: {
                nextPriority = this.maxPriority + 1;
                nextRule = new RuleAdapter[1];
                while (!(!existingRulesIter.hasNext() || (nextPriority = Integer.valueOf((nextRule[0] = (RuleAdapter)existingRulesIter.next()).priority()).intValue()) > previousPriority + stepwidth || insertBefore.isPresent() && (foundRuleToInsertBefore = insertBefore.map((Function<RuleAdapter, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(com.sap.sse.landscape.aws.impl.LoadBalancerRuleInserter$RuleAdapter[] com.sap.sse.landscape.aws.impl.LoadBalancerRuleInserter$RuleAdapter ), (Lcom/sap/sse/landscape/aws/impl/LoadBalancerRuleInserter$RuleAdapter;)Ljava/lang/Boolean;)((RuleAdapter[])nextRule)).orElse(false).booleanValue()))) {
                    previousPriority = nextPriority;
                    if (existingRulesIter.hasNext()) continue;
                    nextPriority = this.maxPriority + 1;
                }
                if (foundRuleToInsertBefore) {
                    this.shiftRulesToMakeSpaceAt(nextPriority, remainingNumberOfRulesToAdd);
                    nextPriority += remainingNumberOfRulesToAdd;
                }
                if (previousPriority + stepwidth <= this.maxPriority) ** GOTO lbl43
                if (!forceContiguous) break block8;
                previousPriority = this.squeezeExistingRulesAndReturnLastUsedPriority(sortedExistingNonDefaultRules);
                nextPriority = this.maxPriority + 1;
                if (!LoadBalancerRuleInserter.$assertionsDisabled && previousPriority + rulesSize > this.maxPriority) {
                    throw new AssertionError();
                }
                ** GOTO lbl43
            }
            throw new IllegalStateException("The " + rulesSize + " new rules don't fit into the existing rule set of load balancer " + this.loadBalancerAdapter.getName() + " without exceeding the maximum priority of " + this.maxPriority);
lbl-1000:
            // 1 sources

            {
                priorityToUseForNextRule = previousPriority;
                result.add(((RuleAdapter)rulesIterator.next()).copyWithNewPriority(priorityToUseForNextRule));
                --remainingNumberOfRulesToAdd;
lbl43:
                // 3 sources

                ** while (rulesIterator.hasNext() && ++previousPriority < nextPriority)
            }
lbl44:
            // 1 sources

        }
        this.loadBalancerAdapter.addRules(result);
        return result;
    }

    private int squeezeExistingRulesAndReturnLastUsedPriority(List<RA> sortedExistingNonDefaultRules) {
        LinkedList newPrioritiesForExistingRules = new LinkedList();
        int priority = 0;
        for (RuleAdapter existingRule : sortedExistingNonDefaultRules) {
            newPrioritiesForExistingRules.add(new Util.Pair((Object)(++priority), (Object)existingRule));
        }
        this.loadBalancerAdapter.updateLoadBalancerListenerRulePriorities(newPrioritiesForExistingRules);
        return priority;
    }

    public Iterable<RA> getRulesSortedByPriority() {
        return Util.stream(this.loadBalancerAdapter.getRules()).filter(t -> !t.priority().equalsIgnoreCase("Default")).sorted((r1, r2) -> Integer.compare(Integer.valueOf(r1.priority()), Integer.valueOf(r2.priority())))::iterator;
    }

    public void shiftRulesToMakeSpaceAt(int targetPriority, int howManySlots) throws IllegalStateException {
        Iterable<RA> rulesSorted = this.getRulesSortedByPriority();
        int minimumPriorityForNextRule = targetPriority + howManySlots;
        ArrayList result = new ArrayList();
        for (RuleAdapter rule : rulesSorted) {
            int newPriorityForRule;
            int priority = Integer.valueOf(rule.priority());
            if (priority < targetPriority || priority >= minimumPriorityForNextRule) {
                newPriorityForRule = priority;
            } else {
                newPriorityForRule = minimumPriorityForNextRule;
                minimumPriorityForNextRule = newPriorityForRule + 1;
            }
            result.add(new Util.Pair((Object)newPriorityForRule, (Object)rule));
        }
        this.loadBalancerAdapter.updateLoadBalancerListenerRulePriorities(result);
    }

    private static /* synthetic */ boolean lambda$1(RuleAdapter r) {
        return !r.isDefault();
    }

    private static /* synthetic */ int lambda$2(RuleAdapter r1, RuleAdapter r2) {
        return Integer.valueOf(r1.priority()).compareTo(Integer.valueOf(r2.priority()));
    }

    private static /* synthetic */ Boolean lambda$3(RuleAdapter[] ruleAdapterArray, RuleAdapter rule) {
        return rule.ruleArn().equals(ruleAdapterArray[0].ruleArn());
    }

    private static class ALBAdapter<ShardingKey>
    implements LoadBalancerAdapter<ALBRuleAdapter> {
        private static final long serialVersionUID = -4337640786328697695L;
        private final ApplicationLoadBalancer<ShardingKey> alb;

        private ALBAdapter(ApplicationLoadBalancer<ShardingKey> alb) {
            this.alb = alb;
        }

        public String getName() {
            return this.alb.getName();
        }

        @Override
        public Iterable<ALBRuleAdapter> getRules() {
            return Util.map(this.alb.getRules(), r -> LoadBalancerRuleInserter.createRuleAdapter(r));
        }

        @Override
        public void updateLoadBalancerListenerRulePriorities(List<Util.Pair<Integer, ALBRuleAdapter>> newPrioritiesForExistingRules) {
            this.alb.getLandscape().updateLoadBalancerListenerRulePriorities(this.alb.getRegion(), Util.map(newPrioritiesForExistingRules, p -> (RulePriorityPair)RulePriorityPair.builder().priority((Integer)p.getA()).ruleArn(((ALBRuleAdapter)p.getB()).ruleArn()).build()));
        }

        @Override
        public void addRules(List<ALBRuleAdapter> rules) {
            this.alb.addRules((Rule[])Util.toArray((Iterable)Util.map(rules, ra -> ra.getRule()), (Object[])new Rule[0]));
        }
    }

    public static class ALBRuleAdapter
    implements RuleAdapter<ALBRuleAdapter> {
        private final Rule rule;

        private ALBRuleAdapter(Rule rule) {
            this.rule = rule;
        }

        @Override
        public boolean isDefault() {
            return this.rule.isDefault();
        }

        @Override
        public String priority() {
            return this.rule.priority();
        }

        @Override
        public String ruleArn() {
            return this.rule.ruleArn();
        }

        @Override
        public ALBRuleAdapter copyWithNewPriority(int priorityToUseForRuleCopy) {
            return new ALBRuleAdapter((Rule)this.rule.copy(b -> {
                Object object = b.priority("" + priorityToUseForRuleCopy).build();
            }));
        }

        Rule getRule() {
            return this.rule;
        }
    }

    public static interface LoadBalancerAdapter<RA extends RuleAdapter<RA>>
    extends Named {
        public Iterable<RA> getRules();

        public void updateLoadBalancerListenerRulePriorities(List<Util.Pair<Integer, RA>> var1);

        public void addRules(List<RA> var1);
    }

    public static interface RuleAdapter<RA extends RuleAdapter<RA>> {
        public boolean isDefault();

        public String priority();

        public String ruleArn();

        public RA copyWithNewPriority(int var1);
    }
}

