/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.landscape.Process;
import com.sap.sse.landscape.RotatingFileBasedLog;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.Scope;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.impl.AbstractApacheReverseProxy;
import com.sap.sse.landscape.ssh.SshCommandChannel;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApacheReverseProxy<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends AbstractApacheReverseProxy<ShardingKey, MetricsT, ProcessT>
implements Process<RotatingFileBasedLog, MetricsT> {
    private static final Logger logger = Logger.getLogger(ApacheReverseProxy.class.getName());
    private static final Optional<Duration> TIMEOUT = Optional.of(Duration.ONE_MINUTE.times(5L));
    private static final String RELATIVE_CONFIG_PATH = "conf.d";
    private static final String CONFIG_USER = "httpdConf";
    private static final String CONFIG_REPO_PATH = "~httpdConf/checked-out";
    private static final String CONFIG_REPO_MAIN_BRANCH_NAME = "main";
    private static final String CONFIG_FILE_EXTENSION = ".conf";
    private static final String HOME_REDIRECT_MACRO = "Home-SSL";
    private static final String PLAIN_REDIRECT_MACRO = "Plain-SSL";
    private static final String EVENT_REDIRECT_MACRO = "Event-SSL";
    private static final String SERIES_REDIRECT_MACRO = "Series-SSL";
    private static final String HOME_ARCHIVE_REDIRECT_MACRO = "Home-ARCHIVE";
    private static final String EVENT_ARCHIVE_REDIRECT_MACRO = "Event-ARCHIVE";
    private static final String SERIES_ARCHIVE_REDIRECT_MACRO = "Series-ARCHIVE";
    private final AwsInstance<ShardingKey> host;

    public ApacheReverseProxy(AwsLandscape<ShardingKey> landscape, AwsInstance<ShardingKey> host) {
        super(landscape);
        this.host = host;
    }

    private String getConfigFileNameForScope(Scope<ShardingKey> scope) {
        return String.valueOf(scope.toString()) + CONFIG_FILE_EXTENSION;
    }

    private String getConfigFileNameForHostname(String hostname) {
        return String.valueOf(hostname) + CONFIG_FILE_EXTENSION;
    }

    public void rotateLogs(Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String command = "logrotate --force -v /etc/logrotate.d/httpd 2>&1;  echo \"logrotate done\"";
        logger.info("Standard output from forced log rotate on " + this.getHostname() + ": " + this.runCommandAndReturnStdoutAndStderr("logrotate --force -v /etc/logrotate.d/httpd 2>&1;  echo \"logrotate done\"", "Standard error from logrotate ", Level.ALL, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    private void setRedirect(String configFileNameForHostname, String macroName, String hostname, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase, boolean doCommit, boolean doPush, String ... macroArguments) throws Exception {
        String command = "su - httpdConf -c 'cd ~httpdConf/checked-out && git checkout main && echo \"Use " + macroName + " " + hostname + " " + String.join((CharSequence)" ", macroArguments) + "\" > " + this.getAbsoluteConfigFilePath(configFileNameForHostname);
        if (doCommit) {
            command = String.valueOf(command) + "  && cd " + CONFIG_REPO_PATH + " && " + this.createCommitAndPushString(configFileNameForHostname, "Set " + configFileNameForHostname + " redirect", doPush);
        }
        command = String.valueOf(command) + "'; service httpd reload";
        logger.info("Standard output from setting up the re-direct for " + hostname + " and reloading the Apache httpd server: " + this.runCommandAndReturnStdoutAndStderr(command, "Standard error from setting up the re-direct for " + hostname + " and reloading the Apache httpd server: ", Level.INFO, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    public void setRedirect(String configFileNameForHostname, String macroName, String hostname, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase, String ... macroArguments) throws Exception {
        this.setRedirect(configFileNameForHostname, macroName, hostname, optionalKeyName, privateKeyEncryptionPassphrase, true, true, macroArguments);
    }

    private String runCommandAndReturnStdoutAndStderr(String command, String stderrLogPrefix, Level stderrLogLevel, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        SshCommandChannel sshChannel = this.getHost().createRootSshChannel(TIMEOUT, optionalKeyName, privateKeyEncryptionPassphrase);
        String stdout = sshChannel.runCommandAndReturnStdoutAndLogStderr(command, stderrLogPrefix, stderrLogLevel);
        return stdout;
    }

    private String createCommitAndPushString(String editedFileName, String commitMsg, boolean performPush) {
        StringBuilder command = new StringBuilder(" git add " + this.getRelativeConfigFilePath(editedFileName) + " && git commit -m " + "\"" + commitMsg + "\"");
        if (performPush) {
            command.append(" ; GIT_SSH_COMMAND=\"ssh -o StrictHostKeyChecking=no\" git push origin main");
        }
        return command.toString();
    }

    private String getRelativeConfigFilePath(String configFileNameForHostname) {
        return "conf.d/" + configFileNameForHostname;
    }

    private String getAbsoluteConfigFilePath(String configFileNameForHostname) {
        return "~httpdConf/checked-out/conf.d/" + configFileNameForHostname;
    }

    @Override
    public void setScopeRedirect(Scope<ShardingKey> scope, ProcessT applicationReplicaSet) {
    }

    @Override
    public void setPlainRedirect(String hostname, ProcessT applicationProcess, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String host = applicationProcess.getHost().getPrivateAddress().getHostAddress();
        int port = applicationProcess.getPort();
        this.setRedirect(this.getConfigFileNameForHostname(hostname), PLAIN_REDIRECT_MACRO, hostname, optionalKeyName, privateKeyEncryptionPassphrase, host, "" + port);
    }

    @Override
    public void setHomeRedirect(String hostname, ProcessT applicationProcess, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String host = applicationProcess.getHost().getPrivateAddress().getHostAddress();
        int port = applicationProcess.getPort();
        this.setRedirect(this.getConfigFileNameForHostname(hostname), HOME_REDIRECT_MACRO, hostname, optionalKeyName, privateKeyEncryptionPassphrase, host, "" + port);
    }

    @Override
    public void setEventRedirect(String hostname, ProcessT applicationProcess, UUID eventId, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String host = applicationProcess.getHost().getPrivateAddress().getHostAddress();
        int port = applicationProcess.getPort();
        this.setRedirect(this.getConfigFileNameForHostname(hostname), EVENT_REDIRECT_MACRO, hostname, optionalKeyName, privateKeyEncryptionPassphrase, eventId.toString(), host, "" + port);
    }

    @Override
    public void setEventSeriesRedirect(String hostname, ProcessT applicationProcess, UUID leaderboardGroupId, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String host = applicationProcess.getHost().getPrivateAddress().getHostAddress();
        int port = applicationProcess.getPort();
        this.setRedirect(this.getConfigFileNameForHostname(hostname), SERIES_REDIRECT_MACRO, hostname, optionalKeyName, privateKeyEncryptionPassphrase, leaderboardGroupId.toString(), host, "" + port);
    }

    @Override
    public void setHomeArchiveRedirect(String hostname, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(this.getConfigFileNameForHostname(hostname), HOME_ARCHIVE_REDIRECT_MACRO, hostname, optionalKeyName, privateKeyEncryptionPassphrase, new String[0]);
    }

    @Override
    public void setEventArchiveRedirect(String hostname, UUID eventId, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(this.getConfigFileNameForHostname(hostname), EVENT_ARCHIVE_REDIRECT_MACRO, hostname, optionalKeyName, privateKeyEncryptionPassphrase, eventId.toString());
    }

    @Override
    public void setEventSeriesArchiveRedirect(String hostname, UUID leaderboardGroupId, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(this.getConfigFileNameForHostname(hostname), SERIES_ARCHIVE_REDIRECT_MACRO, hostname, optionalKeyName, privateKeyEncryptionPassphrase, leaderboardGroupId.toString());
    }

    @Override
    public void removeRedirect(Scope<ShardingKey> scope, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String configFileName = this.getConfigFileNameForScope(scope);
        this.removeRedirect(configFileName, scope.toString(), optionalKeyName, privateKeyEncryptionPassphrase);
    }

    @Override
    public void removeRedirect(String hostname, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String configFileName = this.getConfigFileNameForHostname(hostname);
        this.removeRedirect(configFileName, hostname, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    private void removeRedirect(String configFileName, String hostname, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        StringBuilder command = new StringBuilder("su - httpdConf -c '");
        command.append("cd ");
        command.append(CONFIG_REPO_PATH);
        command.append(" && git checkout ");
        command.append(CONFIG_REPO_MAIN_BRANCH_NAME);
        command.append(" && rm ");
        command.append(this.getRelativeConfigFilePath(configFileName));
        command.append("; ");
        command.append(this.createCommitAndPushString(configFileName, "Removed " + hostname, true));
        command.append("'; service httpd reload;");
        logger.info("Standard output from removing the re-direct for " + hostname + " and reloading the Apache httpd server: " + this.runCommandAndReturnStdoutAndStderr(command.toString(), "Standard error from removing the re-direct for " + hostname + " and reloading the Apache httpd server: ", Level.INFO, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void terminate() {
        this.getLandscape().terminate(this.host);
    }

    public int getPort() {
        return 80;
    }

    public AwsInstance<ShardingKey> getHost() {
        return this.host;
    }

    public RotatingFileBasedLog getLog() {
        return null;
    }

    public MetricsT getMetrics() {
        return null;
    }

    public boolean isReady(Optional<Duration> optionalTimeout) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(this.getPort() == 443 ? "https" : "http", this.getHost().getPublicAddress(optionalTimeout).getCanonicalHostName(), this.getPort(), this.getHealthCheckPath()).openConnection();
            return connection.getResponseCode() == 200;
        }
        catch (Exception e) {
            logger.info("Ready-check failed for " + this + ": " + e.getMessage());
            return false;
        }
    }
}

