/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.structureimport.buildstructure;

import com.sap.sailing.xrr.schema.Race;
import com.sap.sailing.xrr.structureimport.buildstructure.GuessSeriesStrategy;
import com.sap.sailing.xrr.structureimport.buildstructure.Series;
import java.util.ArrayList;
import java.util.List;

public class RegattaStructure {
    List<Series> series = new ArrayList<Series>();
    GuessSeriesStrategy guessSeriesStrategy;

    public RegattaStructure(GuessSeriesStrategy guessSeriesStrategy) {
        this.guessSeriesStrategy = guessSeriesStrategy;
    }

    public void addRace(Race race, int[] numberOfRaces) {
        String oneSeries = this.guessSeriesStrategy.guessSeries(race.getRaceName());
        boolean added = false;
        for (Series singleSeries : this.series) {
            if (!singleSeries.getSeries().equals(oneSeries)) continue;
            singleSeries.addRace(race, numberOfRaces);
            added = true;
        }
        if (!added) {
            Series newSeries = new Series(oneSeries);
            newSeries.addRace(race, numberOfRaces);
            this.series.add(newSeries);
        }
    }

    public Iterable<Series> getSeries() {
        return this.series;
    }

    public void checkSeries() {
        if (this.series.size() == 1) {
            this.series.iterator().next().setSeries("Default");
        }
    }
}

