/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.structureimport;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.BoatImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.FleetImpl;
import com.sap.sailing.domain.base.impl.PersonImpl;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.base.impl.SeriesImpl;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.FleetColors;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.ranking.OneDesignRankingMetric;
import com.sap.sailing.xrr.resultimport.ParserFactory;
import com.sap.sailing.xrr.schema.Boat;
import com.sap.sailing.xrr.schema.Crew;
import com.sap.sailing.xrr.schema.Division;
import com.sap.sailing.xrr.schema.Event;
import com.sap.sailing.xrr.schema.Person;
import com.sap.sailing.xrr.schema.Race;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sailing.xrr.schema.Team;
import com.sap.sailing.xrr.structureimport.BoatAndTeam;
import com.sap.sailing.xrr.structureimport.buildstructure.BuildStructure;
import com.sap.sailing.xrr.structureimport.buildstructure.Fleet;
import com.sap.sailing.xrr.structureimport.buildstructure.GuessFleetOrderingFromFleetName;
import com.sap.sailing.xrr.structureimport.buildstructure.RegattaStructure;
import com.sap.sailing.xrr.structureimport.buildstructure.Series;
import com.sap.sailing.xrr.structureimport.buildstructure.SetRacenumberStrategy;
import com.sap.sse.common.Color;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.AbstractColor;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sapsailing.xrr.structureimport.eventimport.EventImport;
import com.sapsailing.xrr.structureimport.eventimport.RegattaJSON;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class StructureImporter {
    private static final Logger logger = Logger.getLogger(StructureImporter.class.getName());
    private LinkedHashMap<String, Boat> boatForPerson;
    private final DomainFactory baseDomainFactory;
    private final SetRacenumberStrategy setRacenumberStrategy;
    private static final String UNKNOWN_BOATCLASS_NAME = "?";

    public StructureImporter(SetRacenumberStrategy setRacenumber, DomainFactory baseDomainFactory) {
        this.setRacenumberStrategy = setRacenumber;
        this.baseDomainFactory = baseDomainFactory;
    }

    public StructureImporter(DomainFactory baseDomainFactory) {
        this(null, baseDomainFactory);
    }

    public StructureImporter() {
        this(null, null);
    }

    public Iterable<RegattaJSON> parseEvent(String url) {
        return new EventImport().getRegattas(url);
    }

    public Iterable<Regatta> getRegattas(Iterable<RegattaJSON> regattas) {
        Iterable<Util.Pair<RegattaJSON, RegattaResults>> parsedRegattas = this.parseRegattas(regattas);
        HashSet<Regatta> addSpecificRegattas = new HashSet<Regatta>();
        for (Util.Pair<RegattaJSON, RegattaResults> result : parsedRegattas) {
            String boatClassName;
            ArrayList<Race> races = new ArrayList<Race>();
            Event event = (Event)((RegattaResults)result.getB()).getPersonOrBoatOrTeam().get(((RegattaResults)result.getB()).getPersonOrBoatOrTeam().size() - 1);
            List raceOrDivisionOrRegattaSeriesResults = event.getRaceOrDivisionOrRegattaSeriesResult();
            for (Object raceOrDivisionOrRegattaSeriesResult : raceOrDivisionOrRegattaSeriesResults) {
                if (!(raceOrDivisionOrRegattaSeriesResult instanceof Race)) continue;
                races.add((Race)raceOrDivisionOrRegattaSeriesResult);
            }
            BuildStructure buildStructure = new BuildStructure(races);
            TimePoint startDate = null;
            TimePoint endDate = null;
            String regattaName = RegattaImpl.getDefaultName((String)event.getTitle(), (String)((Division)event.getRaceOrDivisionOrRegattaSeriesResult().get(0)).getTitle());
            if (((RegattaJSON)result.getA()).getBoatClass() != null) {
                boatClassName = ((RegattaJSON)result.getA()).getBoatClass();
            } else {
                logger.warning("No boat class set in regatta to import: " + regattaName + ". Setting to \"" + UNKNOWN_BOATCLASS_NAME + "\"");
                boatClassName = UNKNOWN_BOATCLASS_NAME;
            }
            RegattaImpl regatta = new RegattaImpl(regattaName, this.baseDomainFactory.getOrCreateBoatClass(boatClassName), true, CompetitorRegistrationType.CLOSED, startDate, endDate, this.getSeries(buildStructure), false, this.baseDomainFactory.createScoringScheme(ScoringSchemeType.LOW_POINT), (Serializable)((Object)event.getEventID()), null, OneDesignRankingMetric::new, UUID.randomUUID().toString());
            addSpecificRegattas.add((Regatta)regatta);
        }
        return addSpecificRegattas;
    }

    private Iterable<Util.Pair<RegattaJSON, RegattaResults>> parseRegattas(Iterable<RegattaJSON> selectedRegattas) {
        final Set<Util.Pair<RegattaJSON, RegattaResults>> result = Collections.synchronizedSet(new HashSet());
        HashSet<1> threads = new HashSet<1>();
        for (final RegattaJSON regattaJSON : selectedRegattas) {
            Thread thread = new Thread("XRR Importer " + regattaJSON.getName()){

                @Override
                public void run() {
                    try {
                        result.add(new Util.Pair((Object)regattaJSON, (Object)StructureImporter.this.parseRegattaXML(regattaJSON.getXrrEntriesUrl())));
                    }
                    catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                        logger.info("Parse error during XRR import. Ignoring document " + regattaJSON.getName());
                    }
                }
            };
            thread.start();
            threads.add(thread);
        }
        while (true) {
            try {
                for (Thread thread : threads) {
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return result;
    }

    private Iterable<SeriesImpl> getSeries(BuildStructure structure) {
        ArrayList<SeriesImpl> series = new ArrayList<SeriesImpl>();
        RegattaStructure regattaStructure = structure.getRegattaStructure();
        if (regattaStructure != null) {
            int index = 0;
            for (Series raceType : regattaStructure.getSeries()) {
                List<com.sap.sailing.domain.base.Fleet> fleets = this.getFleets(raceType.getFleets());
                this.setRaceNames(index, raceType, raceType.getFleets());
                series.add(new SeriesImpl(raceType.getSeries(), raceType.isMedal(), true, fleets, raceType.getRaceNames(), null));
            }
        }
        return series;
    }

    private void setRaceNames(int i, Series raceType, List<Fleet> fleets) {
        Iterable<Race> races = fleets.get(raceType.getMaxIndex()).getRaces();
        for (Race race : races) {
            this.setRacenumberStrategy.setRacenumber(race, raceType, i);
        }
    }

    private List<com.sap.sailing.domain.base.Fleet> getFleets(List<Fleet> fleets) {
        ArrayList<com.sap.sailing.domain.base.Fleet> fleetsImpl = new ArrayList<com.sap.sailing.domain.base.Fleet>();
        GuessFleetOrderingFromFleetName fleetOrderingStrategy = new GuessFleetOrderingFromFleetName();
        String fleetColor = "";
        if (fleets.size() <= 1) {
            fleetColor = "Default";
            FleetImpl fleetImpl = new FleetImpl(fleetColor, 0, this.getColorFromString(fleetColor));
            fleetsImpl.add((com.sap.sailing.domain.base.Fleet)fleetImpl);
        } else {
            for (Fleet fleet : fleets) {
                fleetColor = fleet.getColor();
                FleetImpl fleetImpl = new FleetImpl(fleetColor, fleetOrderingStrategy.guessOrder(fleet.getColor()), this.getColorFromString(fleetColor));
                fleetsImpl.add((com.sap.sailing.domain.base.Fleet)fleetImpl);
            }
        }
        return fleetsImpl;
    }

    private Color getColorFromString(String colorString) {
        Color result = null;
        FleetColors[] fleetColorsArray = FleetColors.values();
        int n = fleetColorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            FleetColors fleetColor = fleetColorsArray[n2];
            if (fleetColor.name().equalsIgnoreCase(colorString)) {
                result = fleetColor.getColor();
                break;
            }
            ++n2;
        }
        if (result == null) {
            result = AbstractColor.getColorByLowercaseNameStatic((String)colorString.toLowerCase());
        }
        return result;
    }

    public void setCompetitors(Set<RegattaResults> results, String boatClassName) {
        block0: for (RegattaResults result : results) {
            BoatClass boatClass = null;
            boatClass = this.getBoatClass(boatClassName);
            List personOrBoatOrTeam = result.getPersonOrBoatOrTeam();
            this.setBoatsAndTeamsForPerson(personOrBoatOrTeam);
            for (Object obj : personOrBoatOrTeam) {
                if (!(obj instanceof Person)) continue block0;
                Person person = (Person)obj;
                String idAsString = person.getPersonID();
                String name = String.valueOf(person.getGivenName()) + " " + person.getFamilyName();
                String shortName = null;
                Color color = null;
                String email = null;
                URI flagImage = null;
                Nationality nationality = person.getNOC() == null ? null : this.getNationality(person.getNOC().toString());
                BoatAndTeam boatAndTeam = this.getBoatAndTeam(idAsString, name, nationality, boatClass);
                this.baseDomainFactory.convertToCompetitorDTO((Competitor)this.baseDomainFactory.getOrCreateCompetitor((Serializable)UUID.fromString(idAsString), name, shortName, color, email, flagImage, boatAndTeam.getTeam(), null, null, null, true));
            }
        }
    }

    private BoatClass getBoatClass(String boatClassName) {
        BoatClass boatClass = boatClassName != null && !boatClassName.equals("") ? this.baseDomainFactory.getOrCreateBoatClass(boatClassName) : this.baseDomainFactory.getOrCreateBoatClass("default");
        return boatClass;
    }

    private Nationality getNationality(String country) {
        return this.baseDomainFactory.getOrCreateNationality(country);
    }

    private void setBoatsAndTeamsForPerson(Iterable<Object> personOrBoatOrTeam) {
        this.boatForPerson = new LinkedHashMap();
        LinkedHashMap<String, Team> teamForBoat = new LinkedHashMap<String, Team>();
        for (Object obj : personOrBoatOrTeam) {
            if (!(obj instanceof Team)) continue;
            teamForBoat.put(((Team)obj).getBoatID(), (Team)obj);
        }
        for (Object obj : personOrBoatOrTeam) {
            if (!(obj instanceof Boat)) continue;
            Team team = (Team)teamForBoat.get(((Boat)obj).getBoatID());
            List crew = team.getCrew();
            for (Crew person : crew) {
                this.boatForPerson.put(person.getPersonID(), (Boat)obj);
            }
        }
    }

    private BoatAndTeam getBoatAndTeam(String idAsString, String name, Nationality nationality, BoatClass boatClass) {
        DynamicBoat boat = this.createBoat(name, this.boatForPerson.get(idAsString), boatClass);
        if (nationality == null) {
            nationality = this.createNationalityFromSailID(boat.getSailID());
        }
        DynamicTeam team = this.createTeam(name, nationality);
        return new BoatAndTeam(boat, team);
    }

    private Nationality createNationalityFromSailID(String sailID) {
        String country = "";
        if (sailID.length() >= 3) {
            int i = 0;
            while (i < 3) {
                country = String.valueOf(country) + sailID.charAt(i);
                ++i;
            }
            return this.getNationality(country);
        }
        return null;
    }

    private DynamicBoat createBoat(String name, Boat boat, BoatClass boatClass) {
        BoatImpl boat1 = new BoatImpl((Serializable)((Object)(String.valueOf(name) + " boat")), String.valueOf(name) + " boat", boatClass, boat.getSailNumber());
        return boat1;
    }

    private DynamicTeam createTeam(String name, Nationality nationality) {
        PersonImpl sailor = new PersonImpl(name, nationality, null, null);
        TeamImpl team = new TeamImpl(String.valueOf(name) + " team", Collections.singleton(sailor), null);
        return team;
    }

    private RegattaResults parseRegattaXML(String url) throws FileNotFoundException, JAXBException, IOException, SAXException, ParserConfigurationException {
        return ParserFactory.INSTANCE.createParser(this.getInputStream(url), "").parse();
    }

    private InputStream getInputStream(String url) throws FileNotFoundException, IOException {
        URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)new URL(url));
        return connection.getInputStream();
    }
}

