/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl.fixtracker;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogDenoteForTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RaceLogTrackingStateAnalyzer;
import com.sap.sailing.domain.common.racelog.tracking.RaceLogTrackingState;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.racelogsensortracking.SensorFixMapperFactory;
import com.sap.sailing.domain.racelogtracking.impl.fixtracker.FixLoaderAndTracker;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.TrackingDataLoader;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class RaceLogFixTrackerManager
implements TrackingDataLoader {
    private static final Logger logger = Logger.getLogger(RaceLogFixTrackerManager.class.getName());
    private final DynamicTrackedRace trackedRace;
    private final SensorFixStore sensorFixStore;
    private final boolean removeOutliersFromCompetitorTracks;
    private final SensorFixMapperFactory sensorFixMapperFactory;
    private final Set<RaceLog> knownRaceLogs = new HashSet<RaceLog>();
    private FixLoaderAndTracker tracker;
    private final RaceChangeListener raceChangeListener = new AbstractRaceChangeListener(){

        public void raceLogAttached(RaceLog raceLog) {
            RaceLogFixTrackerManager.this.addRaceLog(raceLog);
        }

        public void raceLogDetached(RaceLog raceLog) {
            RaceLogFixTrackerManager.this.removeRaceLog(raceLog);
        }
    };
    private final RaceLogEventVisitor raceLogEventVisitor = new BaseRaceLogEventVisitor(){

        public void visit(RaceLogDenoteForTrackingEvent event) {
            RaceLogFixTrackerManager.this.updateDenotationState();
        }

        public void visit(RaceLogRevokeEvent event) {
            RaceLogFixTrackerManager.this.updateDenotationState();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaceLogFixTrackerManager(DynamicTrackedRace trackedRace, SensorFixStore sensorFixStore, SensorFixMapperFactory sensorFixMapperFactory, boolean removeOutliersFromCompetitorTracks) {
        this.removeOutliersFromCompetitorTracks = removeOutliersFromCompetitorTracks;
        this.trackedRace = trackedRace;
        this.sensorFixStore = sensorFixStore;
        this.sensorFixMapperFactory = sensorFixMapperFactory;
        trackedRace.addListener(this.raceChangeListener);
        Set<RaceLog> set = this.knownRaceLogs;
        synchronized (set) {
            for (RaceLog raceLog : trackedRace.getAttachedRaceLogs()) {
                this.addRaceLogUnlocked(raceLog);
            }
        }
        this.updateDenotationState();
    }

    private synchronized void updateDenotationState() {
        if (this.isForTracking()) {
            this.startTrackerIfNotAlreadyStarted();
        } else {
            this.stopTrackerIfStillRunning(false, false);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRaceLog(RaceLog raceLog) {
        Set<RaceLog> set = this.knownRaceLogs;
        synchronized (set) {
            this.addRaceLogUnlocked(raceLog);
        }
        this.updateDenotationState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRaceLog(RaceLog raceLog) {
        Set<RaceLog> set = this.knownRaceLogs;
        synchronized (set) {
            this.removeRaceLogUnlocked(raceLog);
        }
        this.updateDenotationState();
    }

    private void addRaceLogUnlocked(RaceLog raceLog) {
        this.knownRaceLogs.add(raceLog);
        raceLog.addListener((Object)this.raceLogEventVisitor);
    }

    private void removeRaceLogUnlocked(RaceLog raceLog) {
        raceLog.removeListener((Object)this.raceLogEventVisitor);
        this.knownRaceLogs.remove(raceLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean preemptive, boolean willBeRemoved) {
        this.stopTrackerIfStillRunning(preemptive, willBeRemoved);
        this.trackedRace.removeListener(this.raceChangeListener);
        Set<RaceLog> set = this.knownRaceLogs;
        synchronized (set) {
            HashSet<RaceLog> tempSet = new HashSet<RaceLog>(this.knownRaceLogs);
            for (RaceLog raceLog : tempSet) {
                this.removeRaceLogUnlocked(raceLog);
            }
        }
    }

    private synchronized void startTrackerIfNotAlreadyStarted() {
        if (this.tracker == null) {
            logger.fine("Starting fix tracker for TrackedRace: " + this.trackedRace.getRaceIdentifier());
            this.tracker = new FixLoaderAndTracker(this.trackedRace, this.sensorFixStore, this.sensorFixMapperFactory, this.removeOutliersFromCompetitorTracks);
        }
    }

    private synchronized void stopTrackerIfStillRunning(boolean preemptive, boolean willBeRemoved) {
        if (this.tracker != null) {
            logger.fine("Stopping fix tracker for TrackedRace: " + this.trackedRace.getRaceIdentifier());
            this.tracker.stop(preemptive, willBeRemoved);
            this.tracker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isForTracking() {
        Set<RaceLog> set = this.knownRaceLogs;
        synchronized (set) {
            RaceLog raceLog;
            RaceLogTrackingState raceLogTrackingState;
            Iterator<RaceLog> iterator = this.knownRaceLogs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(raceLogTrackingState = (RaceLogTrackingState)new RaceLogTrackingStateAnalyzer(raceLog = iterator.next()).analyze()).isForTracking());
            return true;
        }
    }

    public synchronized FixLoaderAndTracker waitForTracker() throws InterruptedException {
        while (this.tracker == null) {
            this.wait();
        }
        return this.tracker;
    }
}

