/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogTrackingI18n;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.mail.SerializableDefaultMimeBodyPartSupplier;
import com.sap.sse.mail.SerializableFileMimeBodyPartSupplier;
import com.sap.sse.mail.SerializableMimeBodyPartSupplier;
import com.sap.sse.mail.SerializableMultipartMimeBodyPartSupplier;
import com.sap.sse.mail.SerializableMultipartSupplier;
import com.sap.sse.shared.media.ImageDescriptor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.mail.MessagingException;

abstract class RaceLogTrackingInvitationMailBuilder {
    private static final Logger LOG = Logger.getLogger(RaceLogTrackingInvitationMailBuilder.class.getName());
    protected static final String TEXT_LINE_BREAK = "\r\n";
    private String subject;
    protected final Locale locale;
    protected final Map<String, byte[]> pngAttachAndInline = new HashMap<String, byte[]>();
    protected final StringBuilder html = new StringBuilder();
    protected final StringBuilder text = new StringBuilder();

    public RaceLogTrackingInvitationMailBuilder(Locale locale) {
        this.locale = locale;
    }

    protected abstract void addIntroductoryText(String var1, String var2);

    public abstract RaceLogTrackingInvitationMailBuilder addSailInsightDeeplink(String var1, String var2, String var3);

    public abstract RaceLogTrackingInvitationMailBuilder addBuoyPingerDeeplink(String var1, String var2, String var3);

    RaceLogTrackingInvitationMailBuilder withSubject(String invitee) {
        this.subject = RaceLogTrackingI18n.trackingInvitationFor(this.locale, invitee);
        return this;
    }

    protected void insertImage(byte[] cidImage, String cidSource, String alt) {
        this.pngAttachAndInline.put(cidSource, cidImage);
        this.html.append("<img alt=\"").append(alt).append("\" src=\"cid:").append(cidSource).append("\"/>");
        this.html.append("<br>");
    }

    public String getSubject() {
        return this.subject;
    }

    RaceLogTrackingInvitationMailBuilder addEventLogo(Event event) {
        List imagesWithTag = event.findImagesWithTag(MediaTagConstants.LOGO.getName());
        if (imagesWithTag != null && !imagesWithTag.isEmpty()) {
            ImageDescriptor imageDescriptor = (ImageDescriptor)imagesWithTag.get(0);
            String logoUrl = imageDescriptor.getURL().toString();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream is = new URL(logoUrl).openStream();){
                    BufferedImage image = ImageIO.read(is);
                    ImageIO.write((RenderedImage)image, "png", baos);
                    this.insertImage(baos.toByteArray(), "logo", logoUrl);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error while getting event image for invitation mail", e);
            }
        }
        return this;
    }

    RaceLogTrackingInvitationMailBuilder addHeadline(Event event, Leaderboard leaderboard) {
        String lbdn = leaderboard.getDisplayName() == null ? leaderboard.getName() : leaderboard.getDisplayName();
        String welcomeText = RaceLogTrackingI18n.welcomeTo(this.locale, event.getName(), lbdn);
        this.html.append("<h1>").append(welcomeText).append("</h1>");
        this.text.append(welcomeText).append(TEXT_LINE_BREAK);
        return this;
    }

    RaceLogTrackingInvitationMailBuilder addSailInSightIntroductoryText(String invitee) {
        this.addIntroductoryText(RaceLogTrackingI18n.sailInSightAppName(this.locale), invitee);
        return this;
    }

    RaceLogTrackingInvitationMailBuilder addBuoyPingerIntroductoryText(String invitee) {
        this.addIntroductoryText(RaceLogTrackingI18n.buoyPingerAppName(this.locale), invitee);
        return this;
    }

    SerializableMultipartSupplier getMultipartSupplier() throws MessagingException {
        SerializableMultipartSupplier mixedSupplier = new SerializableMultipartSupplier("mixed");
        SerializableMultipartSupplier alternativeSupplier = new SerializableMultipartSupplier("alternative");
        mixedSupplier.addBodyPart((SerializableMimeBodyPartSupplier)new SerializableMultipartMimeBodyPartSupplier(alternativeSupplier));
        alternativeSupplier.addBodyPart((SerializableMimeBodyPartSupplier)new SerializableDefaultMimeBodyPartSupplier((Serializable)((Object)this.text.toString()), "text/plain; charset=UTF-8"));
        SerializableMultipartSupplier relatedSupplier = new SerializableMultipartSupplier("related");
        alternativeSupplier.addBodyPart((SerializableMimeBodyPartSupplier)new SerializableMultipartMimeBodyPartSupplier(relatedSupplier));
        relatedSupplier.addBodyPart((SerializableMimeBodyPartSupplier)new SerializableDefaultMimeBodyPartSupplier((Serializable)((Object)this.html.toString()), "text/html; charset=UTF-8"));
        for (Map.Entry<String, byte[]> imageEntry : this.pngAttachAndInline.entrySet()) {
            String contentType = "image/png";
            String cid = "<" + imageEntry.getKey() + ">";
            String filename = String.valueOf(imageEntry.getKey()) + ".png";
            byte[] img = imageEntry.getValue();
            relatedSupplier.addBodyPart((SerializableMimeBodyPartSupplier)new SerializableFileMimeBodyPartSupplier(img, "image/png", cid, filename));
            mixedSupplier.addBodyPart((SerializableMimeBodyPartSupplier)new SerializableFileMimeBodyPartSupplier(img, "image/png", filename));
        }
        return mixedSupplier;
    }

    protected void addTextLink(String url, Function<Locale, String> textFactory) {
        this.text.append(textFactory.apply(this.locale)).append(":");
        this.text.append(TEXT_LINE_BREAK);
        this.text.append(url);
        this.text.append(TEXT_LINE_BREAK);
        this.text.append(TEXT_LINE_BREAK);
    }
}

