/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.geocoding.impl;

import com.sap.sailing.domain.common.Placemark;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.PlacemarkImpl;
import com.sap.sailing.domain.common.quadtree.QuadTree;
import com.sap.sailing.geocoding.ReverseGeocoder;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ReverseGeocoderImpl
implements ReverseGeocoder {
    private static final String USERNAMES_SYSTEM_PROPERTY_NAME = "geonames.org.usernames";
    private static final String USERNAMES_ENV_VARIABLE_NAME = "GEONAMES_ORG_USERNAMES";
    private static final String GEONAMES_DEFAULT_USER_NAME = "sailtracking0";
    private static final String DATES = "dates";
    private static final String TIMEZONE_ID = "timezoneId";
    private static final String BASE_URL = "http://api.geonames.org";
    private static final String NEARBY_PLACE_SERVICE = "http://api.geonames.org/findNearbyPlaceNameJSON?";
    private static final String SEARCH_BY_NAME_SERVICE = "http://api.geonames.org/searchJSON?";
    private static final String SEARCH_TIMEZONE_BY_POSITION = "http://api.geonames.org/timezoneJSON?";
    private final double POSITION_CACHE_DISTANCE_LIMIT = 0.04499640028797696;
    private final int XKM_RADIUS = 5;
    private final int ROWS_PER_XKM_RADIUS = 15;
    private final int MAX_ROW_NUMBER = 500;
    private final int MAX_RADIUS = 300;
    private final String[] usernames;
    private QuadTree<Util.Triple<Position, Double, List<Placemark>>> cache = new QuadTree();
    private static final Logger logger = Logger.getLogger(ReverseGeocoderImpl.class.getName());

    public ReverseGeocoderImpl() {
        String commaSeparatedUsernames = System.getProperty(USERNAMES_SYSTEM_PROPERTY_NAME, Optional.ofNullable(System.getenv(USERNAMES_ENV_VARIABLE_NAME)).orElse(GEONAMES_DEFAULT_USER_NAME));
        this.usernames = commaSeparatedUsernames.split(",");
    }

    @Override
    public TimeZone getTimeZone(Position position, TimePoint timePoint) throws MalformedURLException, IOException, ParseException {
        TimeZone resolvedTimeZone = null;
        JSONObject timeZoneObject = this.callTimezoneService(position, timePoint);
        if (timeZoneObject != null) {
            JSONArray dates;
            if (timeZoneObject.containsKey((Object)TIMEZONE_ID)) {
                String timeZoneId = timeZoneObject.get((Object)TIMEZONE_ID).toString();
                resolvedTimeZone = TimeZone.getTimeZone(timeZoneId);
            }
            if (resolvedTimeZone == null && timeZoneObject.containsKey((Object)DATES) && (dates = (JSONArray)timeZoneObject.get((Object)DATES)).size() > 1 && ((JSONObject)dates.get(1)).containsKey((Object)"offsetToGmt")) {
                int offsetToGmtMillis = (int)(Double.parseDouble(((JSONObject)dates.get(1)).get((Object)"offsetToGmt").toString()) * 3600.0 * 1000.0);
                resolvedTimeZone = this.getTimeZoneWithOffsetAtTime(offsetToGmtMillis, timePoint);
            }
        }
        return resolvedTimeZone;
    }

    private TimeZone getTimeZoneWithOffsetAtTime(int offsetToGmtMillis, TimePoint timePoint) {
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tzId = stringArray[n2];
            TimeZone tz = TimeZone.getTimeZone(tzId);
            if (tz.getOffset(timePoint.asMillis()) == offsetToGmtMillis) {
                return tz;
            }
            ++n2;
        }
        return null;
    }

    private JSONObject callTimezoneService(Position position, TimePoint timePoint) throws MalformedURLException, IOException, ParseException {
        StringBuilder url = this.generateRequestUrlTimezoneService(position, timePoint);
        JSONObject geonames = this.submitGeonamesRequestForJSONObjectResult(url);
        return geonames;
    }

    private StringBuilder generateRequestUrlTimezoneService(Position position, TimePoint timePoint) {
        StringBuilder url = new StringBuilder(SEARCH_TIMEZONE_BY_POSITION);
        url.append("lat=" + Double.toString(position.getLatDeg()));
        url.append("&lng=" + Double.toString(position.getLngDeg()));
        url.append("&radius=10");
        url.append("&date=" + new SimpleDateFormat("yyyy-MM-dd").format(timePoint.asDate()));
        return url;
    }

    private JSONObject submitGeonamesRequestForJSONObjectResult(StringBuilder url) throws MalformedURLException, IOException, ParseException {
        URLConnection connection = this.addUsernameParameterAndConnect(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse((Reader)in);
        return obj;
    }

    @Override
    public Placemark getPlacemarkNearest(Position position) throws IOException, ParseException {
        Placemark p = null;
        Util.Triple<Position, Double, List<Placemark>> cachedPlacemarks = this.checkCache(position);
        if (cachedPlacemarks != null && cachedPlacemarks.getC() != null && !((List)cachedPlacemarks.getC()).isEmpty()) {
            p = (Placemark)((List)cachedPlacemarks.getC()).get(0);
        } else {
            JSONArray geonames = this.callNearestService(position);
            if (geonames != null && !geonames.isEmpty() && (p = this.jsonToPlacemark((JSONObject)geonames.get(0))) != null) {
                ArrayList<Placemark> placemarks = new ArrayList<Placemark>();
                placemarks.add(p);
                this.cachePlacemarks(position, 0.0, placemarks);
            }
        }
        return p;
    }

    @Override
    public List<Placemark> getPlacemarksNear(Position position, double radius) throws IOException, ParseException {
        List<Object> placemarks;
        Util.Triple<Position, Double, List<Placemark>> cachedPlacemarks = this.checkCache(position);
        double limitedRadius = Math.min(radius, 300.0);
        int radiusInt = (int)limitedRadius;
        int xKmRadius = radiusInt / 5;
        int maxRows = (int)Math.min(15.0 * Math.pow(2.0, xKmRadius), 500.0);
        if (cachedPlacemarks != null && (Double)cachedPlacemarks.getB() >= limitedRadius) {
            placemarks = ((List)cachedPlacemarks.getC()).size() > maxRows ? ((List)cachedPlacemarks.getC()).subList(0, maxRows) : new ArrayList((Collection)cachedPlacemarks.getC());
        } else {
            Position searchPosition = null;
            if (cachedPlacemarks != null) {
                searchPosition = (Position)cachedPlacemarks.getA();
                double distance = position.getDistance(searchPosition).getKilometers();
                limitedRadius = Math.min(300.0, limitedRadius + distance);
            } else {
                searchPosition = position;
            }
            JSONArray geonames = this.callNearbyService(searchPosition, limitedRadius, maxRows);
            if (geonames != null) {
                Iterator iterator = geonames.iterator();
                if (iterator.hasNext()) {
                    placemarks = new ArrayList();
                    while (iterator.hasNext()) {
                        JSONObject object = (JSONObject)iterator.next();
                        Placemark place = this.jsonToPlacemark(object);
                        if (place == null) continue;
                        placemarks.add(this.jsonToPlacemark(object));
                    }
                    if (cachedPlacemarks == null) {
                        this.cachePlacemarks(searchPosition, limitedRadius, placemarks);
                    } else {
                        this.updateCachedPlacemarks(searchPosition, limitedRadius, placemarks);
                    }
                } else {
                    placemarks = null;
                }
            } else {
                placemarks = null;
            }
        }
        return placemarks;
    }

    @Override
    public Placemark getPlacemarkLast(Position position, double radius, Comparator<Placemark> comp) throws IOException, ParseException {
        List<Placemark> placemarks = this.getPlacemarksNearSorted(position, radius, comp);
        return placemarks == null ? null : placemarks.get(placemarks.size() - 1);
    }

    @Override
    public Placemark getPlacemarkFirst(Position position, double radius, Comparator<Placemark> comp) throws IOException, ParseException {
        List<Placemark> placemarks = this.getPlacemarksNearSorted(position, radius, comp);
        return placemarks == null ? null : placemarks.get(0);
    }

    @Override
    public Placemark getPlacemark(String name, Comparator<Placemark> comp) throws IOException, ParseException {
        StringBuilder url = new StringBuilder(SEARCH_BY_NAME_SERVICE);
        url.append("name=" + URLEncoder.encode(name, "UTF-8"));
        JSONArray geonames = this.submitGeonamesRequestForJSONArrayResult(url);
        return geonames.stream().map(o -> this.jsonToPlacemark((JSONObject)o)).sorted(comp).findFirst().orElse(null);
    }

    private List<Placemark> getPlacemarksNearSorted(Position position, double radius, Comparator<Placemark> comp) throws IOException, ParseException {
        List<Placemark> placemarks = this.getPlacemarksNear(position, radius);
        if (placemarks != null) {
            Collections.sort(placemarks, comp);
        }
        return placemarks;
    }

    private Placemark jsonToPlacemark(JSONObject json) {
        String name = (String)json.get((Object)"toponymName");
        String countryCode = (String)json.get((Object)"countryCode");
        Double latDeg = null;
        Object jsonLat = json.get((Object)"lat");
        if (jsonLat instanceof String) {
            latDeg = Double.valueOf((String)jsonLat);
        } else if (jsonLat instanceof Number) {
            latDeg = ((Number)jsonLat).doubleValue();
        }
        Double lngDeg = null;
        Object jsonLng = json.get((Object)"lng");
        if (jsonLng instanceof String) {
            lngDeg = Double.valueOf((String)jsonLng);
        } else if (jsonLng instanceof Number) {
            lngDeg = ((Number)jsonLng).doubleValue();
        }
        DegreePosition position = new DegreePosition(latDeg.doubleValue(), lngDeg.doubleValue());
        long population = (Long)json.get((Object)"population");
        if (name != null && lngDeg != null && latDeg != null) {
            return new PlacemarkImpl(name, countryCode, (Position)position, population);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePlacemarks(Position position, Double radius, List<Placemark> placemarks) {
        Collections.sort(placemarks, new Placemark.ByDistance(position));
        if (position != null) {
            QuadTree<Util.Triple<Position, Double, List<Placemark>>> quadTree = this.cache;
            synchronized (quadTree) {
                this.cache.put(position, (Object)new Util.Triple((Object)position, (Object)radius, placemarks));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCachedPlacemarks(Position cachedPoint, Double newRadius, List<Placemark> newPlacemarks) {
        if (cachedPoint != null) {
            QuadTree<Util.Triple<Position, Double, List<Placemark>>> quadTree = this.cache;
            synchronized (quadTree) {
                this.cache.put(cachedPoint, (Object)new Util.Triple((Object)cachedPoint, (Object)newRadius, newPlacemarks));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Util.Triple<Position, Double, List<Placemark>> checkCache(Position position) {
        QuadTree<Util.Triple<Position, Double, List<Placemark>>> quadTree = this.cache;
        synchronized (quadTree) {
            return (Util.Triple)this.cache.get(position, 0.04499640028797696);
        }
    }

    private JSONArray callNearestService(Position position) throws MalformedURLException, IOException, ParseException {
        StringBuilder url = this.generateRequestUrlNearbyPlaceService(position);
        JSONArray geonames = this.submitGeonamesRequestForJSONArrayResult(url);
        return geonames;
    }

    private URLConnection addUsernameParameterAndConnect(StringBuilder url) throws MalformedURLException, IOException {
        url.append("&username=");
        url.append(this.getGeonamesUser());
        return HttpUrlConnectionHelper.redirectConnection((URL)new URL(url.toString()), (Duration)Duration.ONE_MINUTE, c -> c.setRequestProperty("User-Agent", ""));
    }

    private JSONArray callNearbyService(Position position, double radius, int maxRows) throws MalformedURLException, IOException, ParseException {
        StringBuilder url = this.generateRequestUrlNearbyPlaceService(position, radius, maxRows);
        JSONArray geonames = this.submitGeonamesRequestForJSONArrayResult(url);
        return geonames;
    }

    private StringBuilder generateRequestUrlNearbyPlaceService(Position position) {
        StringBuilder url = new StringBuilder(NEARBY_PLACE_SERVICE);
        url.append("lat=" + Double.toString(position.getLatDeg()));
        url.append("&lng=" + Double.toString(position.getLngDeg()));
        return url;
    }

    private StringBuilder generateRequestUrlNearbyPlaceService(Position position, double radius, int maxRows) {
        StringBuilder url = this.generateRequestUrlNearbyPlaceService(position);
        url.append("&radius=" + Double.toString(radius));
        url.append("&maxRows=" + Integer.toString(maxRows));
        return url;
    }

    private JSONArray submitGeonamesRequestForJSONArrayResult(StringBuilder url) throws MalformedURLException, IOException, ParseException {
        JSONObject obj = this.submitGeonamesRequestForJSONObjectResult(url);
        JSONArray geonames = (JSONArray)obj.get((Object)"geonames");
        if (geonames == null) {
            logger.log(Level.WARNING, "Returning null value for geonames object: " + obj.toJSONString());
        }
        return geonames;
    }

    private String getGeonamesUser() {
        return this.usernames[new Random().nextInt(this.usernames.length)];
    }
}

