/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.windfield.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WindFieldTrackedRaceImpl
extends WindFieldGeneratorImpl
implements WindFieldGenerator {
    private static final long serialVersionUID = -7005970781594631010L;
    private static final double EPSILON_DISTANCE_METER = 20.0;
    private static final long EPSILON_TIME_MILLIS = 5000L;
    private TrackedRace race;
    private final ConcurrentMap<TimedPosition, Wind> cache;
    private TimePoint startSimulationTime = null;

    public WindFieldTrackedRaceImpl(TrackedRace race) {
        super(null, null);
        this.race = race;
        this.cache = new ConcurrentHashMap<TimedPosition, Wind>();
        this.startSimulationTime = race.isLive(MillisecondsTimePoint.now()) ? MillisecondsTimePoint.now() : null;
    }

    @Override
    public Wind getWind(TimedPosition timedPosition) {
        DegreePosition qPosition;
        Position pos = timedPosition.getPosition();
        double epsLat = new MeterDistance(20.0).getCentralAngleDeg();
        double qLat = Math.floor(pos.getLatDeg() / epsLat) * epsLat;
        double epsLng = epsLat / Math.cos(qLat * Math.PI / 180.0);
        double qLng = Math.floor(pos.getLngDeg() / epsLng) * epsLng;
        TimePoint time = timedPosition.getTimePoint();
        if (this.startSimulationTime != null && time.after(this.startSimulationTime)) {
            time = this.startSimulationTime;
        }
        long epsTime = 5000L;
        MillisecondsTimePoint qTime = new MillisecondsTimePoint((long)(Math.floor(time.asMillis() / epsTime) * (double)epsTime));
        TimedPositionImpl qTimedPosition = new TimedPositionImpl((TimePoint)qTime, (Position)(qPosition = new DegreePosition(qLat, qLng)));
        Wind wind = (Wind)this.cache.get(qTimedPosition);
        if (wind == null) {
            wind = this.race.getWind((Position)qPosition, (TimePoint)qTime);
            this.cache.put(qTimedPosition, wind);
        }
        return wind;
    }
}

