/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.simulator.impl.PolarDiagramBase;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class PolarDiagramCSV
extends PolarDiagramBase {
    private static final long serialVersionUID = -9219705955440602679L;

    public PolarDiagramCSV(String inputFile) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream csvFile = cl.getResourceAsStream(inputFile);
        InputStreamReader isr = new InputStreamReader(csvFile, Charset.forName("UTF-8"));
        BufferedReader bfr = new BufferedReader(isr);
        ArrayList<KnotSpeedImpl> windSpeeds = new ArrayList<KnotSpeedImpl>();
        ArrayList<DegreeBearingImpl> beatAngles = new ArrayList<DegreeBearingImpl>();
        ArrayList<KnotSpeedImpl> beatSpeed = new ArrayList<KnotSpeedImpl>();
        HashMap speeds = new HashMap();
        ArrayList<KnotSpeedImpl> jibeSpeed = new ArrayList<KnotSpeedImpl>();
        ArrayList<DegreeBearingImpl> jibeAngles = new ArrayList<DegreeBearingImpl>();
        String line = "";
        line = bfr.readLine();
        if (line != null) {
            this.boatClass = DomainFactory.INSTANCE.getOrCreateBoatClass(line, true);
        }
        String[] elements = null;
        block14: while (line != null) {
            line = bfr.readLine();
            if (line == null) break;
            elements = line.split(",");
            elements[0] = elements[0].replace(" ", "");
            elements[0] = elements[0].toLowerCase();
            switch (elements[0]) {
                case "windspeed": {
                    int i = 1;
                    while (i < elements.length) {
                        windSpeeds.add(new KnotSpeedImpl(Double.valueOf(elements[i]).doubleValue()));
                        ++i;
                    }
                    continue block14;
                }
                case "beatangles": {
                    int i = 1;
                    while (i < elements.length) {
                        beatAngles.add(new DegreeBearingImpl(Double.valueOf(elements[i]).doubleValue()));
                        ++i;
                    }
                    continue block14;
                }
                case "beatsog": {
                    int i = 1;
                    while (i < elements.length) {
                        beatSpeed.add(new KnotSpeedImpl(Double.valueOf(elements[i]).doubleValue()));
                        ++i;
                    }
                    continue block14;
                }
                case "jibesog": {
                    int i = 1;
                    while (i < elements.length) {
                        jibeSpeed.add(new KnotSpeedImpl(Double.valueOf(elements[i]).doubleValue()));
                        ++i;
                    }
                    continue block14;
                }
                case "jibeangles": {
                    int i = 1;
                    while (i < elements.length) {
                        jibeAngles.add(new DegreeBearingImpl(Double.valueOf(elements[i]).doubleValue()));
                        ++i;
                    }
                    continue block14;
                }
                default: {
                    ArrayList<Object> sp = new ArrayList<Object>();
                    int i = 1;
                    while (i < elements.length) {
                        if (elements[i].length() > 0) {
                            sp.add(new KnotSpeedImpl(Double.valueOf(elements[i]).doubleValue()));
                        } else {
                            sp.add(Speed.NULL);
                        }
                        ++i;
                    }
                    speeds.put(new DegreeBearingImpl(Double.valueOf(elements[0]).doubleValue()), sp);
                }
            }
        }
        bfr.close();
        isr.close();
        TreeMap<Speed, NavigableMap<Bearing, Speed>> mapSpeedTable = new TreeMap<Speed, NavigableMap<Bearing, Speed>>();
        TreeMap<Speed, Bearing> mapBeatAngles = new TreeMap<Speed, Bearing>();
        TreeMap<Speed, Bearing> mapJibeAngles = new TreeMap<Speed, Bearing>();
        TreeMap<Speed, Speed> mapBeatSOG = new TreeMap<Speed, Speed>();
        TreeMap<Speed, Speed> mapJibeSOG = new TreeMap<Speed, Speed>();
        Speed windSpeed = null;
        Speed boatSpeed = null;
        TreeMap<Bearing, Speed> speedTableLine = null;
        int index = 0;
        while (index < windSpeeds.size()) {
            windSpeed = (Speed)windSpeeds.get(index);
            speedTableLine = new TreeMap<Bearing, Speed>(bearingComparator);
            for (Map.Entry entry : speeds.entrySet()) {
                if (index >= ((List)entry.getValue()).size() || (boatSpeed = (Speed)((List)entry.getValue()).get(index)) == Speed.NULL) continue;
                speedTableLine.put((Bearing)entry.getKey(), boatSpeed);
            }
            mapSpeedTable.put(windSpeed, speedTableLine);
            mapBeatAngles.put(windSpeed, (Bearing)beatAngles.get(index));
            mapJibeAngles.put(windSpeed, (Bearing)jibeAngles.get(index));
            mapBeatSOG.put(windSpeed, (Speed)beatSpeed.get(index));
            mapJibeSOG.put(windSpeed, (Speed)jibeSpeed.get(index));
            ++index;
        }
        this.speedTable = mapSpeedTable;
        this.beatAngles = mapBeatAngles;
        this.jibeAngles = mapJibeAngles;
        this.beatSOG = mapBeatSOG;
        this.jibeSOG = mapJibeSOG;
        for (Speed s : this.speedTable.keySet()) {
            if (this.beatAngles.containsKey(s) && !((NavigableMap)this.speedTable.get(s)).containsKey(this.beatAngles.get(s))) {
                ((NavigableMap)this.speedTable.get(s)).put((Bearing)this.beatAngles.get(s), (Speed)this.beatSOG.get(s));
            }
            if (!this.jibeAngles.containsKey(s) || ((NavigableMap)this.speedTable.get(s)).containsKey(this.jibeAngles.get(s))) continue;
            ((NavigableMap)this.speedTable.get(s)).put((Bearing)this.jibeAngles.get(s), (Speed)this.jibeSOG.get(s));
        }
    }
}

