/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tractracadapter.TracTracAdapterFactory;
import com.sap.sailing.domain.tractracadapter.impl.TracTracAdapterFactoryImpl;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class PathGeneratorTracTrac
extends PathGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger("com.sap.sailing.simulator");
    private TracTracAdapterFactory tracTracAdapterFactory;
    private RaceHandle raceHandle = null;
    private URL raceURL = null;
    private URI liveURI = null;
    private URI storedURI = null;
    private double windScale = 0.0;
    private LinkedList<TimedPositionWithSpeed> raceCourse = null;
    private int legIndex = 0;
    private int competitorIndex = 0;

    public PathGeneratorTracTrac(SimulationParameters parameters) {
        this.parameters = parameters;
        this.tracTracAdapterFactory = new TracTracAdapterFactoryImpl();
        this.legIndex = 0;
        this.competitorIndex = 0;
    }

    protected TracTracAdapterFactory getTracTracAdapterFactory() {
        return this.tracTracAdapterFactory;
    }

    private void intializeRaceHandle() {
        if (this.raceHandle != null) {
            return;
        }
        LOGGER.info("Calling service.addTracTracRace");
        try {
            this.raceHandle = null;
        }
        catch (Exception error) {
            LOGGER.severe(error.getMessage());
        }
    }

    public void setSelectionParameters(int legIndex, int competitorIndex) {
        this.legIndex = legIndex;
        this.competitorIndex = competitorIndex;
    }

    public void setEvaluationParameters(String raceURLString, String liveURIString, String storedURIString, double windScale) {
        try {
            this.raceURL = new URL(raceURLString);
        }
        catch (MalformedURLException error) {
            LOGGER.severe("MalformedURLException when constructing the raceURL " + error.getMessage());
        }
        try {
            this.liveURI = liveURIString == null ? null : new URI(liveURIString);
        }
        catch (URISyntaxException error) {
            LOGGER.severe("URISyntaxException when constructing the liveURI " + error.getMessage());
        }
        try {
            this.storedURI = storedURIString == null ? null : new URI(storedURIString);
        }
        catch (URISyntaxException error) {
            LOGGER.severe("URISyntaxException when constructing the storedURI " + error.getMessage());
        }
        this.windScale = windScale;
    }

    public Path getRaceCourse() {
        return this.raceCourse == null ? null : new PathImpl(this.raceCourse, null, this.algorithmTimedOut);
    }

    public List<String> getLegsNames() {
        this.intializeRaceHandle();
        ArrayList<String> result = new ArrayList<String>();
        RaceDefinition race = this.raceHandle.getRace();
        for (Leg leg : race.getCourse().getLegs()) {
            result.add(leg.toString());
        }
        return result;
    }

    @Override
    public Path getPath() {
        this.algorithmStartTime = MillisecondsTimePoint.now();
        this.intializeRaceHandle();
        RaceDefinition raceDef = this.raceHandle.getRace();
        Regatta regatta = this.raceHandle.getRegatta();
        Object trackedRace = null;
        trackedRace.waitUntilNotLoading();
        Iterator competitors = raceDef.getCompetitors().iterator();
        Competitor competitor = null;
        int index = 0;
        while (index <= this.competitorIndex) {
            competitor = (Competitor)competitors.next();
            ++index;
        }
        Leg leg = (Leg)raceDef.getCourse().getLegs().get(this.legIndex);
        TimePoint startTime = trackedRace.getMarkPassing(competitor, leg.getFrom()).getTimePoint();
        TimePoint endTime = trackedRace.getMarkPassing(competitor, leg.getTo()).getTimePoint();
        GPSFixTrack track = trackedRace.getTrack(competitor);
        track.lockForRead();
        try {
            Iterator it = track.getFixesIterator(startTime, true);
            LinkedList<TimedPositionWithSpeed> path = new LinkedList<TimedPositionWithSpeed>();
            while (it.hasNext()) {
                TimePoint timePoint;
                GPSFixMoving gpsFix = (GPSFixMoving)it.next();
                if (gpsFix.getTimePoint().after(endTime)) break;
                Position position = gpsFix.getPosition();
                Wind gpsWind = trackedRace.getWind(position, timePoint = gpsFix.getTimePoint());
                if (gpsWind.getKnots() == 1.0) {
                    path.addLast(new TimedPositionWithSpeedImpl(timePoint, position, PathGeneratorTracTrac.scale((SpeedWithBearing)gpsWind, this.windScale)));
                    continue;
                }
                path.addLast(new TimedPositionWithSpeedImpl(timePoint, position, (SpeedWithBearing)gpsWind));
            }
            PathImpl pathImpl = new PathImpl(path, null, this.algorithmTimedOut);
            return pathImpl;
        }
        finally {
            track.unlockAfterRead();
        }
    }

    public Path getPathPolyline(Distance maxDistance) {
        this.intializeRaceHandle();
        RaceDefinition raceDef = this.raceHandle.getRace();
        Regatta regatta = this.raceHandle.getRegatta();
        Object trackedRace = null;
        Iterator competitors = raceDef.getCompetitors().iterator();
        Competitor competitor = null;
        int index = 0;
        while (index <= this.competitorIndex) {
            competitor = (Competitor)competitors.next();
            ++index;
        }
        LinkedList<TimedPositionWithSpeed> path = new LinkedList<TimedPositionWithSpeed>();
        this.raceCourse = new LinkedList();
        Leg leg = (Leg)raceDef.getCourse().getLegs().get(this.legIndex);
        TimePoint startTime = trackedRace.getMarkPassing(competitor, leg.getFrom()).getTimePoint();
        Position startPosition = trackedRace.getApproximatePosition(leg.getFrom(), startTime);
        Wind startWind = trackedRace.getWind(startPosition, startTime);
        this.raceCourse.addLast(new TimedPositionWithSpeedImpl(startTime, startPosition, (SpeedWithBearing)startWind));
        TimePoint endTime = trackedRace.getMarkPassing(competitor, leg.getTo()).getTimePoint();
        Position endPosition = trackedRace.getApproximatePosition(leg.getTo(), endTime);
        Wind endWind = trackedRace.getWind(endPosition, endTime);
        this.raceCourse.addLast(new TimedPositionWithSpeedImpl(endTime, endPosition, (SpeedWithBearing)endWind));
        Iterable gpsFixes = trackedRace.approximate(competitor, maxDistance, startTime, endTime);
        for (GPSFixMoving gpsFix : gpsFixes) {
            TimePoint timePoint;
            if (gpsFix.getTimePoint().after(endTime)) break;
            Position position = gpsFix.getPosition();
            Wind gpsWind = trackedRace.getWind(position, timePoint = gpsFix.getTimePoint());
            if (gpsWind.getKnots() == 1.0) {
                path.addLast(new TimedPositionWithSpeedImpl(timePoint, position, PathGeneratorTracTrac.scale((SpeedWithBearing)gpsWind, this.windScale)));
                continue;
            }
            path.addLast(new TimedPositionWithSpeedImpl(timePoint, position, (SpeedWithBearing)gpsWind));
        }
        return new PathImpl(path, null, this.algorithmTimedOut);
    }

    public static SpeedWithBearing scale(SpeedWithBearing speed, double scale) {
        return new KnotSpeedWithBearingImpl(speed.getKnots() * scale, (Bearing)new DegreeBearingImpl(speed.getBearing().getDegrees()));
    }

    public List<String> getComeptitorsNames() {
        this.intializeRaceHandle();
        ArrayList<String> result = new ArrayList<String>();
        RaceDefinition race = this.raceHandle.getRace();
        for (Map.Entry competitorAndBoatEntry : race.getCompetitorsAndTheirBoats().entrySet()) {
            result.add(String.valueOf(((Competitor)competitorAndBoatEntry.getKey()).getName()) + ", " + ((Boat)competitorAndBoatEntry.getValue()).getName());
        }
        return result;
    }
}

