/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.BoatDirection;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PointOfSail;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.LinkedList;

public class PathGenerator1Turner360
extends PathGeneratorBase {
    private boolean leftSide;
    private result1Turn result;
    private Position evalStartPoint;
    private Position evalEndPoint;
    private TimePoint evalStartTime;
    private long evalTimeStep;
    private int evalStepMax;
    private double evalTolerance;

    public PathGenerator1Turner360(SimulationParameters params) {
        this.parameters = params;
    }

    public void setEvaluationParameters(boolean leftSideVal, Position startPoint, Position endPoint, TimePoint startTime, long timeStep, int stepMax, double tolerance, boolean upwindLeg) {
        this.leftSide = leftSideVal;
        this.evalStartPoint = startPoint;
        this.evalEndPoint = endPoint;
        this.evalStartTime = startTime;
        this.evalTimeStep = timeStep;
        this.evalStepMax = stepMax;
        this.evalTolerance = tolerance;
    }

    public int getMiddle() {
        return this.result.middle;
    }

    @Override
    public Path getPath() {
        this.algorithmStartTime = MillisecondsTimePoint.now();
        WindFieldGenerator windField = this.parameters.getWindField();
        PolarDiagram polarDiagram = this.parameters.getBoatPolarDiagram();
        Position posStart = this.evalStartPoint == null ? this.parameters.getCourse().get(0) : this.evalStartPoint;
        Position posEnd = this.evalEndPoint == null ? this.parameters.getCourse().get(1) : this.evalEndPoint;
        TimePoint startTime = this.evalStartTime == null ? windField.getStartTime() : this.evalStartTime;
        long turnloss = polarDiagram.getTurnLoss();
        Distance courseLength = posStart.getDistance(posEnd);
        Position currentPosition = posStart;
        TimePoint currentTime = startTime;
        double reachingTolerance = this.evalTolerance == 0.0 ? 0.03 : this.evalTolerance;
        int stepMax = this.evalStepMax == 0 ? 800 : this.evalStepMax;
        long timeStep = this.evalTimeStep == 0L ? windField.getTimeStep().asMillis() / 3L : this.evalTimeStep;
        double minimumDistance = courseLength.getMeters();
        LinkedList<TimedPositionWithSpeedImpl> path = null;
        LinkedList<TimedPositionWithSpeedImpl> allminpath = null;
        TimePoint minimumTime = startTime.plus(86400000L);
        int step = 0;
        while (step < stepMax) {
            double newDistance;
            MillisecondsTimePoint nextTime;
            Bearing direction;
            currentPosition = posStart;
            currentTime = startTime;
            boolean targetFound = false;
            boolean skipRemainingSteps = false;
            minimumDistance = courseLength.getMeters();
            path = new LinkedList<TimedPositionWithSpeedImpl>();
            path.addLast(new TimedPositionWithSpeedImpl(currentTime, currentPosition, null));
            if (this.isTimedOut()) break;
            int stepLeft = 0;
            PointOfSail prevPointOfSail = PointOfSail.TACKING;
            while (!(stepLeft >= step || targetFound || this.isTimedOut() || skipRemainingSteps)) {
                Bearing bearTarget = currentPosition.getBearingGreatCircle(posEnd);
                Wind currentWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
                polarDiagram.setWind((SpeedWithBearing)currentWind);
                Util.Pair<PointOfSail, BoatDirection> pointOfSailAndReachingSide = polarDiagram.getPointOfSail(bearTarget);
                PointOfSail pointOfSail = (PointOfSail)((Object)pointOfSailAndReachingSide.getA());
                BoatDirection reachingSide = (BoatDirection)((Object)pointOfSailAndReachingSide.getB());
                if (reachingSide == (this.leftSide ? BoatDirection.REACH_RIGHT : BoatDirection.REACH_LEFT)) {
                    pointOfSail = prevPointOfSail;
                }
                if (pointOfSail == PointOfSail.TACKING || pointOfSail == PointOfSail.JIBING || reachingSide == (this.leftSide ? BoatDirection.REACH_LEFT : BoatDirection.REACH_RIGHT)) {
                    Bearing nextBearTarget;
                    Util.Pair<PointOfSail, BoatDirection> nextPointOfSailAndReachingSide;
                    PointOfSail nextPointOfSail;
                    Bearing layline;
                    if (pointOfSail == PointOfSail.TACKING) {
                        if (this.leftSide) {
                            direction = polarDiagram.optimalDirectionsUpwind()[0];
                            layline = polarDiagram.optimalDirectionsUpwind()[1].reverse();
                        } else {
                            direction = polarDiagram.optimalDirectionsUpwind()[1];
                            layline = polarDiagram.optimalDirectionsUpwind()[0].reverse();
                        }
                        prevPointOfSail = pointOfSail;
                    } else if (pointOfSail == PointOfSail.JIBING) {
                        if (this.leftSide) {
                            direction = polarDiagram.optimalDirectionsDownwind()[1];
                            layline = polarDiagram.optimalDirectionsDownwind()[0].reverse();
                        } else {
                            direction = polarDiagram.optimalDirectionsDownwind()[0];
                            layline = polarDiagram.optimalDirectionsDownwind()[1].reverse();
                        }
                        prevPointOfSail = pointOfSail;
                    } else {
                        direction = bearTarget;
                        layline = null;
                    }
                    SpeedWithBearing currSpeed = pointOfSail != PointOfSail.REACHING || !polarDiagram.hasCurrent() ? polarDiagram.getSpeedAtBearing(direction) : polarDiagram.getSpeedAtBearingOverGround(direction);
                    nextTime = new MillisecondsTimePoint(currentTime.asMillis() + timeStep);
                    Position nextPosition = currSpeed.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                    if (layline != null && (nextPointOfSail = (PointOfSail)((Object)(nextPointOfSailAndReachingSide = polarDiagram.getPointOfSail(nextBearTarget = nextPosition.getBearingGreatCircle(posEnd))).getA())) != pointOfSail) {
                        Position tmpPosition = nextPosition.projectToLineThrough(posEnd, layline);
                        long scaledTimeStep = Math.round((double)timeStep * currentPosition.getDistance(tmpPosition).getMeters() / currentPosition.getDistance(nextPosition).getMeters());
                        nextTime = new MillisecondsTimePoint(currentTime.asMillis() + scaledTimeStep);
                        nextPosition = currSpeed.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                    }
                    if ((newDistance = nextPosition.getDistance(posEnd).getMeters()) < minimumDistance) {
                        minimumDistance = newDistance;
                    }
                    path.addLast(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextPosition, (SpeedWithBearing)currentWind));
                    currentPosition = nextPosition;
                    currentTime = nextTime;
                }
                if (currentPosition.getDistance(posEnd).getMeters() < reachingTolerance * courseLength.getMeters() && posStart.getDistance(currentPosition).getMeters() > posStart.getDistance(posEnd).getMeters()) {
                    targetFound = true;
                }
                if (targetFound && currentTime.before(minimumTime)) {
                    minimumTime = currentTime;
                    allminpath = path;
                }
                if (posStart.getDistance(currentPosition).getMeters() > 1.1 * posStart.getDistance(posEnd).getMeters()) {
                    skipRemainingSteps = true;
                }
                ++stepLeft;
            }
            if (step > 0) {
                currentTime = new MillisecondsTimePoint(currentTime.asMillis() + turnloss);
            }
            int stepRight = 0;
            while (!(stepRight >= stepMax - step || targetFound || this.isTimedOut() || skipRemainingSteps)) {
                Bearing bearTarget = currentPosition.getBearingGreatCircle(posEnd);
                Wind currentWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
                polarDiagram.setWind((SpeedWithBearing)currentWind);
                Util.Pair<PointOfSail, BoatDirection> pointOfSailAndReachingSide = polarDiagram.getPointOfSail(bearTarget);
                PointOfSail pointOfSail = (PointOfSail)((Object)pointOfSailAndReachingSide.getA());
                BoatDirection reachingSide = (BoatDirection)((Object)pointOfSailAndReachingSide.getB());
                if (pointOfSail == PointOfSail.TACKING || pointOfSail == PointOfSail.JIBING || reachingSide == (this.leftSide ? BoatDirection.REACH_RIGHT : BoatDirection.REACH_LEFT)) {
                    direction = pointOfSail == PointOfSail.TACKING ? (this.leftSide ? polarDiagram.optimalDirectionsUpwind()[1] : polarDiagram.optimalDirectionsUpwind()[0]) : (pointOfSail == PointOfSail.JIBING ? (this.leftSide ? polarDiagram.optimalDirectionsDownwind()[0] : polarDiagram.optimalDirectionsDownwind()[1]) : bearTarget);
                    SpeedWithBearing currSpeed = pointOfSail != PointOfSail.REACHING || !polarDiagram.hasCurrent() ? polarDiagram.getSpeedAtBearing(direction) : polarDiagram.getSpeedAtBearingOverGround(direction);
                    nextTime = new MillisecondsTimePoint(currentTime.asMillis() + timeStep);
                    Position nextPosition = currSpeed.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                    newDistance = nextPosition.getDistance(posEnd).getMeters();
                    if (newDistance < minimumDistance) {
                        minimumDistance = newDistance;
                    }
                    path.addLast(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextPosition, (SpeedWithBearing)currentWind));
                    currentPosition = nextPosition;
                    currentTime = nextTime;
                }
                if (currentPosition.getDistance(posEnd).getMeters() < reachingTolerance * courseLength.getMeters() && posStart.getDistance(currentPosition).getMeters() > posStart.getDistance(posEnd).getMeters()) {
                    targetFound = true;
                }
                if (targetFound && currentTime.before(minimumTime)) {
                    minimumTime = currentTime;
                    allminpath = new LinkedList(path);
                }
                if (posStart.getDistance(currentPosition).getMeters() > 1.1 * posStart.getDistance(posEnd).getMeters()) {
                    skipRemainingSteps = true;
                }
                ++stepRight;
            }
            ++step;
        }
        return new PathImpl(allminpath, windField, this.algorithmTimedOut);
    }

    class result1Turn {
        Path[] paths;
        char side;
        int middle;

        public result1Turn(Path[] p, char s, int n) {
            this.paths = p;
            this.side = s;
            this.middle = n;
        }
    }
}

