/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.simulator.Grid;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Map;

public class CurvedGrid
implements Grid {
    private static final long serialVersionUID = 3598121983120213464L;
    private Position rcStart;
    private Position rcEnd;
    private int vPoints;
    private int hPoints;
    private int borderY;
    private int borderX;
    private Position gridNorthWest;
    private Position gridSouthEast;
    private Position gridSouthWest;
    private Position gridNorthEast;
    private Bearing gridNorth;
    private Bearing gridSouth;
    private Bearing gridEast;
    private Bearing gridWest;
    private Distance gridWidth;
    private double xscale = 1.5;
    private Distance gridHeight;

    public CurvedGrid(Position p1, Position p2) {
        this.rcStart = p1;
        this.rcEnd = p2;
        this.gridNorth = p1.getBearingGreatCircle(p2);
        this.gridSouth = this.gridNorth.reverse();
        this.gridEast = this.gridNorth.add(relativeEast);
        this.gridWest = this.gridNorth.add(relativeWest);
        this.gridHeight = p1.getDistance(p2);
        this.gridWidth = this.gridHeight.scale(2.0);
        this.gridNorthWest = p2.translateGreatCircle(this.gridWest, this.gridHeight);
        this.gridNorthEast = p2.translateGreatCircle(this.gridEast, this.gridHeight);
        this.gridSouthWest = p1.translateGreatCircle(this.gridWest, this.gridHeight);
        this.gridSouthEast = p1.translateGreatCircle(this.gridEast, this.gridHeight);
    }

    @Override
    public Map<String, Position> getCorners() {
        HashMap<String, Position> map = new HashMap<String, Position>();
        map.put("NorthWest", this.gridNorthWest);
        map.put("SouthWest", this.gridSouthWest);
        map.put("SouthEast", this.gridSouthEast);
        map.put("NorthEast", this.gridNorthEast);
        return map;
    }

    @Override
    public boolean inBounds(Position p) {
        Position northProjection = p.projectToLineThrough(this.gridNorthWest, this.getEast());
        Position southProjection = p.projectToLineThrough(this.gridSouthWest, this.getEast());
        Position westProjection = p.projectToLineThrough(this.gridNorthWest, this.getNorth());
        Position eastProjection = p.projectToLineThrough(this.gridNorthEast, this.getNorth());
        Distance northSouth = northProjection.getDistance(southProjection);
        Distance eastWest = eastProjection.getDistance(westProjection);
        return northSouth.compareTo((Object)p.getDistance(northProjection)) >= 0 && northSouth.compareTo((Object)p.getDistance(southProjection)) >= 0 && eastWest.compareTo((Object)p.getDistance(eastProjection)) >= 0 && eastWest.compareTo((Object)p.getDistance(westProjection)) >= 0;
    }

    @Override
    public Position[][] generatePositions(int hPoints, int vPoints, int borderY, int borderX) {
        this.vPoints = vPoints;
        this.hPoints = hPoints;
        this.borderY = borderY;
        this.borderX = borderX;
        Distance vStep = this.gridHeight.scale(1.0 / (double)(vPoints - 1));
        Distance hStep = this.gridHeight.scale(this.xscale / (double)(hPoints - 1));
        Position[][] grid = new Position[vPoints + 2 * borderY][hPoints + 2 * borderX];
        int i = -borderY;
        while (i < vPoints + borderY) {
            Position pv = i == 0 ? this.rcStart : (i == vPoints - 1 ? this.rcEnd : this.rcStart.translateGreatCircle(this.gridNorth, vStep.scale((double)i)));
            int j = 0;
            while (j < (hPoints + 2 * borderX) / 2) {
                grid[i + borderY][j] = pv.translateGreatCircle(this.gridWest, hStep.scale((double)(hPoints + 2 * borderX - 1) / 2.0 - (double)j));
                ++j;
            }
            if ((hPoints + 2 * borderX) % 2 == 1) {
                grid[i + borderY][j] = pv;
                ++j;
            }
            while (j < hPoints + 2 * borderX) {
                grid[i + borderY][j] = pv.translateGreatCircle(this.gridEast, hStep.scale((double)j - (double)(hPoints + 2 * borderX - 1) / 2.0));
                ++j;
            }
            ++i;
        }
        return grid;
    }

    @Override
    public Util.Pair<Integer, Integer> getIndex(Position x) {
        double vFlt = 0.0;
        double hFlt = 0.0;
        if (!x.equals(this.rcStart)) {
            Position h = x.projectToLineThrough(this.rcStart, this.gridNorth);
            vFlt = (double)this.vPoints * this.rcStart.getDistance(h).getMeters() / this.gridHeight.getMeters();
            int sign = 1;
            if (Math.abs(h.getBearingGreatCircle(x).getDifferenceTo(this.gridWest).getDegrees()) < 90.0) {
                sign = -1;
            }
            hFlt = (double)(sign * (this.hPoints - 1)) * x.getDistance(h).getMeters() / this.gridHeight.getMeters() / this.xscale;
        }
        int vIdx = Math.min(Math.max(-this.borderY, (int)Math.round(vFlt) + this.borderY), this.vPoints - 1 + this.borderY);
        int hIdx = Math.min(Math.max(-this.borderX, (int)Math.round((double)(this.hPoints - 1) / 2.0 + hFlt)), this.hPoints - 1 + this.borderX);
        return new Util.Pair((Object)vIdx, (Object)hIdx);
    }

    @Override
    public int getResY() {
        return this.vPoints;
    }

    @Override
    public int getResX() {
        return this.hPoints;
    }

    @Override
    public int getBorderY() {
        return this.borderY;
    }

    @Override
    public int getBorderX() {
        return this.borderX;
    }

    @Override
    public Bearing getNorth() {
        return this.gridNorth;
    }

    @Override
    public Bearing getSouth() {
        return this.gridSouth;
    }

    @Override
    public Bearing getEast() {
        return this.gridEast;
    }

    @Override
    public Bearing getWest() {
        return this.gridWest;
    }

    @Override
    public Distance getWidth() {
        return this.gridWidth;
    }

    @Override
    public Distance getHeight() {
        return this.gridHeight;
    }
}

