/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.filestorage.impl;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sse.filestorage.FileStorageServicePropertyStore;
import com.sap.sse.mongodb.MongoDBService;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoFileStorageServicePropertyStoreImpl
implements FileStorageServicePropertyStore {
    private static final Logger logger = Logger.getLogger(MongoFileStorageServicePropertyStoreImpl.class.getName());
    public static final String PROPERTIES_COLLECTION_NAME = "FileStorageServiceProperties";
    public static final String ACTIVE_SERVICE_COLLECTION_NAME = "ActiveFileStorageService";
    private final MongoCollection<Document> propertiesCollection;
    private final MongoCollection<Document> activeServiceCollection;

    public MongoFileStorageServicePropertyStoreImpl(MongoDBService dbService) {
        this.propertiesCollection = dbService.getDB().getCollection(PROPERTIES_COLLECTION_NAME);
        Document index = new Document().append(FieldNames.SERVICE_NAME.name(), (Object)1).append(FieldNames.PROPERTY_NAME.name(), (Object)1);
        try {
            this.propertiesCollection.createIndex((Bson)index, new IndexOptions().name("svcpropnameunique").unique(true).background(false));
        }
        catch (Exception e) {
            logger.info("Problem creating index, probably due to index format change; dropping indexes and creating again...");
            this.propertiesCollection.dropIndexes();
            this.propertiesCollection.createIndex((Bson)index, new IndexOptions().name("svcpropnameunique").unique(true).background(false));
        }
        this.activeServiceCollection = dbService.getDB().getCollection(ACTIVE_SERVICE_COLLECTION_NAME);
    }

    @Override
    public Map<String, String> readAllProperties(String serviceName) {
        Document query = new Document(FieldNames.SERVICE_NAME.name(), (Object)serviceName);
        FindIterable cursor = this.propertiesCollection.find((Bson)query);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Document property : cursor) {
            String name = (String)property.get((Object)FieldNames.PROPERTY_NAME.name());
            String value = (String)property.get((Object)FieldNames.PROPERTY_VALUE.name());
            properties.put(name, value);
        }
        return properties;
    }

    @Override
    public void writeProperty(String serviceName, String propertyName, String propertyValue) {
        Document obj = new Document().append(FieldNames.SERVICE_NAME.name(), (Object)serviceName).append(FieldNames.PROPERTY_NAME.name(), (Object)propertyName).append(FieldNames.PROPERTY_VALUE.name(), (Object)propertyValue);
        Document query = new Document().append(FieldNames.SERVICE_NAME.name(), (Object)serviceName).append(FieldNames.PROPERTY_NAME.name(), (Object)propertyName);
        this.propertiesCollection.replaceOne((Bson)query, (Object)obj, new ReplaceOptions().upsert(true));
    }

    @Override
    public String readActiveServiceName() {
        Document obj = (Document)this.activeServiceCollection.find().first();
        if (obj == null) {
            return null;
        }
        return (String)obj.get((Object)FieldNames.SERVICE_NAME.name());
    }

    @Override
    public void writeActiveService(String serviceName) {
        Document obj = new Document(FieldNames.SERVICE_NAME.name(), (Object)serviceName);
        Document query = new Document();
        this.activeServiceCollection.replaceOne((Bson)query, (Object)obj, new ReplaceOptions().upsert(true));
    }

    private static enum FieldNames {
        SERVICE_NAME,
        PROPERTY_NAME,
        PROPERTY_VALUE;

    }
}

