/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.filestorage.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Util;
import com.sap.sse.filestorage.FileStorageService;
import com.sap.sse.filestorage.InvalidPropertiesException;
import com.sap.sse.filestorage.impl.BaseFileStorageServiceImpl;
import com.sap.sse.filestorage.impl.FileStorageServicePropertyImpl;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.osgi.framework.BundleContext;

public class LocalFileStorageServiceImpl
extends BaseFileStorageServiceImpl
implements FileStorageService {
    private static final long serialVersionUID = -8661781258137340835L;
    private static final String testFile = "Bundesliga2014_Regatta6_eventteaser.jpg";
    public static final String NAME = "Local Storage";
    private static final Logger logger = Logger.getLogger(LocalFileStorageServiceImpl.class.getName());
    private final FileStorageServicePropertyImpl baseURL = new FileStorageServicePropertyImpl("baseURL", true, false, "localBaseUrlDesc");
    private final FileStorageServicePropertyImpl localPath = new FileStorageServicePropertyImpl("localPath", true, false, "localLocalPathDesc");

    protected LocalFileStorageServiceImpl(BundleContext bundleContext) {
        super(NAME, "localDesc", bundleContext);
        this.addProperties(this.baseURL, this.localPath);
    }

    @Override
    public URI storeFile(InputStream is, String fileExtension, long lengthInBytes) throws IOException, UnauthorizedException {
        String fileName = LocalFileStorageServiceImpl.getKey(fileExtension);
        String pathToFile = String.valueOf(this.localPath.getValue()) + "/" + fileName;
        return (URI)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.FILE_STORAGE, new TypeRelativeObjectIdentifier(new String[]{pathToFile}), pathToFile, () -> {
            File outputFile = new File(pathToFile);
            logger.log(Level.FINE, "Storing file in " + outputFile.getAbsolutePath());
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            try {
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = is.read(bytes)) != -1) {
                    ((OutputStream)outputStream).write(bytes, 0, read);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                }
            }
            return this.getUri(fileName);
        });
    }

    private URI getUri(String pathToFile) {
        try {
            return new URI(String.valueOf(this.baseURL.getValue()) + "/" + pathToFile);
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "Could not create URI for uploaded file with path " + pathToFile, e);
            return null;
        }
    }

    @Override
    public void removeFile(URI uri) throws IOException, UnauthorizedException {
        String filePath = uri.getPath();
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
        String pathToFile = String.valueOf(this.localPath.getValue()) + "/" + fileName;
        File file = new File(pathToFile);
        if (!file.exists()) {
            throw new FileNotFoundException(uri.toString());
        }
        this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval(SecuredDomainType.FILE_STORAGE.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{pathToFile})), () -> {
            if (!file.delete()) {
                logger.warning("Could not delete file with path " + filePath);
                throw new IOException("Could not delete file with path " + filePath);
            }
        });
    }

    @Override
    public void internalSetProperty(String name, String value) {
        value = this.removeTrailingSlash(value);
        super.internalSetProperty(name, value);
    }

    @Override
    public void testProperties() throws InvalidPropertiesException, IOException {
        InputStream downloadStream;
        URI testFileURI;
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(testFile);
            long length = stream.available();
            testFileURI = this.storeFile(stream, ".test", length);
        }
        catch (IOException e) {
            throw new InvalidPropertiesException("Could not write test file", new Util.Pair((Object)this.localPath, (Object)"incorrect path or not writeable"));
        }
        try {
            downloadStream = testFileURI.toURL().openStream();
        }
        catch (Exception e) {
            throw new InvalidPropertiesException("Could not open stream to " + testFileURI, new Util.Pair((Object)this.baseURL, (Object)"a test file uploaded to localpath can't be found on baseUrl"));
        }
        InputStream originalInput = this.getClass().getClassLoader().getResourceAsStream(testFile);
        try {
            try {
                IOUtils.contentEquals((InputStream)downloadStream, (InputStream)originalInput);
            }
            catch (IOException e) {
                throw new InvalidPropertiesException("Could not compare original file with uploaded file", new Util.Pair((Object)this.baseURL, (Object)"unknown error"), new Util.Pair((Object)this.localPath, (Object)"unknown error"));
            }
        }
        finally {
            try {
                downloadStream.close();
                originalInput.close();
            }
            catch (IOException e) {
                logger.warning("Closing Streams failed.");
            }
        }
        this.removeFile(testFileURI);
    }

    private String removeTrailingSlash(String value) {
        if (value != null && value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    @Override
    public void doPermissionCheckForGetFile(URI uri) throws UnauthorizedException {
        String filePath = uri.getPath();
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
        String pathToFile = String.valueOf(this.localPath.getValue()) + "/" + fileName;
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.FILE_STORAGE.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, new TypeRelativeObjectIdentifier(new String[]{pathToFile})));
    }
}

