/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.filestorage.impl;

import com.sap.sse.common.IsManagedByCache;
import com.sap.sse.filestorage.FileStorageService;
import com.sap.sse.filestorage.FileStorageServiceProperty;
import com.sap.sse.filestorage.FileStorageServiceResolver;
import com.sap.sse.filestorage.impl.FileStorageI18n;
import com.sap.sse.filestorage.impl.FileStorageServicePropertyImpl;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.osgi.framework.BundleContext;

public abstract class BaseFileStorageServiceImpl
implements FileStorageService {
    private static final long serialVersionUID = 7787261863522200165L;
    private final String name;
    private final String descriptionKey;
    protected final Map<String, FileStorageServicePropertyImpl> propertiesByNameInInsertionOrder = new LinkedHashMap<String, FileStorageServicePropertyImpl>();
    private transient FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;

    protected BaseFileStorageServiceImpl(String name, String descriptionKey, BundleContext bundleContext) {
        this.name = name;
        this.descriptionKey = descriptionKey;
        this.securityServiceTracker = bundleContext == null ? null : FullyInitializedReplicableTracker.createAndOpen((BundleContext)bundleContext, SecurityService.class);
    }

    protected SecurityService getSecurityService() {
        try {
            return (SecurityService)this.securityServiceTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addProperties(FileStorageServicePropertyImpl ... properties) {
        FileStorageServicePropertyImpl[] fileStorageServicePropertyImplArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            FileStorageServicePropertyImpl p = fileStorageServicePropertyImplArray[n2];
            this.propertiesByNameInInsertionOrder.put(p.getName(), p);
            ++n2;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected static String getKey(String fileExtension) {
        String key = UUID.randomUUID().toString();
        key = String.valueOf(key) + fileExtension;
        return key;
    }

    @Override
    public String getDescription(Locale locale) {
        return FileStorageI18n.STRING_MESSAGES.get(locale, this.descriptionKey);
    }

    public IsManagedByCache<FileStorageServiceResolver> resolve(FileStorageServiceResolver domainFactory) {
        return domainFactory.getFileStorageService(this.getName());
    }

    @Override
    public FileStorageServiceProperty[] getProperties() {
        return this.propertiesByNameInInsertionOrder.values().toArray(new FileStorageServicePropertyImpl[0]);
    }

    @Override
    public void internalSetProperty(String name, String value) {
        if (!this.propertiesByNameInInsertionOrder.containsKey(name)) {
            throw new IllegalArgumentException("Property " + name + " does not exist");
        }
        this.propertiesByNameInInsertionOrder.get(name).setValue(value);
    }

    public String toString() {
        return this.getName();
    }
}

