/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.shared;

import com.google.gwt.user.client.Window;
import com.sap.sse.gwt.shared.ParseHttpParameterException;
import java.util.List;

public abstract class GwtHttpRequestUtils {
    private static final IntParser INT_PARSER = new IntParser();
    private static final LongParser LONG_PARSER = new LongParser();
    private static final FloatParser FLOAT_PARSER = new FloatParser();
    private static final DoubleParser DOUBLE_PARSER = new DoubleParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final StringParser STRING_PARSER = new StringParser();

    public static Integer getIntParameter(String name) throws ParseHttpParameterException {
        Integer result = Window.Location.getParameter((String)name) == null ? null : Integer.valueOf(GwtHttpRequestUtils.getRequiredIntParameter(name));
        return result;
    }

    public static int getIntParameter(String name, int defaultValue) {
        int result;
        if (Window.Location.getParameter((String)name) == null) {
            result = defaultValue;
        } else {
            try {
                result = GwtHttpRequestUtils.getRequiredIntParameter(name);
            }
            catch (ParseHttpParameterException ex) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static int[] getIntParameters(String name) {
        try {
            return GwtHttpRequestUtils.getRequiredIntParameters(name);
        }
        catch (ParseHttpParameterException ex) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(String name) throws ParseHttpParameterException {
        return INT_PARSER.parseInt(name, Window.Location.getParameter((String)name));
    }

    public static int[] getRequiredIntParameters(String name) throws ParseHttpParameterException {
        return INT_PARSER.parseInts(name, (List)Window.Location.getParameterMap().get(name));
    }

    public static Long getLongParameter(String name) throws ParseHttpParameterException {
        Long result = Window.Location.getParameter((String)name) == null ? null : Long.valueOf(GwtHttpRequestUtils.getRequiredLongParameter(name));
        return result;
    }

    public static Long getLongParameter(String name, Long defaultValue) {
        Long result;
        if (Window.Location.getParameter((String)name) == null) {
            result = defaultValue;
        } else {
            try {
                result = GwtHttpRequestUtils.getRequiredLongParameter(name);
            }
            catch (ParseHttpParameterException ex) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static long[] getLongParameters(String name) {
        long[] result;
        try {
            result = GwtHttpRequestUtils.getRequiredLongParameters(name);
        }
        catch (ParseHttpParameterException ex) {
            result = new long[]{};
        }
        return result;
    }

    public static long getRequiredLongParameter(String name) throws ParseHttpParameterException {
        return LONG_PARSER.parseLong(name, Window.Location.getParameter((String)name));
    }

    public static long[] getRequiredLongParameters(String name) throws ParseHttpParameterException {
        return LONG_PARSER.parseLongs(name, (List)Window.Location.getParameterMap().get(name));
    }

    public static Float getFloatParameter(String name) throws ParseHttpParameterException {
        Float result = Window.Location.getParameter((String)name) == null ? null : Float.valueOf(GwtHttpRequestUtils.getRequiredFloatParameter(name));
        return result;
    }

    public static float getFloatParameter(String name, float defaultValue) {
        float result;
        if (Window.Location.getParameter((String)name) == null) {
            result = defaultValue;
        } else {
            try {
                result = GwtHttpRequestUtils.getRequiredFloatParameter(name);
            }
            catch (ParseHttpParameterException ex) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static float[] getFloatParameters(String name) {
        float[] result;
        try {
            result = GwtHttpRequestUtils.getRequiredFloatParameters(name);
        }
        catch (ParseHttpParameterException ex) {
            result = new float[]{};
        }
        return result;
    }

    public static float getRequiredFloatParameter(String name) throws ParseHttpParameterException {
        return FLOAT_PARSER.parseFloat(name, Window.Location.getParameter((String)name));
    }

    public static float[] getRequiredFloatParameters(String name) throws ParseHttpParameterException {
        return FLOAT_PARSER.parseFloats(name, (List)Window.Location.getParameterMap().get(name));
    }

    public static Double getDoubleParameter(String name) throws ParseHttpParameterException {
        Double result = Window.Location.getParameter((String)name) == null ? null : Double.valueOf(GwtHttpRequestUtils.getRequiredDoubleParameter(name));
        return result;
    }

    public static double getDoubleParameter(String name, double defaultValue) {
        double result;
        if (Window.Location.getParameter((String)name) == null) {
            result = defaultValue;
        } else {
            try {
                result = GwtHttpRequestUtils.getRequiredDoubleParameter(name);
            }
            catch (ParseHttpParameterException ex) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static double[] getDoubleParameters(String name) {
        double[] result;
        try {
            result = GwtHttpRequestUtils.getRequiredDoubleParameters(name);
        }
        catch (ParseHttpParameterException ex) {
            result = new double[]{};
        }
        return result;
    }

    public static double getRequiredDoubleParameter(String name) throws ParseHttpParameterException {
        return DOUBLE_PARSER.parseDouble(name, Window.Location.getParameter((String)name));
    }

    public static double[] getRequiredDoubleParameters(String name) throws ParseHttpParameterException {
        return DOUBLE_PARSER.parseDoubles(name, (List)Window.Location.getParameterMap().get(name));
    }

    public static Boolean getBooleanParameter(String name) throws ParseHttpParameterException {
        Boolean result = Window.Location.getParameter((String)name) == null ? null : (GwtHttpRequestUtils.getRequiredBooleanParameter(name) ? Boolean.TRUE : Boolean.FALSE);
        return result;
    }

    public static boolean getBooleanParameter(String name, boolean defaultValue) {
        boolean result;
        if (Window.Location.getParameter((String)name) == null) {
            result = defaultValue;
        } else {
            try {
                result = GwtHttpRequestUtils.getRequiredBooleanParameter(name);
            }
            catch (ParseHttpParameterException ex) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static boolean[] getBooleanParameters(String name) {
        boolean[] result;
        try {
            result = GwtHttpRequestUtils.getRequiredBooleanParameters(name);
        }
        catch (ParseHttpParameterException ex) {
            result = new boolean[]{};
        }
        return result;
    }

    public static boolean getRequiredBooleanParameter(String name) throws ParseHttpParameterException {
        return BOOLEAN_PARSER.parseBoolean(name, Window.Location.getParameter((String)name));
    }

    public static boolean[] getRequiredBooleanParameters(String name) throws ParseHttpParameterException {
        return BOOLEAN_PARSER.parseBooleans(name, (List)Window.Location.getParameterMap().get(name));
    }

    public static String getStringParameter(String name) throws ParseHttpParameterException {
        String result = Window.Location.getParameter((String)name) == null ? null : GwtHttpRequestUtils.getRequiredStringParameter(name);
        return result;
    }

    public static String getStringParameter(String name, String defaultValue) {
        String val = Window.Location.getParameter((String)name);
        return val != null ? val : defaultValue;
    }

    public static String[] getStringParameters(String name) {
        String[] result;
        try {
            result = GwtHttpRequestUtils.getRequiredStringParameters(name);
        }
        catch (ParseHttpParameterException ex) {
            result = new String[]{};
        }
        return result;
    }

    public static String getRequiredStringParameter(String name) throws ParseHttpParameterException {
        return STRING_PARSER.validateRequiredString(name, Window.Location.getParameter((String)name));
    }

    public static String[] getRequiredStringParameters(String name) throws ParseHttpParameterException {
        return STRING_PARSER.validateRequiredStrings(name, (List)Window.Location.getParameterMap().get(name));
    }

    private static class BooleanParser
    extends ParameterParser {
        private BooleanParser() {
        }

        @Override
        protected String getType() {
            return "boolean";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("on") || parameter.equalsIgnoreCase("yes") || parameter.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        }

        public boolean parseBoolean(String name, String parameter) throws ParseHttpParameterException {
            return (Boolean)this.parse(name, parameter);
        }

        public boolean[] parseBooleans(String name, List<String> values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            boolean[] parameters = new boolean[values.size()];
            int i = 0;
            while (i < values.size()) {
                parameters[i] = this.parseBoolean(name, values.get(i));
                ++i;
            }
            return parameters;
        }
    }

    private static class DoubleParser
    extends ParameterParser {
        private DoubleParser() {
        }

        @Override
        protected String getType() {
            return "double";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return Double.valueOf(parameter);
        }

        public double parseDouble(String name, String parameter) throws ParseHttpParameterException {
            return ((Number)this.parse(name, parameter)).doubleValue();
        }

        public double[] parseDoubles(String name, List<String> values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            double[] parameters = new double[values.size()];
            int i = 0;
            while (i < values.size()) {
                parameters[i] = this.parseDouble(name, values.get(i));
                ++i;
            }
            return parameters;
        }
    }

    private static class FloatParser
    extends ParameterParser {
        private FloatParser() {
        }

        @Override
        protected String getType() {
            return "float";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return Float.valueOf(parameter);
        }

        public float parseFloat(String name, String parameter) throws ParseHttpParameterException {
            return ((Number)this.parse(name, parameter)).floatValue();
        }

        public float[] parseFloats(String name, List<String> values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            float[] parameters = new float[values.size()];
            int i = 0;
            while (i < values.size()) {
                parameters[i] = this.parseFloat(name, values.get(i));
                ++i;
            }
            return parameters;
        }
    }

    private static class IntParser
    extends ParameterParser {
        private IntParser() {
        }

        @Override
        protected String getType() {
            return "int";
        }

        @Override
        protected Object doParse(String s) throws NumberFormatException {
            return Integer.valueOf(s);
        }

        public int parseInt(String name, String parameter) throws ParseHttpParameterException {
            return ((Number)this.parse(name, parameter)).intValue();
        }

        public int[] parseInts(String name, List<String> values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            int[] parameters = new int[values.size()];
            int i = 0;
            while (i < values.size()) {
                parameters[i] = this.parseInt(name, values.get(i));
                ++i;
            }
            return parameters;
        }
    }

    private static class LongParser
    extends ParameterParser {
        private LongParser() {
        }

        @Override
        protected String getType() {
            return "long";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return Long.valueOf(parameter);
        }

        public long parseLong(String name, String parameter) throws ParseHttpParameterException {
            return ((Number)this.parse(name, parameter)).longValue();
        }

        public long[] parseLongs(String name, List<String> values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            long[] parameters = new long[values.size()];
            int i = 0;
            while (i < values.size()) {
                parameters[i] = this.parseLong(name, values.get(i));
                ++i;
            }
            return parameters;
        }
    }

    private static abstract class ParameterParser {
        private ParameterParser() {
        }

        protected final Object parse(String name, String parameter) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, parameter);
            try {
                return this.doParse(parameter);
            }
            catch (NumberFormatException ex) {
                throw new ParseHttpParameterException(name, "Required " + this.getType() + " parameter '" + name + "' with value of '" + parameter + "' is not a valid number.", ex);
            }
        }

        protected final void validateRequiredParameter(String name, Object parameter) throws ParseHttpParameterException {
            if (parameter == null) {
                throw new ParseHttpParameterException(name, "Required " + this.getType() + " parameter '" + name + "' is null.");
            }
        }

        protected abstract String getType();

        protected abstract Object doParse(String var1) throws NumberFormatException;
    }

    private static class StringParser
    extends ParameterParser {
        private StringParser() {
        }

        @Override
        protected String getType() {
            return "string";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return parameter;
        }

        public String validateRequiredString(String name, String value) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, value);
            return value;
        }

        public String[] validateRequiredStrings(String name, List<String> values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            String[] parameters = new String[values.size()];
            int i = 0;
            while (i < values.size()) {
                parameters[i] = this.validateRequiredString(name, values.get(i));
                ++i;
            }
            return parameters;
        }
    }
}

