/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.server.filestorage;

import com.sap.sse.filestorage.FileStorageService;
import com.sap.sse.filestorage.FileStorageServiceProperty;
import com.sap.sse.filestorage.InvalidPropertiesException;
import com.sap.sse.gwt.shared.filestorage.FileStorageServiceDTO;
import com.sap.sse.gwt.shared.filestorage.FileStorageServicePropertyDTO;
import com.sap.sse.gwt.shared.filestorage.FileStorageServicePropertyErrorsDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FileStorageServiceDTOUtils {
    public static FileStorageServicePropertyDTO convert(FileStorageServiceProperty p, Locale locale) {
        return new FileStorageServicePropertyDTO(p.isRequired(), p.isPassword(), p.getName(), p.isPassword() ? null : p.getValue(), p.getDescription(locale));
    }

    public static FileStorageServicePropertyErrorsDTO convert(InvalidPropertiesException e, Locale locale) {
        HashMap<FileStorageServicePropertyDTO, String> msgs = new HashMap<FileStorageServicePropertyDTO, String>();
        for (Map.Entry entry : e.getPerPropertyMessage().entrySet()) {
            msgs.put(FileStorageServiceDTOUtils.convert((FileStorageServiceProperty)entry.getKey(), locale), (String)entry.getValue());
        }
        return new FileStorageServicePropertyErrorsDTO(e.getMessage(), msgs);
    }

    public static FileStorageServiceDTO convert(FileStorageService s, Locale locale) {
        ArrayList<FileStorageServicePropertyDTO> pDtos = new ArrayList<FileStorageServicePropertyDTO>();
        FileStorageServiceProperty[] fileStorageServicePropertyArray = s.getProperties();
        int n = fileStorageServicePropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileStorageServiceProperty p = fileStorageServicePropertyArray[n2];
            pDtos.add(FileStorageServiceDTOUtils.convert(p, locale));
            ++n2;
        }
        return new FileStorageServiceDTO(s.getName(), s.getDescription(locale), pDtos.toArray(new FileStorageServicePropertyDTO[0]));
    }
}

