/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.TeeWriter;
import com.sap.sse.common.CacheableRPCResult;
import com.sap.sse.gwt.server.CacheKey;
import com.sap.sse.gwt.server.DelegatingProxiedRemoteServiceServlet;
import com.sap.sse.gwt.server.RPCSerializedResultCacheMXBean;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ResultCachingProxiedRemoteServiceServlet
extends DelegatingProxiedRemoteServiceServlet {
    private static final Logger logger = Logger.getLogger(ResultCachingProxiedRemoteServiceServlet.class.getName());
    private static final long serialVersionUID = -4245484615349695611L;
    private ConcurrentMap<CacheKey, String> resultCache = new ConcurrentHashMap<CacheKey, String>();
    final ReferenceQueue<CacheableRPCResult> dereferencedObjectsQueue;
    private final AtomicLong callCount = new AtomicLong();
    private final AtomicLong recalcCount = new AtomicLong();

    public ResultCachingProxiedRemoteServiceServlet() {
        this.dereferencedObjectsQueue = new ReferenceQueue();
        RPCSerializedResultCacheMXBeanImpl mbean = new RPCSerializedResultCacheMXBeanImpl();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mBeanName = new ObjectName("com.sap.sse:type=GWTRPCSerializedResultCache_" + ((Object)((Object)this)).getClass().getSimpleName() + "_" + ((Object)((Object)this)).toString().substring(((Object)((Object)this)).toString().indexOf(64) + 1));
            mbs.registerMBean(mbean, mBeanName);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Couldn't register MXBean for result-caching proxy " + (Object)((Object)this), e);
        }
    }

    @Override
    protected String encodeResponseForSuccess(Method serviceMethod, SerializationPolicy serializationPolicy, int flags, Object result) throws SerializationException {
        String resultPayload;
        this.purgeCache();
        if (result instanceof CacheableRPCResult) {
            CacheableRPCResult cacheableResult = (CacheableRPCResult)result;
            try {
                this.callCount.incrementAndGet();
                boolean[] written = new boolean[1];
                CacheKey cacheKey = new CacheKey(serializationPolicy, cacheableResult, this.dereferencedObjectsQueue);
                String cachedPayload = this.resultCache.computeIfPresent(cacheKey, (k, v) -> {
                    try {
                        RPC.getResponseWriter().append((CharSequence)v);
                        RPC.finishResponse();
                        blArray[0] = true;
                        return v;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                if (written[0]) {
                    resultPayload = cachedPayload;
                }
                resultPayload = this.resultCache.compute(cacheKey, (key, oldValue) -> {
                    this.recalcCount.incrementAndGet();
                    try {
                        StringWriter copyOfOutput;
                        TeeWriter teeWriter = RPC.getResponseWriter();
                        if (teeWriter.getOtherWriter() != null) {
                            copyOfOutput = (StringWriter)teeWriter.getOtherWriter();
                        } else {
                            copyOfOutput = new StringWriter();
                            teeWriter.setOtherWriter((Writer)copyOfOutput);
                        }
                        super.encodeResponseForSuccess(serviceMethod, serializationPolicy, flags, result);
                        return copyOfOutput.toString();
                    }
                    catch (SerializationException serializationException) {
                        throw new TemporaryWrapperException(serializationException);
                    }
                });
            }
            catch (TemporaryWrapperException e) {
                throw e.serializationException;
            }
        } else {
            resultPayload = super.encodeResponseForSuccess(serviceMethod, serializationPolicy, flags, result);
        }
        return resultPayload;
    }

    private void purgeCache() {
        Reference<CacheableRPCResult> clearedReference;
        while ((clearedReference = this.dereferencedObjectsQueue.poll()) != null) {
            this.resultCache.remove(clearedReference);
        }
    }

    public class RPCSerializedResultCacheMXBeanImpl
    implements RPCSerializedResultCacheMXBean {
        @Override
        public long getCallCount() {
            return ResultCachingProxiedRemoteServiceServlet.this.callCount.get();
        }

        @Override
        public long getRecalcCount() {
            return ResultCachingProxiedRemoteServiceServlet.this.recalcCount.get();
        }

        @Override
        public long getNumberOfCachedResults() {
            return ResultCachingProxiedRemoteServiceServlet.this.resultCache.size();
        }

        @Override
        public long getTotalCacheSize() {
            long result = 0L;
            for (String cachedString : ResultCachingProxiedRemoteServiceServlet.this.resultCache.values()) {
                result += (long)cachedString.length();
            }
            return result;
        }
    }

    private class TemporaryWrapperException
    extends RuntimeException {
        private static final long serialVersionUID = 4720608117776979002L;
        private final SerializationException serializationException;

        public TemporaryWrapperException(SerializationException serializationException) {
            this.serializationException = serializationException;
        }
    }
}

