/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.dispatch.client.transport.gwtrpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.gwt.client.EntryPointHelper;
import com.sap.sse.gwt.dispatch.client.system.DispatchContext;
import com.sap.sse.gwt.dispatch.client.system.DispatchSystemAsync;
import com.sap.sse.gwt.dispatch.client.system.batching.BatchAction;
import com.sap.sse.gwt.dispatch.client.transport.gwtrpc.DispatchRPC;
import com.sap.sse.gwt.dispatch.client.transport.gwtrpc.DispatchRPCAsync;
import com.sap.sse.gwt.dispatch.client.transport.gwtrpc.RequestWrapper;
import com.sap.sse.gwt.dispatch.client.transport.gwtrpc.ResultWrapper;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.gwt.dispatch.shared.commands.HasWriteAction;
import com.sap.sse.gwt.dispatch.shared.commands.Result;
import java.util.ArrayList;

public class DispatchRPCImpl<CTX extends DispatchContext>
implements DispatchSystemAsync<CTX> {
    private final DispatchRPCAsync<CTX> dispatchReadRPC = (DispatchRPCAsync)GWT.create(DispatchRPC.class);
    private final DispatchRPCAsync<CTX> dispatchWriteRPC = (DispatchRPCAsync)GWT.create(DispatchRPC.class);
    private long clientServerOffset = 0L;

    public DispatchRPCImpl(String dispatchRPCPath) {
        EntryPointHelper.registerASyncService((ServiceDefTarget)this.dispatchReadRPC, dispatchRPCPath, HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA);
        EntryPointHelper.registerASyncService((ServiceDefTarget)this.dispatchWriteRPC, dispatchRPCPath, HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER);
    }

    @Override
    public <R extends Result, A extends Action<R, CTX>> void execute(A action, final AsyncCallback<R> callback) {
        RequestWrapper requestWrapper = new RequestWrapper(action, LocaleInfo.getCurrentLocale().getLocaleName());
        final long clientTimeOnRequestStart = System.currentTimeMillis();
        DispatchRPCAsync dispatcher = this.dispatchReadRPC;
        if (action instanceof BatchAction) {
            ArrayList actions = ((BatchAction)action).getActions();
            if (actions != null) {
                for (Action action2 : actions) {
                    if (!(action2 instanceof HasWriteAction)) continue;
                    dispatcher = this.dispatchWriteRPC;
                    break;
                }
            }
        } else if (action instanceof HasWriteAction) {
            dispatcher = this.dispatchWriteRPC;
        }
        dispatcher.execute(requestWrapper, new AsyncCallback<ResultWrapper<R>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(ResultWrapper<R> result) {
                long clientTimeOnRequestEnd = System.currentTimeMillis();
                long latency = (clientTimeOnRequestEnd - clientTimeOnRequestStart) / 2L;
                long currentServerTime = result.getCurrentServerTime().getTime() + latency;
                DispatchRPCImpl.this.clientServerOffset = currentServerTime - clientTimeOnRequestEnd;
                callback.onSuccess(result.getResult());
            }
        });
    }

    public long getClientServerOffset() {
        return this.clientServerOffset;
    }
}

