/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.dispatch.client.system.caching;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.common.Duration;
import com.sap.sse.gwt.dispatch.client.system.DispatchContext;
import com.sap.sse.gwt.dispatch.client.system.DispatchSystemAsync;
import com.sap.sse.gwt.dispatch.shared.caching.HasClientCacheTotalTimeToLive;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.gwt.dispatch.shared.commands.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public final class CachingDispatch<CTX extends DispatchContext>
implements DispatchSystemAsync<CTX> {
    private static final Logger LOG = Logger.getLogger(CachingDispatch.class.getName());
    private final CacheCleanupTask invalidationTask;
    private final HashMap<String, ResultHolder> resultsCache = new HashMap();
    private final DispatchSystemAsync<CTX> dispatch;
    private final int defaultTimeToLiveMillis;

    public CachingDispatch(DispatchSystemAsync<CTX> service) {
        this(service, true, (int)Duration.ONE_MINUTE.times(3L).asMillis());
    }

    public CachingDispatch(DispatchSystemAsync<CTX> service, boolean enableCleanup, int defaultTimeToLive) {
        this.dispatch = service;
        this.defaultTimeToLiveMillis = defaultTimeToLive;
        this.invalidationTask = enableCleanup ? new CacheCleanupTask() : null;
    }

    @Override
    public <R extends Result, A extends Action<R, CTX>> void execute(A action, AsyncCallback<R> callback) {
        if (action instanceof IsClientCacheable) {
            IsClientCacheable clientCacheableAction = (IsClientCacheable)((Object)action);
            ResultHolder cachedResult = this.resultsCache.get(this.key(clientCacheableAction));
            if (cachedResult != null && cachedResult.isValid()) {
                LOG.fine("Cache hit for " + action.getClass().getName());
                callback.onSuccess((Object)cachedResult.getPayload());
            } else {
                LOG.fine("Cache miss for " + action.getClass().getName());
                this.executeAndCache(action, callback);
            }
        } else {
            LOG.fine("Action is not cacheable: " + action.getClass().getName());
            this.dispatch.execute(action, callback);
        }
    }

    private <R extends Result, A extends Action<R, CTX>> void executeAndCache(A action, AsyncCallback<R> callback) {
        if (action instanceof IsClientCacheable) {
            this.dispatch.execute(action, new InterceptingCallback(this, action, callback));
        } else {
            this.dispatch.execute(action, callback);
        }
    }

    private String key(IsClientCacheable action) {
        StringBuilder key = new StringBuilder(action.getClass().getName()).append("_");
        action.cacheInstanceKey(key);
        return key.toString();
    }

    public void cleanupExpiredItems() {
        ArrayList<String> keys = new ArrayList<String>(this.resultsCache.keySet());
        LOG.finest("Start cache cleanup");
        for (String key : keys) {
            if (this.resultsCache.get(key).isValid()) continue;
            this.resultsCache.remove(key);
        }
    }

    public int ttlItemsInCache() {
        return this.resultsCache.size();
    }

    private class CacheCleanupTask
    extends Timer {
        private CacheCleanupTask() {
        }

        public void run() {
            try {
                CachingDispatch.this.cleanupExpiredItems();
            }
            finally {
                if (!CachingDispatch.this.resultsCache.isEmpty()) {
                    CachingDispatch.this.invalidationTask.schedule((int)Duration.ONE_MINUTE.times(5L).asMillis());
                }
            }
        }
    }

    private static class InterceptingCallback<R extends Result, A extends Action<R, CTX>>
    implements AsyncCallback<R> {
        private final A action;
        private final AsyncCallback<R> callback;
        final /* synthetic */ CachingDispatch this$0;

        public InterceptingCallback(A action, AsyncCallback<R> callback) {
            this.this$0 = var1_1;
            this.action = action;
            this.callback = callback;
        }

        public void onSuccess(R result) {
            IsClientCacheable clientCacheableAction = (IsClientCacheable)this.action;
            String instanceKey = this.this$0.key(clientCacheableAction);
            int cacheTotalTimeToLiveMillis = this.timeToLive(this.action, result);
            this.this$0.resultsCache.put(instanceKey, new ResultHolder(System.currentTimeMillis() + (long)cacheTotalTimeToLiveMillis, (Result)result));
            LOG.finest("Added " + instanceKey + " to cache, ttl: " + cacheTotalTimeToLiveMillis + "ms");
            if (this.this$0.invalidationTask != null && !this.this$0.invalidationTask.isRunning()) {
                LOG.finest("Schedule cache cleanup");
                this.this$0.invalidationTask.schedule((int)Duration.ONE_MINUTE.times(5L).asMillis());
            }
            this.callback.onSuccess(result);
        }

        private int timeToLive(A action, R result) {
            int cacheTotalTimeToLiveMillis = this.this$0.defaultTimeToLiveMillis;
            if (result instanceof HasClientCacheTotalTimeToLive) {
                cacheTotalTimeToLiveMillis = ((HasClientCacheTotalTimeToLive)result).cacheTotalTimeToLiveMillis();
            } else if (action instanceof HasClientCacheTotalTimeToLive) {
                cacheTotalTimeToLiveMillis = ((HasClientCacheTotalTimeToLive)action).cacheTotalTimeToLiveMillis();
            }
            return cacheTotalTimeToLiveMillis;
        }

        public void onFailure(Throwable caught) {
            this.callback.onFailure(caught);
        }
    }

    private static class ResultHolder {
        final Result payload;
        final long invalidationTimestamp;

        public ResultHolder(long invalidationTimestamp, Result payload) {
            this.invalidationTimestamp = invalidationTimestamp;
            this.payload = payload;
        }

        public boolean isValid() {
            return System.currentTimeMillis() < this.invalidationTimestamp;
        }

        public Result getPayload() {
            return this.payload;
        }
    }
}

