/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.settings;

import com.google.gwt.json.client.JSONObject;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.settings.generic.SettingsMap;
import com.sap.sse.gwt.client.shared.settings.StorableSettingsRepresentation;
import com.sap.sse.gwt.settings.SettingsToJsonSerializerGWT;
import com.sap.sse.gwt.settings.SettingsToUrlSerializer;

public class SettingsRepresentationTransformer {
    private final SettingsToUrlSerializer urlSerializer = new SettingsToUrlSerializer();
    private final SettingsToJsonSerializerGWT jsonSerializer = new SettingsToJsonSerializerGWT();

    public <S extends Settings> S mergeSettingsObjectWithUrlSettings(S settingsObject) {
        Object effectiveSettings = settingsObject;
        if (effectiveSettings instanceof GenericSerializableSettings) {
            effectiveSettings = this.urlSerializer.deserializeFromCurrentLocation((GenericSerializableSettings)effectiveSettings);
        } else if (effectiveSettings instanceof SettingsMap) {
            effectiveSettings = this.urlSerializer.deserializeSettingsMapFromCurrentLocation((SettingsMap)effectiveSettings);
        }
        return effectiveSettings;
    }

    public <S extends Settings> S mergeSettingsObjectWithStorableRepresentation(S settingsObject, StorableSettingsRepresentation settingsRepresentation) {
        Object effectiveSettings = settingsObject;
        if (effectiveSettings instanceof GenericSerializableSettings) {
            effectiveSettings = this.jsonSerializer.deserialize((GenericSerializableSettings)effectiveSettings, settingsRepresentation.asJson());
        } else if (effectiveSettings instanceof SettingsMap) {
            effectiveSettings = this.jsonSerializer.deserialize((SettingsMap)effectiveSettings, settingsRepresentation.asJson());
        }
        return effectiveSettings;
    }

    public StorableSettingsRepresentation convertToSettingsRepresentation(Settings newSettings) {
        if (newSettings instanceof GenericSerializableSettings) {
            return new StorableSettingsRepresentation((JSONObject)this.jsonSerializer.serialize((GenericSerializableSettings)newSettings));
        }
        throw new IllegalStateException("Requested save of settings that is not Serializable!");
    }
}

