/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.perspective;

import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeTabbedSettingsDialogComponent;
import java.util.HashMap;
import java.util.Map;

public class PerspectiveCompositeValidator<PS extends Settings>
implements DataEntryDialog.Validator<PerspectiveCompositeSettings<PS>> {
    private final Map<String, DataEntryDialog.Validator<?>> validatorsMappedByComponent;
    private final DataEntryDialog.Validator<PS> perspectiveValidator;

    public PerspectiveCompositeValidator(PerspectiveCompositeTabbedSettingsDialogComponent.PerspectiveIdWithSettingsAndDialogComponent<PS> perspectiveAndDialogComponent, Iterable<PerspectiveCompositeTabbedSettingsDialogComponent.ComponentIdWithSettingsAndDialogComponent<?>> componentsAndDialogComponents) {
        this.perspectiveValidator = perspectiveAndDialogComponent.getSettingsDialogComponent() != null ? perspectiveAndDialogComponent.getSettingsDialogComponent().getValidator() : null;
        this.validatorsMappedByComponent = new HashMap();
        for (PerspectiveCompositeTabbedSettingsDialogComponent.ComponentIdWithSettingsAndDialogComponent<?> componentsAndSettingsDialog : componentsAndDialogComponents) {
            this.validatorsMappedByComponent.put(componentsAndSettingsDialog.getComponentId(), componentsAndSettingsDialog.getSettingsDialog().getValidator());
        }
    }

    @Override
    public String getErrorMessage(PerspectiveCompositeSettings<PS> valueToValidate) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Settings> componentAndSettings : valueToValidate.getSettingsPerComponentId().entrySet()) {
            String errorMessage = this.getComponentErrorMessage(componentAndSettings);
            if (errorMessage == null || errorMessage.isEmpty()) continue;
            result.append(errorMessage);
        }
        String perspectiveErrorMessage = this.getPerspectiveErrorMessage(valueToValidate.getPerspectiveOwnSettings());
        if (perspectiveErrorMessage != null && !perspectiveErrorMessage.isEmpty()) {
            result.append(perspectiveErrorMessage);
        }
        return result.toString();
    }

    private String getPerspectiveErrorMessage(PS perspectiveSettings) {
        String errorMessage = null;
        if (this.perspectiveValidator != null) {
            errorMessage = this.perspectiveValidator.getErrorMessage(perspectiveSettings);
        }
        return errorMessage;
    }

    private <SettingsType extends Settings> String getComponentErrorMessage(Map.Entry<String, SettingsType> componentIdAndSettings) {
        String errorMessage = null;
        DataEntryDialog.Validator<?> validator = this.validatorsMappedByComponent.get(componentIdAndSettings.getKey());
        if (validator != null && (errorMessage = validator.getErrorMessage((Settings)componentIdAndSettings.getValue())) != null && !errorMessage.isEmpty() && !this.getClass().equals(validator.getClass())) {
            errorMessage = String.valueOf(errorMessage) + "; ";
        }
        return errorMessage;
    }
}

