/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.perspective;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.ComponentLifecycle;
import com.sap.sse.gwt.client.shared.components.CompositeSettings;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.Perspective;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeValidator;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveLifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerspectiveCompositeTabbedSettingsDialogComponent<PS extends Settings>
implements SettingsDialogComponent<PerspectiveCompositeSettings<PS>> {
    private final List<ComponentIdWithSettingsAndDialogComponent<?>> componentIdsAndDialogComponents = new ArrayList();
    private final PerspectiveIdWithSettingsAndDialogComponent<PS> perspectiveIdsAndSettingsDialog;

    public PerspectiveCompositeTabbedSettingsDialogComponent(Perspective<PS> perspective) {
        for (Component<Settings> component : perspective.getComponents()) {
            for (ComponentIdWithSettingsAndDialogComponent<?> c : this.componentIdsAndDialogComponents) {
                if (!c.getComponentId().equals(component.getId())) continue;
                throw new IllegalStateException("Creating a SettingsDialog with duplicate componentids internally " + component.getId());
            }
            this.componentIdsAndDialogComponents.add(this.createComponentAndDialogComponent(component));
        }
        this.perspectiveIdsAndSettingsDialog = this.createPerspectiveAndDialogComponent(perspective);
    }

    public PerspectiveCompositeTabbedSettingsDialogComponent(PerspectiveLifecycle<PS> lifecycle, PerspectiveCompositeSettings<PS> settings) {
        for (ComponentLifecycle<?> componentLifecycle : lifecycle.getComponentLifecycles()) {
            if (!componentLifecycle.hasSettings()) continue;
            this.createComponentIdWithSettingsAndDialogComponent(settings, componentLifecycle);
        }
        this.perspectiveIdsAndSettingsDialog = this.createPerspectiveIdAndDialogComponent(lifecycle, settings.getPerspectiveOwnSettings());
    }

    private <S extends Settings, C extends Component<S>> void createComponentIdWithSettingsAndDialogComponent(CompositeSettings componentSettings, ComponentLifecycle<S> componentLifecycle) {
        Object settingsOfComponent = componentSettings.findSettingsByComponentId(componentLifecycle.getComponentId());
        for (ComponentIdWithSettingsAndDialogComponent<?> c : this.componentIdsAndDialogComponents) {
            if (!c.getComponentId().equals(componentLifecycle.getComponentId())) continue;
            throw new IllegalStateException("Creating a SettingsDialog with duplicate componentids internally " + componentLifecycle.getComponentId());
        }
        this.componentIdsAndDialogComponents.add(new ComponentIdWithSettingsAndDialogComponent(componentLifecycle.getLocalizedShortName(), componentLifecycle.getComponentId(), settingsOfComponent, componentLifecycle.getSettingsDialogComponent(settingsOfComponent)));
    }

    private PerspectiveIdWithSettingsAndDialogComponent<PS> createPerspectiveIdAndDialogComponent(PerspectiveLifecycle<PS> perspectiveLifecycle, PS perspectiveOwnSettings) {
        return new PerspectiveIdWithSettingsAndDialogComponent<PS>(perspectiveLifecycle.getLocalizedShortName(), perspectiveOwnSettings, perspectiveLifecycle.getPerspectiveOwnSettingsDialogComponent(perspectiveOwnSettings));
    }

    private PerspectiveIdWithSettingsAndDialogComponent<PS> createPerspectiveAndDialogComponent(Perspective<PS> perspective) {
        PerspectiveIdWithSettingsAndDialogComponent result = null;
        if (perspective.hasPerspectiveOwnSettings()) {
            result = new PerspectiveIdWithSettingsAndDialogComponent(perspective.getLocalizedShortName(), ((PerspectiveCompositeSettings)((Object)perspective.getSettings())).getPerspectiveOwnSettings(), perspective.getPerspectiveOwnSettingsDialogComponent());
        }
        return result;
    }

    private <SettingsType extends Settings> ComponentIdWithSettingsAndDialogComponent<SettingsType> createComponentAndDialogComponent(Component<SettingsType> component) {
        return new ComponentIdWithSettingsAndDialogComponent<SettingsType>(component.getLocalizedShortName(), component.getId(), component.getSettings(), component.getSettingsDialogComponent(component.getSettings()));
    }

    private PS getPerspectiveOwnSettings(PerspectiveIdWithSettingsAndDialogComponent<PS> perspectiveAndDialog) {
        SettingsDialogComponent<PS> settingsDialogComponent = perspectiveAndDialog.getSettingsDialogComponent();
        if (settingsDialogComponent != null) {
            return settingsDialogComponent.getResult();
        }
        return null;
    }

    @Override
    public Widget getAdditionalWidget(final DataEntryDialog<?> dialog) {
        SettingsDialogComponent<PS> additional;
        TabPanel result = new TabPanel();
        result.ensureDebugId("TabbedSettingsDialogTabPanel");
        if (this.perspectiveIdsAndSettingsDialog != null && (additional = this.perspectiveIdsAndSettingsDialog.getSettingsDialogComponent()) != null) {
            Widget w = additional.getAdditionalWidget(dialog);
            result.add(w, this.perspectiveIdsAndSettingsDialog.getPerspectiveName());
        }
        for (ComponentIdWithSettingsAndDialogComponent<?> componentAndSettingsDialog : this.componentIdsAndDialogComponents) {
            Widget w = componentAndSettingsDialog.getSettingsDialog().getAdditionalWidget(dialog);
            result.add(w, componentAndSettingsDialog.getComponentName());
        }
        result.selectTab(0);
        result.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                dialog.center();
            }
        });
        return result;
    }

    @Override
    public PerspectiveCompositeSettings<PS> getResult() {
        Object perspectiveOwnSettings = this.perspectiveIdsAndSettingsDialog != null ? (Object)this.getPerspectiveOwnSettings(this.perspectiveIdsAndSettingsDialog) : null;
        HashMap<String, Settings> settings = new HashMap<String, Settings>();
        for (ComponentIdWithSettingsAndDialogComponent<?> componentAndDialog : this.componentIdsAndDialogComponents) {
            if (settings.containsKey(componentAndDialog.getComponentId())) {
                throw new IllegalStateException("Duplicate Componentid " + componentAndDialog.getComponentId());
            }
            settings.put(componentAndDialog.getComponentId(), (Settings)componentAndDialog.getSettingsDialog().getResult());
        }
        return new PerspectiveCompositeSettings<Object>(perspectiveOwnSettings, (Map<String, Settings>)settings);
    }

    @Override
    public PerspectiveCompositeValidator<PS> getValidator() {
        return new PerspectiveCompositeValidator<PS>(this.perspectiveIdsAndSettingsDialog, this.componentIdsAndDialogComponents);
    }

    @Override
    public FocusWidget getFocusWidget() {
        for (ComponentIdWithSettingsAndDialogComponent<?> componentAndSettingsDialog : this.componentIdsAndDialogComponents) {
            FocusWidget fw = componentAndSettingsDialog.getSettingsDialog().getFocusWidget();
            if (fw == null) continue;
            return fw;
        }
        return null;
    }

    public static class ComponentIdWithSettingsAndDialogComponent<S extends Settings> {
        private final String componentId;
        private final S settings;
        private final SettingsDialogComponent<S> settingsDialog;
        private final String componentName;

        public ComponentIdWithSettingsAndDialogComponent(String componentName, String componentId, S settings, SettingsDialogComponent<S> settingsDialog) {
            this.componentName = componentName;
            this.componentId = componentId;
            this.settings = settings;
            this.settingsDialog = settingsDialog;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public S getSettings() {
            return this.settings;
        }

        public SettingsDialogComponent<S> getSettingsDialog() {
            return this.settingsDialog;
        }

        public String getComponentName() {
            return this.componentName;
        }
    }

    public static class PerspectiveIdWithSettingsAndDialogComponent<PS extends Settings> {
        private final PS perspectiveOwnSettings;
        private final SettingsDialogComponent<PS> settingsDialog;
        private final String perspectiveName;

        public PerspectiveIdWithSettingsAndDialogComponent(String perspectiveName, PS perspectiveOwnSettings, SettingsDialogComponent<PS> settingsDialog) {
            this.perspectiveName = perspectiveName;
            this.perspectiveOwnSettings = perspectiveOwnSettings;
            this.settingsDialog = settingsDialog;
        }

        public PS getPerspectiveOwnSettings() {
            return this.perspectiveOwnSettings;
        }

        public SettingsDialogComponent<PS> getSettingsDialogComponent() {
            return this.settingsDialog;
        }

        public String getPerspectiveName() {
            return this.perspectiveName;
        }
    }
}

