/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.AbstractSettingsDialog;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.LinkWithSettingsGenerator;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.DummyOnSettingsStoredCallback;
import com.sap.sse.gwt.client.shared.settings.OnSettingsLoadedCallback;
import com.sap.sse.gwt.client.shared.settings.OnSettingsStoredCallback;

public class SettingsDialog<SettingsType extends Settings>
extends AbstractSettingsDialog<SettingsType> {
    private Button makeDefaultButton;
    private Button resetDefault;

    public SettingsDialog(Component<SettingsType> component, StringMessages stringMessages) {
        this(component, stringMessages, true, null);
    }

    public SettingsDialog(Component<SettingsType> component, StringMessages stringMessages, LinkWithSettingsGenerator<SettingsType> linkWithSettingsGenerator) {
        this(component, stringMessages, true, linkWithSettingsGenerator);
    }

    public SettingsDialog(Component<SettingsType> component, StringMessages stringMessages, boolean animationEnabled, LinkWithSettingsGenerator<SettingsType> linkWithSettingsGenerator) {
        this(component, component.getSettingsDialogComponent(component.getSettings()), stringMessages, animationEnabled, linkWithSettingsGenerator, null);
    }

    public SettingsDialog(Component<SettingsType> component, StringMessages stringMessages, DataEntryDialog.DialogCallback<SettingsType> callback) {
        this(component, component.getSettingsDialogComponent(component.getSettings()), stringMessages, true, null, callback);
    }

    public static <T extends Settings> Button createSettingsButton(final Component<T> component, final StringMessages stringMessages) {
        Button settingsButton = new Button();
        settingsButton.setTitle(stringMessages.settings());
        settingsButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new SettingsDialog(component, stringMessages).show();
            }
        });
        return settingsButton;
    }

    private SettingsDialog(Component<SettingsType> component, SettingsDialogComponent<SettingsType> dialogComponent, StringMessages stringMessages, boolean animationEnabled, LinkWithSettingsGenerator<SettingsType> linkWithSettingsGenerator, DataEntryDialog.DialogCallback<SettingsType> callback) {
        super(component.getLocalizedShortName(), dialogComponent, stringMessages, animationEnabled, linkWithSettingsGenerator, new SettingsDialogCallback<SettingsType>(component, callback));
        if (component.getComponentContext() != null && component.getComponentContext().isStorageSupported(component)) {
            this.initMakeDefaultButtons(component, stringMessages);
        }
    }

    private void initMakeDefaultButtons(final Component<SettingsType> component, final StringMessages stringMessages) {
        this.makeDefaultButton = new Button(stringMessages.makeDefault());
        this.makeDefaultButton.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
        this.makeDefaultButton.ensureDebugId("MakeDefaultButton");
        this.makeDefaultButton.addStyleName("btn-secondary");
        this.makeDefaultButton.addStyleName("btn-lg");
        this.getLeftButtonPannel().add((Widget)this.makeDefaultButton);
        this.makeDefaultButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SettingsDialog.this.setButtonSavingState(true, stringMessages);
                component.getComponentContext().makeSettingsDefault(component, SettingsDialog.this.getResult(), new OnSettingsStoredCallback(){

                    @Override
                    public void onSuccess() {
                        SettingsDialog.this.setButtonSavingState(false, stringMessages);
                        Notification.notify(stringMessages.settingsSavedMessage(), Notification.NotificationType.SUCCESS);
                    }

                    @Override
                    public void onError(Throwable caught) {
                        SettingsDialog.this.setButtonSavingState(false, stringMessages);
                        Notification.notify(stringMessages.settingsSaveErrorMessage(), Notification.NotificationType.ERROR);
                    }
                });
            }
        });
        this.resetDefault = new Button(stringMessages.resetToDefault());
        this.resetDefault.addStyleName("btn-secondary");
        this.resetDefault.addStyleName("btn-lg");
        this.resetDefault.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                component.getComponentContext().resetSettingsToDefault(component, SettingsDialog.this.getResult(), new OnSettingsLoadedCallback<SettingsType>(){

                    @Override
                    public void onError(Throwable caught, SettingsType fallbackDefaultSettings) {
                        SettingsDialog.this.setButtonSavingState(false, stringMessages);
                        SettingsDialog.this.onChange(fallbackDefaultSettings);
                        Notification.notify(stringMessages.settingsRemovedError(), Notification.NotificationType.ERROR);
                    }

                    @Override
                    public void onSuccess(SettingsType settings) {
                        SettingsDialog.this.setButtonSavingState(false, stringMessages);
                        SettingsDialog.this.setDialogComponent(component.getSettingsDialogComponent(settings));
                        Notification.notify(stringMessages.settingsRemoved(), Notification.NotificationType.SUCCESS);
                    }
                });
            }
        });
        this.resetDefault.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
        this.resetDefault.ensureDebugId("ResetToDefaultButton");
        this.getLeftButtonPannel().add((Widget)this.resetDefault);
    }

    private void setButtonSavingState(boolean savingState, StringMessages stringMessages) {
        if (savingState) {
            this.makeDefaultButton.setEnabled(false);
            this.makeDefaultButton.setText(stringMessages.makeDefaultInProgress());
            this.resetDefault.setEnabled(false);
            this.resetDefault.setText(stringMessages.resetToDefaultInProgress());
        } else {
            this.makeDefaultButton.setEnabled(true);
            this.makeDefaultButton.setText(stringMessages.makeDefault());
            this.resetDefault.setEnabled(true);
            this.resetDefault.setText(stringMessages.resetToDefault());
        }
    }

    @Override
    protected void onInvalidStateChanged(boolean invalidState) {
        super.onInvalidStateChanged(invalidState);
        if (this.makeDefaultButton != null) {
            this.makeDefaultButton.setEnabled(!invalidState);
        }
    }

    private static class SettingsDialogCallback<SettingsType extends Settings>
    implements DataEntryDialog.DialogCallback<SettingsType> {
        private final DataEntryDialog.DialogCallback<SettingsType> nestedCallback;
        private final Component<SettingsType> component;

        public SettingsDialogCallback(Component<SettingsType> component, DataEntryDialog.DialogCallback<SettingsType> nestedCallback) {
            this.component = component;
            this.nestedCallback = nestedCallback;
        }

        @Override
        public void ok(SettingsType editedSettings) {
            if (this.component.getComponentContext() != null && this.component.getComponentContext().isStorageSupported(this.component)) {
                this.component.getComponentContext().storeSettingsForContext(this.component, editedSettings, new DummyOnSettingsStoredCallback());
            }
            this.component.updateSettings(editedSettings);
            if (this.nestedCallback != null) {
                this.nestedCallback.ok(editedSettings);
            }
        }

        @Override
        public void cancel() {
            if (this.nestedCallback != null) {
                this.nestedCallback.cancel();
            }
        }
    }
}

