/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.player;

import com.google.gwt.core.client.Scheduler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.player.PlayStateListener;
import com.sap.sse.gwt.client.player.TimeListener;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Timer {
    private static final long LIVE_CLOCK_QUANTUM = 1000L;
    private Date time;
    private long livePlayDelayInMillis;
    private final Set<TimeListener> timeListeners;
    private final Set<PlayStateListener> playStateListeners;
    private PlayStates playState;
    private PlayModes playMode;
    private long refreshInterval;
    private boolean refreshIntervalChanged;
    private double playSpeedFactor;
    private long millisecondsClientIsBehindServer;
    private boolean clientServerOffsetHasAtLeastBeenSetOnce;
    private boolean initialized;

    public Timer(PlayModes playMode) {
        this(playMode, Timer.getDefaultPlayStateForPlayMode(playMode));
    }

    public Timer(PlayModes playMode, PlayStates playState) {
        this(playMode, playState, 1000L);
    }

    public Timer(PlayModes playMode, long refreshIntervalInMillis) {
        this(playMode, Timer.getDefaultPlayStateForPlayMode(playMode), refreshIntervalInMillis);
    }

    public Timer(PlayModes playMode, PlayStates playState, long refreshIntervalInMillis) {
        this.refreshInterval = refreshIntervalInMillis;
        this.time = new Date();
        this.initialized = playMode == PlayModes.Live;
        this.timeListeners = new HashSet<TimeListener>();
        this.playStateListeners = new HashSet<PlayStateListener>();
        this.setPlaySpeedFactor(1.0);
        this.livePlayDelayInMillis = 0L;
        this.playMode = playMode;
        this.setPlayState(playState, false);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private static PlayStates getDefaultPlayStateForPlayMode(PlayModes playMode) {
        return playMode == PlayModes.Live ? PlayStates.Playing : PlayStates.Paused;
    }

    public void addTimeListener(TimeListener listener) {
        this.timeListeners.add(listener);
    }

    public void removeTimeListener(TimeListener listener) {
        this.timeListeners.remove(listener);
    }

    public void addPlayStateListener(PlayStateListener listener) {
        this.playStateListeners.add(listener);
    }

    public void removePlayStateListener(PlayStateListener listener) {
        this.playStateListeners.remove(listener);
    }

    public void adjustClientServerOffset(long clientTimeWhenRequestWasSent, Date serverTimeDuringRequest, long clientTimeWhenResponseWasReceived) {
        if (serverTimeDuringRequest != null) {
            long responseNetworkLatencyInMillis = (clientTimeWhenResponseWasReceived - clientTimeWhenRequestWasSent) / 2L;
            long offset = serverTimeDuringRequest.getTime() + responseNetworkLatencyInMillis - clientTimeWhenResponseWasReceived;
            if (this.clientServerOffsetHasAtLeastBeenSetOnce) {
                double exponentialMovingAverageFactor = 0.5;
                this.millisecondsClientIsBehindServer = (long)((double)this.millisecondsClientIsBehindServer * 0.5 + 0.5 * (double)offset);
            } else {
                this.millisecondsClientIsBehindServer = offset;
                this.clientServerOffsetHasAtLeastBeenSetOnce = true;
            }
        }
    }

    public void setTime(long timePointAsMillis) {
        this.initialized = true;
        Date oldTime = this.time;
        this.time = new Date(timePointAsMillis);
        if (oldTime == null != (this.time == null) || oldTime != null && !oldTime.equals(this.time)) {
            for (TimeListener listener : this.timeListeners) {
                listener.timeChanged(this.time, oldTime);
            }
        }
    }

    public void setPlaySpeedFactor(double playSpeedFactor) {
        this.playSpeedFactor = playSpeedFactor;
        for (PlayStateListener playStateListener : this.playStateListeners) {
            playStateListener.playSpeedFactorChanged(this.playSpeedFactor);
        }
    }

    public double getPlaySpeedFactor() {
        return this.playSpeedFactor;
    }

    public void setRefreshInterval(long refreshIntervalInMillis) {
        this.refreshInterval = refreshIntervalInMillis;
        if (this.playState == PlayStates.Playing) {
            this.refreshIntervalChanged = true;
        }
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public Date getTime() {
        return this.time;
    }

    public void setPlayMode(PlayModes newPlayMode) {
        if (this.playMode != newPlayMode) {
            this.playMode = newPlayMode;
            for (PlayStateListener playStateListener : this.playStateListeners) {
                playStateListener.playStateChanged(this.playState, this.playMode);
            }
        }
        if (newPlayMode == PlayModes.Live) {
            this.play();
        }
    }

    private void setPlayState(PlayStates newPlayState, boolean updatePlayMode) {
        if (this.playState != newPlayState) {
            this.playState = newPlayState;
            if (newPlayState == PlayStates.Playing) {
                if (this.playMode == PlayModes.Live) {
                    this.setTime(this.getLiveTimePointInMillis());
                }
                this.startAutoAdvance();
            } else if (updatePlayMode) {
                this.setPlayMode(PlayModes.Replay);
            }
            for (PlayStateListener playStateListener : this.playStateListeners) {
                playStateListener.playStateChanged(this.playState, this.playMode);
            }
        }
    }

    public void pause() {
        this.setPlayState(PlayStates.Paused, true);
    }

    public void play() {
        this.setPlayState(PlayStates.Playing, true);
    }

    private void startAutoAdvance() {
        Scheduler.RepeatingCommand command = new Scheduler.RepeatingCommand(){

            public boolean execute() {
                if (Timer.this.time != null && Timer.this.playState == PlayStates.Playing) {
                    long newTime = Timer.this.time.getTime();
                    newTime = Timer.this.playMode == PlayModes.Replay ? (newTime += (long)Timer.this.playSpeedFactor * Timer.this.refreshInterval) : Timer.this.quantizeTimeStamp(Timer.this.getLiveTimePointInMillis());
                    Timer.this.setTime(newTime);
                }
                if (Timer.this.refreshIntervalChanged) {
                    Timer.this.refreshIntervalChanged = false;
                    Timer.this.scheduleAdvancerCommand(this);
                    return false;
                }
                return Timer.this.playState == PlayStates.Playing;
            }
        };
        this.scheduleAdvancerCommand(command);
    }

    private long quantizeTimeStamp(long millis) {
        return millis - millis % 1000L;
    }

    private void scheduleAdvancerCommand(Scheduler.RepeatingCommand command) {
        Scheduler.get().scheduleFixedPeriod(command, (int)this.refreshInterval);
    }

    public void setLivePlayDelayInMillis(long delayInMilliseconds) {
        if (this.livePlayDelayInMillis != delayInMilliseconds) {
            this.livePlayDelayInMillis = delayInMilliseconds;
            if (this.getPlayMode() == PlayModes.Live) {
                this.setTime(this.getLiveTimePointInMillis());
            }
        }
    }

    public long getLivePlayDelayInMillis() {
        return this.livePlayDelayInMillis;
    }

    public PlayStates getPlayState() {
        return this.playState;
    }

    public PlayModes getPlayMode() {
        return this.playMode;
    }

    public long getLiveTimePointInMillis() {
        return System.currentTimeMillis() - this.getLivePlayDelayInMillis() + this.millisecondsClientIsBehindServer;
    }

    public Date getLiveTimePointAsDate() {
        return new Date(this.getLiveTimePointInMillis());
    }

    public TimePoint getLiveTimePoint() {
        return new MillisecondsTimePoint(this.getLiveTimePointInMillis());
    }

    public void reset() {
        this.timeListeners.clear();
        this.playStateListeners.clear();
    }

    public static enum PlayModes {
        Live,
        Replay;

    }

    public static enum PlayStates {
        Playing,
        Paused;

    }
}

