/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.media;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.NatureOfClaim;
import com.sap.sse.common.media.TakedownNoticeRequestContext;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.GenericListBox;
import com.sap.sse.gwt.client.controls.listedit.StringListEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import java.util.Collections;

public class TakedownNoticeRequestDialog
extends DataEntryDialog<TakedownNoticeRequestContext> {
    private static TakedownNoticeService serviceToUseForTakedownNotice;
    private final String contextDescriptionMessageKey;
    private final String contextDescriptionMessageParameter;
    private final String contentUrl;
    private final GenericListBox<NatureOfClaim> natureOfClaimListBox;
    private final TextArea reportingUserCommentTextArea;
    private final StringListEditorComposite supportingURLsEditor;
    private final String username;
    private final StringMessages stringMessages;

    public static void ensureJSFunctionInstalled(TakedownNoticeService serviceToUseForTakedownNotice) {
        TakedownNoticeRequestDialog.serviceToUseForTakedownNotice = serviceToUseForTakedownNotice;
        TakedownNoticeRequestDialog.ensureJSFunctionInstalled();
    }

    private static native void ensureJSFunctionInstalled();

    private static void showTakedownNoticeRequestDialog(String contextDescriptionMessageKey, String contextDescriptionMessageParameter, String contentUrl, String username) {
        if (!Util.hasLength((String)username.trim()) || !serviceToUseForTakedownNotice.isEmailAddressOfCurrentUserValidated()) {
            Notification.notify(StringMessages.INSTANCE.mustBeLoggedInAndWithValidatedEmail(), Notification.NotificationType.ERROR);
        } else {
            TakedownNoticeRequestDialog dialog = new TakedownNoticeRequestDialog(contextDescriptionMessageKey, contextDescriptionMessageParameter, contentUrl, username, StringMessages.INSTANCE, new DataEntryDialog.DialogCallback<TakedownNoticeRequestContext>(){

                @Override
                public void ok(TakedownNoticeRequestContext editedObject) {
                    serviceToUseForTakedownNotice.fileTakedownNotice(editedObject);
                }

                @Override
                public void cancel() {
                }
            });
            dialog.show();
        }
    }

    public TakedownNoticeRequestDialog(String contextDescriptionMessageKey, String contextDescriptionMessageParameter, String contentUrl, String username, StringMessages stringMessages, DataEntryDialog.DialogCallback<TakedownNoticeRequestContext> callback) {
        super(stringMessages.takedownNoticeDialogTitle(), stringMessages.takedownNoticeDialogMessage(contentUrl), stringMessages.ok(), stringMessages.cancel(), null, callback);
        this.stringMessages = stringMessages;
        this.username = username;
        this.reportingUserCommentTextArea = this.createTextArea("");
        this.natureOfClaimListBox = this.createGenericListBox(this::getDisplayString, false);
        NatureOfClaim[] natureOfClaimArray = NatureOfClaim.values();
        int n = natureOfClaimArray.length;
        int n2 = 0;
        while (n2 < n) {
            NatureOfClaim noc = natureOfClaimArray[n2];
            this.natureOfClaimListBox.addItem(noc);
            ++n2;
        }
        this.supportingURLsEditor = new StringListEditorComposite((Iterable<String>)Collections.emptySet(), stringMessages, IconResources.INSTANCE.removeIcon(), (Iterable<String>)Collections.emptySet());
        this.contextDescriptionMessageKey = contextDescriptionMessageKey;
        this.contextDescriptionMessageParameter = contextDescriptionMessageParameter;
        this.contentUrl = contentUrl;
        this.getDialogBox().getElement().getStyle().setProperty("overflowWrap", "anywhere");
        this.getDialogBox().setWidth(Math.min(Window.getClientWidth(), 600) + "px");
        this.getStatusLabel().getElement().getStyle().setProperty("height", "0px");
    }

    public String getDisplayString(NatureOfClaim natureOfClaim) {
        switch (natureOfClaim) {
            case COPYRIGHT_INFRINGEMENT: {
                return this.stringMessages.natureOfClaim_CopyrightInfringement();
            }
            case DEFAMATORY_CONTENT: {
                return this.stringMessages.natureOfClaim_DefamatoryContent();
            }
            case INAPPROPRIATE: {
                return this.stringMessages.natureOfClaim_Inappropriate();
            }
            case VIOLENCE: {
                return this.stringMessages.natureOfClaim_Violence();
            }
            case NONE: {
                return this.stringMessages.natureOfClaim_None();
            }
            case OTHER: {
                return this.stringMessages.natureOfClaim_Other();
            }
        }
        throw new RuntimeException("unknown NatureOfClaim: " + natureOfClaim);
    }

    @Override
    protected Widget getAdditionalWidget() {
        Grid result = new Grid(3, 2);
        result.setStyleName("table-with-spacing");
        int row = 0;
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.natureOfTakedownClaim()));
        result.setWidget(row++, 1, this.natureOfClaimListBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.comment()));
        result.setWidget(row++, 1, (Widget)this.reportingUserCommentTextArea);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.supportingURLs()));
        result.setWidget(row++, 1, (Widget)this.supportingURLsEditor);
        return result;
    }

    @Override
    protected TakedownNoticeRequestContext getResult() {
        return new TakedownNoticeRequestContext(this.contextDescriptionMessageKey, this.contextDescriptionMessageParameter, this.contentUrl, Window.Location.createUrlBuilder().buildString(), this.natureOfClaimListBox.getValue(), this.reportingUserCommentTextArea.getValue(), (Iterable)this.supportingURLsEditor.getValue(), this.username);
    }
}

