/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.dialog;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.dialog.DialogResources;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import java.util.function.Consumer;

public class ConfirmationDialog
extends DialogBox {
    private TextBox hiddenBox;
    private static DialogResources resources = DialogResources.INSTANCE;
    private static DialogResources.DialogStyle style = resources.style();
    private final Panel mainPanel;
    private final Panel buttonsPanel;

    public static ConfirmationDialog create(String title, String text, String confirmButtonText, String cancelButtonText, Consumer<Boolean> callback) {
        return new ConfirmationDialog(title, text).addButton(confirmButtonText, true, event -> callback.accept(true)).addButton(cancelButtonText, false, event -> callback.accept(false));
    }

    public static ConfirmationDialog create(String title, String text, String confirmButtonText, String cancelButtonText, Runnable confirmCallback) {
        return new ConfirmationDialog(title, text).addButton(confirmButtonText, true, event -> confirmCallback.run()).addButton(cancelButtonText, false, event -> {});
    }

    private ConfirmationDialog(String title, String text) {
        style.ensureInjected();
        this.hiddenBox = new TextBox();
        this.hiddenBox.setFocus(true);
        this.hiddenBox.getElement().getStyle().setHeight(0.0, Style.Unit.PX);
        this.hiddenBox.getElement().getStyle().setBorderColor("#fff");
        this.hiddenBox.getElement().getStyle().setOpacity(0.0);
        this.hiddenBox.getElement().getStyle().setPadding(0.0, Style.Unit.PX);
        this.hiddenBox.getElement().getStyle().setBorderStyle(Style.BorderStyle.NONE);
        this.hiddenBox.getElement().getStyle().setDisplay(Style.Display.BLOCK);
        this.mainPanel = this.createPanel(style.confirmationDialog());
        this.buttonsPanel = this.createPanel(style.buttonsPanel());
        this.addMessageText(text);
        this.mainPanel.add((Widget)this.buttonsPanel);
        this.mainPanel.add((Widget)this.hiddenBox);
        this.setWidget((Widget)this.mainPanel);
        this.setText(title);
        this.addStyleName(style.confirmationDialog());
        this.setGlassEnabled(true);
    }

    private Panel createPanel(String styleName) {
        FlowPanel panel = new FlowPanel();
        panel.setStyleName(styleName);
        return panel;
    }

    private void addMessageText(String text) {
        Label label = new Label(text);
        label.addStyleName(style.infoText());
        this.mainPanel.add((Widget)label);
    }

    private ConfirmationDialog addButton(String text, boolean primary, ClickHandler clickHandler) {
        Button button = new Button(text);
        button.addClickHandler(event -> {
            clickHandler.onClick(event);
            this.hide();
        });
        button.addStyleName(style.dialogButton());
        button.addStyleName("btn-lg");
        if (primary) {
            button.addStyleName("btn-primary");
            DialogUtils.linkEnterToButton(button, new HasAllKeyHandlers[]{this.hiddenBox});
        } else {
            button.addStyleName("btn-secondary");
            DialogUtils.linkEscapeToButton(button, new HasAllKeyHandlers[]{this.hiddenBox});
        }
        this.buttonsPanel.add((Widget)button);
        return this;
    }

    public void center() {
        super.center();
        this.hiddenBox.setFocus(true);
    }
}

