/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.slider;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.Touch;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RequiresResize;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class SliderBar
extends FocusPanel
implements RequiresResize,
HasValue<Double>,
HasValueChangeHandlers<Double> {
    protected Double curValue;
    protected Image knobImage = new Image();
    private KeyTimer keyTimer = new KeyTimer();
    protected List<Element> tickLabelElements = new ArrayList<Element>();
    protected List<Element> markerLabelElements = new ArrayList<Element>();
    protected LabelFormatter tickLabelFormatter;
    protected Element lineElement;
    protected int lineLeftOffset = 0;
    protected Double maxValue;
    protected Double minValue;
    private int numTickLabels = 0;
    protected int numTicks = 0;
    private boolean slidingKeyboard = false;
    private boolean slidingMouse = false;
    protected boolean enabled = true;
    private SliderBarImages images;
    protected double stepSize;
    protected List<Element> tickElements = new ArrayList<Element>();
    protected List<Element> markerElements = new ArrayList<Element>();
    private List<Marker> markers = new ArrayList<Marker>();

    public SliderBar() {
        this(null, null, null);
    }

    public SliderBar(double minValue, double maxValue) {
        this(minValue, maxValue, null);
    }

    public SliderBar(Double minValue, Double maxValue, LabelFormatter tickLabelFormatter) {
        this(minValue, maxValue, tickLabelFormatter, SliderBarImages.INSTANCE);
    }

    public SliderBar(Double minValue, Double maxValue, LabelFormatter tickLabelFormatter, SliderBarImages images) {
        images.sliderBarCss().ensureInjected();
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.images = images;
        this.setLabelFormatter(tickLabelFormatter);
        this.getElement().getStyle().setPosition(Style.Position.RELATIVE);
        this.setStyleName("gwt-SliderBar-shell");
        this.lineElement = DOM.createDiv();
        DOM.appendChild((Element)this.getElement(), (Element)this.lineElement);
        this.lineElement.getStyle().setPosition(Style.Position.ABSOLUTE);
        this.lineElement.setPropertyString("className", "gwt-SliderBar-line");
        this.knobImage.setResource(images.slider());
        com.google.gwt.user.client.Element knobElement = this.knobImage.getElement();
        DOM.appendChild((Element)this.getElement(), (Element)knobElement);
        knobElement.getStyle().setPosition(Style.Position.ABSOLUTE);
        knobElement.setPropertyString("className", "gwt-SliderBar-knob");
        this.sinkEvents(15735804);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                SliderBar.this.onResize();
            }
        });
    }

    public boolean isMinMaxInitialized() {
        return this.minValue != null && this.maxValue != null;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Double> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Double getCurrentValue() {
        return this.curValue;
    }

    public LabelFormatter getLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public int getNumLabels() {
        return this.numTickLabels;
    }

    public int getNumTicks() {
        return this.numTicks;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public double getTotalRange() {
        if (this.minValue == null || this.maxValue == null || this.minValue > this.maxValue) {
            return 0.0;
        }
        return this.maxValue - this.minValue;
    }

    public Double getValue() {
        return this.curValue;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        if (this.enabled) {
            switch (DOM.eventGetType((Event)event)) {
                case 4096: {
                    this.keyTimer.cancel();
                    if (this.slidingMouse) {
                        DOM.releaseCapture((Element)this.getElement());
                        this.slidingMouse = false;
                        this.slideKnob(event.getClientX());
                        this.stopSliding(true, true);
                    } else if (this.slidingKeyboard) {
                        this.slidingKeyboard = false;
                        this.stopSliding(true, true);
                    }
                    this.unhighlight();
                    break;
                }
                case 2048: {
                    this.highlight();
                    break;
                }
                case 131072: {
                    double velocityY = event.getDeltaY();
                    event.preventDefault();
                    if (velocityY > 0.0) {
                        this.shiftRight(1);
                        break;
                    }
                    this.shiftLeft(1);
                    break;
                }
                case 128: {
                    if (this.slidingKeyboard) break;
                    int multiplier = 1;
                    if (event.getCtrlKey()) {
                        multiplier = (int)(this.getTotalRange() / this.stepSize / 10.0);
                    }
                    switch (event.getKeyCode()) {
                        case 36: {
                            event.preventDefault();
                            this.setCurrentValue(this.minValue);
                            break;
                        }
                        case 35: {
                            event.preventDefault();
                            this.setCurrentValue(this.maxValue);
                            break;
                        }
                        case 37: {
                            event.preventDefault();
                            this.slidingKeyboard = true;
                            this.startSliding(false, true);
                            this.shiftLeft(multiplier);
                            this.keyTimer.schedule(400, false, multiplier);
                            break;
                        }
                        case 39: {
                            event.preventDefault();
                            this.slidingKeyboard = true;
                            this.startSliding(false, true);
                            this.shiftRight(multiplier);
                            this.keyTimer.schedule(400, true, multiplier);
                            break;
                        }
                        case 32: {
                            event.preventDefault();
                            this.setCurrentValue(this.minValue + this.getTotalRange() / 2.0);
                        }
                    }
                    break;
                }
                case 512: {
                    this.keyTimer.cancel();
                    if (!this.slidingKeyboard) break;
                    this.slidingKeyboard = false;
                    this.stopSliding(true, true);
                    break;
                }
                case 4: {
                    event.preventDefault();
                    this.startSlidingAtX(event.getClientX());
                    break;
                }
                case 8: {
                    if (!this.slidingMouse) break;
                    DOM.releaseCapture((Element)this.getElement());
                    this.slidingMouse = false;
                    this.slideKnob(event.getClientX());
                    this.stopSliding(true, true);
                    break;
                }
                case 64: {
                    if (!this.slidingMouse) break;
                    this.slideKnob(event.getClientX());
                    break;
                }
                case 0x100000: {
                    event.preventDefault();
                    this.startSlidingAtX(((Touch)event.getTouches().get(0)).getClientX());
                    break;
                }
                case 0x200000: {
                    if (!this.slidingMouse) break;
                    this.slideKnob(((Touch)event.getTouches().get(event.getTouches().length() - 1)).getClientX());
                    break;
                }
                case 0x400000: {
                    if (!this.slidingMouse) break;
                    DOM.releaseCapture((Element)this.getElement());
                    this.slidingMouse = false;
                    this.slideKnob(((Touch)event.getTouches().get(event.getTouches().length() - 1)).getClientX());
                    this.stopSliding(true, true);
                }
            }
        }
    }

    private void startSlidingAtX(int clientX) {
        this.setFocus(true);
        this.slidingMouse = true;
        DOM.setCapture((Element)this.getElement());
        this.startSliding(true, true);
        this.slideKnob(clientX);
    }

    public void onResize(int width, int height) {
        int lineWidth = this.lineElement.getOffsetWidth();
        this.lineLeftOffset = width / 2 - lineWidth / 2;
        this.lineElement.getStyle().setLeft((double)this.lineLeftOffset, Style.Unit.PX);
        this.drawTickLabels();
        this.drawTicks();
        this.drawMarkers();
        this.drawMarkerLabels();
        this.drawKnob();
    }

    public void redraw() {
        if (this.isAttached()) {
            int width = this.getElement().getClientWidth();
            int height = this.getElement().getClientHeight();
            this.onResize(width, height);
        }
    }

    public synchronized void setCurrentValue(Double curValue) {
        this.setCurrentValue(curValue, true);
    }

    public synchronized void setCurrentValue(Double curValue, boolean fireEvent) {
        if (!this.isMinMaxInitialized() || curValue == null) {
            return;
        }
        Double newValue = Math.max(this.minValue, Math.min(this.maxValue, curValue));
        double remainder = (newValue - this.minValue) % this.stepSize;
        newValue = newValue - remainder;
        if (remainder > this.stepSize / 2.0 && newValue + this.stepSize <= this.maxValue) {
            newValue = newValue + this.stepSize;
        }
        boolean isValueChanged = !newValue.equals(this.curValue) && this.curValue != null;
        this.curValue = newValue;
        this.drawKnob();
        if (fireEvent && isValueChanged) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.curValue);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.knobImage.setResource(this.images.slider());
            this.lineElement.setPropertyString("className", "gwt-SliderBar-line");
        } else {
            this.knobImage.setResource(this.images.sliderDisabled());
            this.lineElement.setPropertyString("className", "gwt-SliderBar-line gwt-SliderBar-line-disabled");
        }
        this.redraw();
    }

    public void setLabelFormatter(LabelFormatter labelFormatter) {
        this.tickLabelFormatter = labelFormatter;
    }

    public void setMaxValue(Double maxValue, boolean fireEvent) {
        if (!Util.equalsWithNull((Object)maxValue, (Object)this.maxValue)) {
            this.maxValue = maxValue;
            this.onMinMaxValueChanged(fireEvent);
        }
    }

    public void setMinValue(Double minValue, boolean fireEvent) {
        if (!Util.equalsWithNull((Object)minValue, (Object)this.minValue)) {
            this.minValue = minValue;
            this.onMinMaxValueChanged(fireEvent);
        }
    }

    public Optional<Util.Pair<Double, Double>> setMinAndMaxValue(Double minValue, Double maxValue, boolean fireEvent) {
        boolean changed = false;
        if (!Util.equalsWithNull((Object)minValue, (Object)this.minValue)) {
            this.minValue = minValue;
            changed = true;
        }
        if (!Util.equalsWithNull((Object)maxValue, (Object)this.maxValue)) {
            this.maxValue = maxValue;
            changed = true;
        }
        if (changed) {
            this.onMinMaxValueChanged(fireEvent);
            return Optional.of(new Util.Pair((Object)this.minValue, (Object)this.maxValue));
        }
        return Optional.empty();
    }

    protected void onMinMaxValueChanged(boolean fireEvent) {
        this.redraw();
        this.resetCurrentValue(fireEvent);
    }

    public void setNumTickLabels(int numTickLabels) {
        this.numTickLabels = numTickLabels;
        this.drawTickLabels();
    }

    public void setNumTicks(int numTicks) {
        this.numTicks = numTicks;
        this.drawTicks();
    }

    public void setStepSize(double stepSize, boolean fireEvent) {
        this.stepSize = stepSize;
        this.resetCurrentValue(fireEvent);
    }

    public void setValue(Double value) {
        this.setCurrentValue(value, false);
    }

    public void setValue(Double value, boolean fireEvent) {
        this.setCurrentValue(value, fireEvent);
    }

    public void shiftLeft(int numSteps) {
        this.setCurrentValue(this.getCurrentValue() - (double)numSteps * this.stepSize);
    }

    public void shiftRight(int numSteps) {
        this.setCurrentValue(this.getCurrentValue() + (double)numSteps * this.stepSize);
    }

    protected String formatTickLabel(Double value, Double previousValue) {
        String result = this.tickLabelFormatter != null ? this.tickLabelFormatter.formatLabel(this, value, previousValue) : String.valueOf((double)((int)(10.0 * value)) / 10.0);
        return result;
    }

    protected double getKnobPercent() {
        if (this.maxValue <= this.minValue) {
            return 0.0;
        }
        double percent = (this.curValue - this.minValue) / (this.maxValue - this.minValue);
        return Math.max(0.0, Math.min(1.0, percent));
    }

    protected void onLoad() {
        this.getElement().getStyle().setPosition(Style.Position.RELATIVE);
    }

    protected void drawKnob() {
        if (this.isAttached() && this.isMinMaxInitialized()) {
            com.google.gwt.user.client.Element knobElement = this.knobImage.getElement();
            int lineWidth = this.lineElement.getOffsetWidth();
            int knobWidth = knobElement.getOffsetWidth();
            int knobLeftOffset = (int)((double)this.lineLeftOffset + this.getKnobPercent() * (double)lineWidth - (double)(knobWidth / 2));
            knobLeftOffset = Math.min(knobLeftOffset, this.lineLeftOffset + lineWidth - knobWidth / 2 - 1);
            knobElement.getStyle().setLeft((double)knobLeftOffset, Style.Unit.PX);
        }
    }

    protected void drawTickLabels() {
        block9: {
            if (!this.isAttached() || !this.isMinMaxInitialized()) break block9;
            int lineWidth = this.lineElement.getOffsetWidth();
            if (this.numTickLabels > 0) {
                Double previousValue = null;
                int i = 0;
                while (i <= this.numTickLabels) {
                    com.google.gwt.user.client.Element label = null;
                    if (i < this.tickLabelElements.size()) {
                        label = this.tickLabelElements.get(i);
                    } else {
                        label = DOM.createDiv();
                        label.getStyle().setPosition(Style.Position.ABSOLUTE);
                        label.getStyle().setDisplay(Style.Display.NONE);
                        if (this.enabled) {
                            label.setPropertyString("className", "gwt-SliderBar-ticklabel");
                        } else {
                            label.setPropertyString("className", "gwt-SliderBar-ticklabel-disabled");
                        }
                        DOM.appendChild((Element)this.getElement(), (Element)label);
                        this.tickLabelElements.add((Element)label);
                    }
                    double value = this.minValue + this.getTotalRange() * (double)i / (double)this.numTickLabels;
                    label.getStyle().setVisibility(Style.Visibility.HIDDEN);
                    label.getStyle().setProperty("display", "");
                    label.setPropertyString("innerHTML", this.formatTickLabel(value, previousValue));
                    label.getStyle().setLeft(0.0, Style.Unit.PX);
                    int labelWidth = label.getOffsetWidth();
                    int labelLeftOffset = this.lineLeftOffset + lineWidth * i / this.numTickLabels - labelWidth / 2;
                    labelLeftOffset = Math.min(labelLeftOffset, this.lineLeftOffset + lineWidth - labelWidth);
                    labelLeftOffset = Math.max(labelLeftOffset, this.lineLeftOffset);
                    label.getStyle().setLeft((double)labelLeftOffset, Style.Unit.PX);
                    label.getStyle().setVisibility(Style.Visibility.VISIBLE);
                    previousValue = value;
                    ++i;
                }
                i = this.numTickLabels + 1;
                while (i < this.tickLabelElements.size()) {
                    this.tickLabelElements.get(i).getStyle().setDisplay(Style.Display.NONE);
                    ++i;
                }
            } else {
                for (Element elem : this.tickLabelElements) {
                    elem.getStyle().setDisplay(Style.Display.NONE);
                }
            }
        }
    }

    protected void drawTicks() {
        block9: {
            if (!this.isAttached() || !this.isMinMaxInitialized()) break block9;
            int lineWidth = this.lineElement.getOffsetWidth();
            if (this.numTicks > 0) {
                int i = 0;
                while (i <= this.numTicks) {
                    com.google.gwt.user.client.Element tick = null;
                    if (i < this.tickElements.size()) {
                        tick = this.tickElements.get(i);
                    } else {
                        tick = DOM.createDiv();
                        tick.getStyle().setPosition(Style.Position.ABSOLUTE);
                        tick.getStyle().setDisplay(Style.Display.NONE);
                        DOM.appendChild((Element)this.getElement(), (Element)tick);
                        this.tickElements.add((Element)tick);
                    }
                    if (this.enabled) {
                        tick.setPropertyString("className", "gwt-SliderBar-tick");
                    } else {
                        tick.setPropertyString("className", "gwt-SliderBar-tick gwt-SliderBar-tick-disabled");
                    }
                    tick.getStyle().setVisibility(Style.Visibility.HIDDEN);
                    tick.getStyle().setProperty("display", "");
                    int tickWidth = tick.getOffsetWidth();
                    int tickLeftOffset = this.lineLeftOffset + lineWidth * i / this.numTicks - tickWidth / 2;
                    tickLeftOffset = Math.min(tickLeftOffset, this.lineLeftOffset + lineWidth - tickWidth);
                    tick.getStyle().setLeft((double)tickLeftOffset, Style.Unit.PX);
                    tick.getStyle().setVisibility(Style.Visibility.VISIBLE);
                    ++i;
                }
                i = this.numTicks + 1;
                while (i < this.tickElements.size()) {
                    this.tickElements.get(i).getStyle().setDisplay(Style.Display.NONE);
                    ++i;
                }
            } else {
                for (Element elem : this.tickElements) {
                    elem.getStyle().setDisplay(Style.Display.NONE);
                }
            }
        }
    }

    private void drawMarkers() {
        block10: {
            if (!this.isAttached() || !this.isMinMaxInitialized()) break block10;
            int numMarkers = this.markers.size();
            int lineWidth = this.lineElement.getOffsetWidth();
            if (numMarkers > 0) {
                com.google.gwt.user.client.Element lastMarkerElement = null;
                int lastMarkerOffsetLeft = 0;
                int i = 0;
                while (i < numMarkers) {
                    Marker marker = this.markers.get(i);
                    com.google.gwt.user.client.Element markerElem = null;
                    if (i < this.markerElements.size()) {
                        markerElem = this.markerElements.get(i);
                    } else {
                        markerElem = DOM.createDiv();
                        markerElem.getStyle().setPosition(Style.Position.ABSOLUTE);
                        markerElem.getStyle().setDisplay(Style.Display.NONE);
                        markerElem.setAttribute("selenium-id", "sliderBarMarker-" + marker.name);
                        DOM.appendChild((Element)this.getElement(), (Element)markerElem);
                        this.markerElements.add((Element)markerElem);
                    }
                    markerElem.setTitle(this.formatTickLabel(marker.position, null));
                    if (this.enabled) {
                        markerElem.setPropertyString("className", "gwt-SliderBar-mark");
                    } else {
                        markerElem.setPropertyString("className", "gwt-SliderBar-mark gwt-SliderBar-mark-disabled");
                    }
                    markerElem.getStyle().setVisibility(Style.Visibility.HIDDEN);
                    markerElem.getStyle().setProperty("display", "");
                    double markerLinePosition = (marker.position - this.minValue) * (double)lineWidth / this.getTotalRange();
                    int markerWidth = markerElem.getOffsetWidth();
                    int markerLeftOffset = this.lineLeftOffset + (int)markerLinePosition - markerWidth / 2;
                    markerLeftOffset = Math.min(markerLeftOffset, this.lineLeftOffset + lineWidth - markerWidth);
                    markerElem.getStyle().setLeft((double)markerLeftOffset, Style.Unit.PX);
                    markerElem.getStyle().setVisibility(Style.Visibility.VISIBLE);
                    if (lastMarkerOffsetLeft > 0 && markerLeftOffset - lastMarkerOffsetLeft <= markerWidth && lastMarkerElement != null) {
                        lastMarkerElement.setPropertyString("className", "gwt-SliderBar-mark-tooClose");
                        lastMarkerElement.getStyle().setLeft((double)(markerLeftOffset - 10), Style.Unit.PX);
                    }
                    lastMarkerElement = markerElem;
                    lastMarkerOffsetLeft = markerLeftOffset;
                    ++i;
                }
                i = numMarkers;
                while (i < this.markerElements.size()) {
                    this.markerElements.get(i).getStyle().setDisplay(Style.Display.NONE);
                    ++i;
                }
            } else {
                for (Element elem : this.markerElements) {
                    elem.getStyle().setDisplay(Style.Display.NONE);
                }
            }
        }
    }

    private void drawMarkerLabels() {
        block12: {
            if (!this.isAttached() || !this.isMinMaxInitialized()) break block12;
            int numMarkers = this.markers.size();
            int lineWidth = this.lineElement.getOffsetWidth();
            if (numMarkers > 0) {
                com.google.gwt.user.client.Element lastMarkerLabel = null;
                Marker lastMarker = null;
                int lastMarkerLabelOffsetLeft = 0;
                int i = 0;
                while (i < numMarkers) {
                    Marker marker = this.markers.get(i);
                    com.google.gwt.user.client.Element label = null;
                    if (i < this.markerLabelElements.size()) {
                        label = this.markerLabelElements.get(i);
                    } else {
                        label = DOM.createDiv();
                        label.getStyle().setPosition(Style.Position.ABSOLUTE);
                        label.getStyle().setDisplay(Style.Display.NONE);
                        DOM.appendChild((Element)this.getElement(), (Element)label);
                        this.markerLabelElements.add((Element)label);
                    }
                    label.setTitle(this.formatTickLabel(marker.position, null));
                    if (this.enabled) {
                        label.setPropertyString("className", "gwt-SliderBar-markerlabel");
                    } else {
                        label.setPropertyString("className", "gwt-SliderBar-markerlabel-disabled");
                    }
                    label.getStyle().setVisibility(Style.Visibility.HIDDEN);
                    label.getStyle().setProperty("display", "");
                    label.setPropertyString("innerHTML", marker.name);
                    label.getStyle().setLeft(0.0, Style.Unit.PX);
                    double markerLinePosition = (marker.position - this.minValue) * (double)lineWidth / this.getTotalRange();
                    int labelWidth = label.getOffsetWidth();
                    int labelLeftOffset = this.lineLeftOffset + (int)markerLinePosition - labelWidth / 2;
                    labelLeftOffset = Math.min(labelLeftOffset, this.lineLeftOffset + lineWidth - labelWidth);
                    label.getStyle().setLeft((double)labelLeftOffset, Style.Unit.PX);
                    label.getStyle().setVisibility(Style.Visibility.VISIBLE);
                    if (lastMarkerLabelOffsetLeft > 0 && labelLeftOffset - lastMarkerLabelOffsetLeft <= 20 && lastMarkerLabel != null && lastMarker != null) {
                        lastMarkerLabel.setPropertyString("className", "gwt-SliderBar-markerlabel-tooClose");
                        lastMarkerLabel.setPropertyString("innerHTML", lastMarker.name);
                        int currentMarkerOffsetLeft = labelLeftOffset;
                        try {
                            currentMarkerOffsetLeft = Integer.parseInt(this.markerElements.get(i).getStyle().getLeft().replace("px", ""));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        lastMarkerLabel.getStyle().setLeft((double)(currentMarkerOffsetLeft - 8), Style.Unit.PX);
                    }
                    lastMarker = marker;
                    lastMarkerLabel = label;
                    lastMarkerLabelOffsetLeft = labelLeftOffset;
                    ++i;
                }
                i = numMarkers + 1;
                while (i < this.markerLabelElements.size()) {
                    this.markerLabelElements.get(i).getStyle().setDisplay(Style.Display.NONE);
                    ++i;
                }
            } else {
                for (Element elem : this.markerLabelElements) {
                    elem.getStyle().setDisplay(Style.Display.NONE);
                }
            }
        }
    }

    private void highlight() {
        String styleName = this.getStylePrimaryName();
        this.getElement().setPropertyString("className", String.valueOf(styleName) + " " + styleName + "-focused");
    }

    private synchronized void resetCurrentValue(boolean fireEvent) {
        this.setCurrentValue(this.getCurrentValue(), fireEvent);
    }

    private void slideKnob(int clientX) {
        int x = clientX + Window.getScrollLeft();
        if (x > 0) {
            int lineWidth = this.lineElement.getOffsetWidth();
            int lineLeft = this.lineElement.getAbsoluteLeft();
            double percent = (double)(x - lineLeft) / (double)lineWidth * 1.0;
            this.setCurrentValue(this.getTotalRange() * percent + this.minValue, true);
        }
    }

    private void startSliding(boolean highlight, boolean fireEvent) {
        if (highlight) {
            this.lineElement.setPropertyString("className", "gwt-SliderBar-line gwt-SliderBar-line-sliding");
            this.knobImage.getElement().setPropertyString("className", "gwt-SliderBar-knob gwt-SliderBar-knob-sliding");
            this.knobImage.setResource(this.images.sliderSliding());
        }
    }

    private void stopSliding(boolean unhighlight, boolean fireEvent) {
        if (unhighlight) {
            this.lineElement.setPropertyString("className", "gwt-SliderBar-line");
            this.knobImage.getElement().setPropertyString("className", "gwt-SliderBar-knob");
            this.knobImage.setResource(this.images.slider());
        }
    }

    private void unhighlight() {
        this.getElement().setPropertyString("className", this.getStylePrimaryName());
    }

    public void onResize() {
        this.redraw();
    }

    public void clearMarkers() {
        this.markers.clear();
    }

    public boolean addMarker(String markerName, Double markerPosition) {
        return this.markers.add(new Marker(markerName, markerPosition));
    }

    public boolean setMarker(String markerName, Double markerPosition) {
        Marker marker = this.findMarkerByName(markerName);
        if (marker != null) {
            marker.position = markerPosition;
            return true;
        }
        return false;
    }

    public boolean removeMarker(String markerName) {
        Marker marker = this.findMarkerByName(markerName);
        if (marker != null) {
            return this.markers.remove(marker);
        }
        return false;
    }

    public Iterator<Marker> getMarkers() {
        return this.markers.iterator();
    }

    private Marker findMarkerByName(String markerName) {
        for (Marker marker : this.markers) {
            if (!marker.name.equals(markerName)) continue;
            return marker;
        }
        return null;
    }

    private class KeyTimer
    extends Timer {
        private boolean firstRun = true;
        private int repeatDelay = 30;
        private boolean shiftRight = false;
        private int multiplier = 1;

        private KeyTimer() {
        }

        public void run() {
            if (this.firstRun) {
                this.firstRun = false;
                SliderBar.this.startSliding(true, false);
            }
            if (this.shiftRight) {
                SliderBar.this.setCurrentValue(SliderBar.this.curValue + (double)this.multiplier * SliderBar.this.stepSize);
            } else {
                SliderBar.this.setCurrentValue(SliderBar.this.curValue - (double)this.multiplier * SliderBar.this.stepSize);
            }
            this.schedule(this.repeatDelay);
        }

        public void schedule(int delayMillis, boolean shiftRight, int multiplier) {
            this.firstRun = true;
            this.shiftRight = shiftRight;
            this.multiplier = multiplier;
            super.schedule(delayMillis);
        }
    }

    public static interface LabelFormatter {
        public String formatLabel(SliderBar var1, Double var2, Double var3);
    }

    private class Marker {
        String name;
        Double position;

        public Marker(String name, Double position) {
            this.name = name;
            this.position = position;
        }
    }

    public static interface SliderBarImages
    extends ClientBundle {
        public static final SliderBarImages INSTANCE = (SliderBarImages)GWT.create(SliderBarImages.class);

        @ClientBundle.Source(value={"slider_blue.png"})
        public ImageResource slider();

        @ClientBundle.Source(value={"slider_blue.png"})
        public ImageResource sliderDisabled();

        @ClientBundle.Source(value={"slider_blue.png"})
        public ImageResource sliderSliding();

        @CssResource.NotStrict
        @ClientBundle.Source(value={"SliderBar.css"})
        public CssResource sliderBarCss();
    }
}

