/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.listedit;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.listedit.CollapsedListEditorUi;
import com.sap.sse.gwt.client.controls.listedit.ExpandedListEditorUi;
import com.sap.sse.gwt.client.controls.listedit.ListEditorComposite;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUiStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StringConstantsListEditorComposite
extends ListEditorComposite<String> {
    public StringConstantsListEditorComposite(Iterable<String> initialValues, StringMessages stringMessages, String popupDialogTitle, ImageResource removeImage, Iterable<String> availableConstantValuesToAdd) {
        this(initialValues, stringMessages, popupDialogTitle, removeImage, availableConstantValuesToAdd, null);
    }

    public StringConstantsListEditorComposite(Iterable<String> initialValues, StringMessages stringMessages, String popupDialogTitle, ImageResource removeImage, Iterable<String> availableConstantValuesToAdd, String placeholderTextForAddTextbox) {
        super(initialValues, new CollapsedUi(stringMessages, popupDialogTitle, new ExpandedUi(stringMessages, removeImage, availableConstantValuesToAdd, placeholderTextForAddTextbox)));
    }

    public StringConstantsListEditorComposite(Iterable<String> initialValues, StringMessages stringMessages, ImageResource removeImage, Iterable<String> availableConstantValuesToAdd) {
        super(initialValues, new ExpandedUi(stringMessages, removeImage, availableConstantValuesToAdd));
    }

    public StringConstantsListEditorComposite(Iterable<String> initialValues, StringMessages stringMessages, ImageResource removeImage, Iterable<String> availableConstantValuesToAdd, String placeholderTextForAddTextbox) {
        super(initialValues, new ExpandedUi(stringMessages, removeImage, availableConstantValuesToAdd, placeholderTextForAddTextbox));
    }

    public StringConstantsListEditorComposite(Iterable<String> initialValues, ListEditorUiStrategy<String> activeUi) {
        super(initialValues, activeUi);
    }

    public static class CollapsedUi
    extends CollapsedListEditorUi<String> {
        public CollapsedUi(StringMessages stringMessages, String dialogTitle, ExpandedListEditorUi<String> expandedUi) {
            super(stringMessages, dialogTitle, expandedUi);
        }

        @Override
        protected String getCollapsedValueText(Iterable<String> value) {
            StringBuilder valuesText = new StringBuilder();
            int i = 0;
            while (i < Util.size(value)) {
                if (i > 0) {
                    valuesText.append(',');
                }
                valuesText.append((String)Util.get(value, (int)i));
                ++i;
            }
            String condensedValue = valuesText.toString();
            return condensedValue;
        }

        @Override
        protected ListEditorComposite<String> createExpandedUi(Iterable<String> initialValues, ExpandedListEditorUi<String> ui) {
            return new StringConstantsListEditorComposite(initialValues, (ListEditorUiStrategy<String>)ui);
        }
    }

    public static class ExpandedUi
    extends ExpandedListEditorUi<String> {
        protected final String placeholderTextForAddListbox;
        protected final List<String> availableConstantValuesToAdd = new ArrayList<String>();
        private ListBox selectionBox;

        public ExpandedUi(StringMessages stringMessages, ImageResource removeImage, Iterable<String> availableConstantValuesToAdd) {
            this(stringMessages, removeImage, availableConstantValuesToAdd, null);
        }

        public ExpandedUi(StringMessages stringMessages, ImageResource removeImage, Iterable<String> constantValuesToAdd, String placeholderTextForAddListbox) {
            super(stringMessages, removeImage, true);
            Util.addAll(constantValuesToAdd, this.availableConstantValuesToAdd);
            Collections.sort(this.availableConstantValuesToAdd);
            this.placeholderTextForAddListbox = placeholderTextForAddListbox;
            this.selectionBox = null;
        }

        @Override
        public void setContext(final ListEditorComposite<String> context) {
            super.setContext(context);
            context.addValueChangeHandler(new ValueChangeHandler<Iterable<String>>(){

                public void onValueChange(ValueChangeEvent<Iterable<String>> event) {
                    if (selectionBox != null) {
                        ArrayList diffList = new ArrayList();
                        Util.addAll(availableConstantValuesToAdd, diffList);
                        diffList.removeAll((Collection<?>)context.getValue());
                        Collections.sort(diffList);
                        this.updateSelectionListBox(selectionBox, diffList);
                    }
                }
            });
        }

        private void updateSelectionListBox(ListBox listBox, Iterable<String> values) {
            listBox.clear();
            if (this.placeholderTextForAddListbox != null) {
                listBox.addItem(this.placeholderTextForAddListbox);
            } else {
                listBox.addItem(this.getStringMessages().pleaseSelect());
            }
            for (String value : values) {
                listBox.addItem(value);
            }
        }

        protected ListBox createListBox() {
            ListBox result = new ListBox();
            result.setMultipleSelect(false);
            this.updateSelectionListBox(result, this.availableConstantValuesToAdd);
            return result;
        }

        @Override
        protected Widget createAddWidget() {
            this.selectionBox = this.createListBox();
            this.selectionBox.ensureDebugId("SelectionListBox");
            final Button addButton = new Button(this.getStringMessages().add());
            addButton.ensureDebugId("AddButton");
            addButton.setEnabled(false);
            addButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int selIndex = selectionBox.getSelectedIndex();
                    String seletedItemText = selectionBox.getValue(selIndex);
                    this.addValue(seletedItemText);
                    selectionBox.setSelectedIndex(0);
                    addButton.setEnabled(false);
                }
            });
            this.selectionBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int selIndex = selectionBox.getSelectedIndex();
                    addButton.setEnabled(selIndex > 0);
                }
            });
            HorizontalPanel panel = new HorizontalPanel();
            panel.add((Widget)this.selectionBox);
            panel.add((Widget)addButton);
            return panel;
        }

        @Override
        protected Widget createValueWidget(int rowIndex, String newValue) {
            return new Label(newValue);
        }
    }
}

