/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.listedit;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.listedit.GenericStringListEditorComposite;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUiStrategy;

public abstract class GenericStringListInlineEditorComposite<ValueType>
extends GenericStringListEditorComposite<ValueType> {
    public GenericStringListInlineEditorComposite(Iterable<ValueType> initialValues, StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues, int textBoxSize) {
        super(initialValues, new ExpandedUi(stringMessages, removeImage, suggestValues, textBoxSize));
    }

    public GenericStringListInlineEditorComposite(Iterable<ValueType> initialValues, ListEditorUiStrategy<ValueType> activeUi) {
        super(initialValues, activeUi);
    }

    public static class ExpandedUi<ValueType>
    extends GenericStringListEditorComposite.ExpandedUi<ValueType> {
        private final int textBoxSize;

        public ExpandedUi(StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues, int textBoxSize) {
            this(stringMessages, removeImage, suggestValues, (String)null, textBoxSize);
        }

        public ExpandedUi(StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues, String placeholderTextForAddTextbox, int textBoxSize) {
            super(stringMessages, removeImage, suggestValues, placeholderTextForAddTextbox);
            this.textBoxSize = textBoxSize;
        }

        @Override
        protected SuggestBox createSuggestBox() {
            SuggestBox result = super.createSuggestBox();
            InputElement inputElement = (InputElement)result.getElement().cast();
            inputElement.setSize(this.textBoxSize);
            return result;
        }

        @Override
        protected Widget createValueWidget(final int rowIndex, ValueType newValue) {
            final TextBox textBox = new TextBox();
            textBox.setVisibleLength(this.textBoxSize);
            textBox.ensureDebugId("ValueTextBox");
            textBox.setValue((Object)this.getContext().toString(newValue));
            textBox.addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    textBox.setFocus(false);
                    textBox.setFocus(true);
                }
            });
            textBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    Object oldValue = this.getContext().getValue().get(rowIndex);
                    Object newValue = this.getContext().parse((String)event.getValue(), oldValue);
                    this.setValueFromValueWidget((Widget)textBox, newValue, true);
                }
            });
            return textBox;
        }
    }
}

